/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.sym.adsm.common.server.admin.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.commandline.Command;
import com.adventnet.sym.adsm.common.server.commandline.LeafCommand;
import com.adventnet.sym.adsm.common.server.commandline.StemCommand;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import java.util.LinkedHashMap;

public class AccountCmd
extends StemCommand {
    public final Command help = new LeafCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            AccountCmd.this.processHelp();
        }
    };
    public final Command reset_password = new LeafCommand(this.getCmdId() + "1", "reset-password", "Resets user's password"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            AccountCmd.this.resetPassword(cmdStr, processIndex);
        }
    };
    public final Command logout = new LeafCommand(this.getCmdId() + "2", "logout", "Logs out user's session"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
        }
    };

    public AccountCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, Command> childCmdList = new LinkedHashMap<String, Command>();
        childCmdList.put(this.help.getCmdId(), this.help);
        childCmdList.put(this.reset_password.getCmdId(), this.reset_password);
        childCmdList.put(this.logout.getCmdId(), this.logout);
        this.setChildCmdList(childCmdList);
    }

    private void resetPassword(String[] cmdStr, int processIndex) throws Exception {
        int cmdLen = cmdStr.length;
        if (processIndex + 1 == cmdLen) {
            this.ioHandle().print("\n# Resetting current user's password is not implemented!!\n\n");
        } else if (processIndex + 3 == cmdLen) {
            String userName = cmdStr[processIndex + 2];
            if (userName.toLowerCase().equals("admin")) {
                String serviceName = ADSMPersUtil.getServiceName((String)"admin");
                String newPassword = PasswordGenerator.generatePassword();
                AuthUtil.changePassword((String)"admin", (String)serviceName, (String)newPassword);
                this.ioHandle().print("\n# Password has been successfully reset. Your New Password for default admin user is " + newPassword + " \n");
            } else {
                this.ioHandle().print("\n# You dont't have privileges to reset this account's password!!\n\n");
            }
        } else {
            this.ioHandle().print("\n  Invalid parameters!\n\n  Usage :\n\taccount reset-password [-u <username>]\n\n");
        }
    }
}

