/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Function;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.eventcollection.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.commandline.Command;
import com.adventnet.sym.adsm.common.server.commandline.LeafCommand;
import com.adventnet.sym.adsm.common.server.commandline.StemCommand;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.ShareHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.json.JSONObject;

public class AddServerCmd
extends StemCommand {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public final Command help = new LeafCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            AddServerCmd.this.processHelp();
        }
    };
    public final Command usage = new LeafCommand(this.getCmdId() + "1", "usage", "Usage of server commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            AddServerCmd.this.AddServerCmdUsage();
        }
    };
    public final Command add = new LeafCommand(this.getCmdId() + "2", "add", "Addition of Bulk Servers"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            AddServerCmd.this.addServer(cmdStr, processIndex);
        }
    };

    public AddServerCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, Command> childCmdList = new LinkedHashMap<String, Command>();
        childCmdList.put(this.help.getCmdId(), this.help);
        childCmdList.put(this.usage.getCmdId(), this.usage);
        childCmdList.put(this.add.getCmdId(), this.add);
        this.setChildCmdList(childCmdList);
    }

    public void addServer(String[] cmdStr, int processIndex) throws Exception {
        block44: {
            try {
                int length = cmdStr.length;
                if (length == 11 || length == 7 || length == 5) {
                    String homeDir = System.getProperty("server.dir");
                    ArrayList<String> serverList = new ArrayList<String>();
                    String SERVER_FILE_PATH = homeDir.substring(0, homeDir.length() - 2) + "\\servers.csv";
                    try {
                        BufferedReader reader = Files.newBufferedReader(Paths.get(SERVER_FILE_PATH, new String[0]), Charset.defaultCharset());
                        Object object = null;
                        try (CSVParser csvParser = new CSVParser((Reader)reader, CSVFormat.DEFAULT);){
                            for (CSVRecord csvRecord : csvParser) {
                                serverList.add(csvRecord.get(0));
                            }
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (reader != null) {
                                if (object != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    ((Reader)reader).close();
                                }
                            }
                        }
                    }
                    catch (NoSuchFileException e) {
                        this.ioHandle().print("# \n\tservers.csv file not found in specified location.\n\tEnter \"server help\" to view list of available commands.\n\n");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.ioHandle().print("# Wrong command! Enter \"server help\" to view list of available commands.\n\n");
                    }
                    String machineType = cmdStr[4];
                    switch (machineType) {
                        case "fs": {
                            this.addFileServers(serverList, cmdStr, processIndex);
                            break;
                        }
                        case "ws": {
                            this.addWorkStations(serverList, cmdStr, 4096);
                            break;
                        }
                        case "ms": {
                            this.addWorkStations(serverList, cmdStr, 16);
                            break;
                        }
                        case "server": {
                            this.addMSFileServer();
                        }
                        default: {
                            this.processNotImplemented();
                            break;
                        }
                    }
                    break block44;
                }
                this.ioHandle().print("\n# Wrong command! Enter \"server help\" to view list of available commands.\n\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addMSFileServer() {
        this.ioHandle().print("\nGetting file servers and file clusters that are using Member servers schedule id\n");
        long machineType = 204L;
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCOMPUTEREVENTREAD"));
        query.addSelectColumn(Column.getColumn((String)"AUDCOMPUTEREVENTREAD", (String)"*"));
        Function columnMachineType = null;
        if (CommonUtil.getDBServerName().equals("mssql")) {
            Function bigintType = Column.createFunction((String)"CAST_AS_BIGINT", (Object[])new Object[]{machineType});
            columnMachineType = Column.createFunction((String)"AND", (Object[])new Object[]{Column.getColumn((String)"AUDCOMPUTEREVENTREAD", (String)"MACHINE_TYPE_LONG"), bigintType});
        } else {
            columnMachineType = Column.createFunction((String)"AND", (Object[])new Object[]{Column.getColumn((String)"AUDCOMPUTEREVENTREAD", (String)"MACHINE_TYPE_LONG"), machineType});
        }
        columnMachineType.setType(-5);
        Criteria crit = new Criteria((Column)columnMachineType, (Object)0, 1);
        crit = crit.and(new Criteria(Column.getColumn((String)"AUDCOMPUTEREVENTREAD", (String)"SCHEDULE_ID"), (Object)DBObjectUtil.getUVHValues((String)"Schedule", (String)"Schedule:schedule_id:UVH@3484"), 0));
        query.setCriteria(crit);
        try {
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            ArrayList readGuids = new ArrayList();
            if (dO.isEmpty()) {
                throw new RuntimeException("AUDCOMPUTEREVENTREAD::file servers doesn't have Member_Server_Events_Scheduler ID");
            }
            dO.getRows("AUDCOMPUTEREVENTREAD").forEachRemaining(row -> {
                Row readRow = (Row)row;
                String objectGuid = (String)readRow.get("OBJECT_GUID");
                readGuids.add(objectGuid);
            });
            Criteria computerCrit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"OBJECT_GUID"), (Object)readGuids.toArray(), 8);
            DataObject computerObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMComputerGeneralDetails", computerCrit);
            if (computerObject.isEmpty()) {
                throw new RuntimeException("No entry in computergeneral table");
            }
            ArrayList schedulerNames = new ArrayList();
            computerObject.getRows("ADSMComputerGeneralDetails").forEachRemaining(row -> {
                Row computerRow = (Row)row;
                String machineName = (String)computerRow.get("NAME");
                String domainName = (String)computerRow.get("DOMAIN_NAME");
                String schedulerName = domainName + "_" + machineName + "_File_Audit_Scheduler";
                schedulerNames.add(schedulerName);
            });
            Criteria scheduleCriteria = new Criteria(Column.getColumn((String)"SCHEDULE", (String)"SCHEDULE_NAME"), (Object)schedulerNames.toArray(), 8);
            DataObject scheduleDo = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SCHEDULE", scheduleCriteria);
            computerObject.getRows("ADSMComputerGeneralDetails").forEachRemaining(row -> {
                Row computerRow = (Row)row;
                final String machineName = (String)computerRow.get("NAME");
                String domainName = (String)computerRow.get("DOMAIN_NAME");
                String schedulerName = domainName + "_" + machineName + "_File_Audit_Scheduler";
                String objectGuid = (String)computerRow.get("OBJECT_GUID");
                Criteria readCriteria = new Criteria(Column.getColumn((String)"AUDCOMPUTEREVENTREAD", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
                try {
                    Criteria schedCrit = new Criteria(Column.getColumn((String)"SCHEDULE", (String)"SCHEDULE_NAME"), (Object)schedulerName, 0);
                    Row scheduleRow = scheduleDo.getRow("SCHEDULE", schedCrit);
                    Row readRow = dO.getRow("AUDCOMPUTEREVENTREAD", readCriteria);
                    Long columnMachineTypeLong = (Long)readRow.get("MACHINE_TYPE_LONG");
                    long createdScheduleID = 0L;
                    if (scheduleRow == null) {
                        Hashtable<String, Object> fsObject = new Hashtable<String, Object>();
                        fsObject.put("serverName", machineName);
                        fsObject.put("domainName", domainName);
                        Long machineTypeForSchedule = columnMachineTypeLong & 4L | columnMachineTypeLong & 8L | columnMachineTypeLong & 0x40L | columnMachineTypeLong & 0x80L;
                        fsObject.put("adminStatus", (columnMachineTypeLong & 8L | columnMachineTypeLong & 0x80L) != 0L ? 4 : 3);
                        fsObject.put("scheduleStartTime", System.currentTimeMillis());
                        createdScheduleID = EventSchedulerUtil.createEventScheduler(fsObject, (long)machineTypeForSchedule);
                    } else {
                        createdScheduleID = (Long)scheduleRow.get("SCHEDULE_ID");
                    }
                    readRow.set("SCHEDULE_ID", (Object)createdScheduleID);
                    dO.updateRow(readRow);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dO);
                    this.ioHandle().print("Server name: " + machineName + " is updated with the schedule id: " + createdScheduleID + "\n");
                    final long finalCreatedScheduleID = createdScheduleID;
                    HashMap auditingDetailsMap = new HashMap(){
                        {
                            this.put("CREDENTIAL", null);
                            this.put("ACTION_ID", 2);
                            this.put("ACTION_CATEGORY", "File Audit");
                            this.put("MESSAGE", "Server name: " + machineName + " is updated with the schedule id: " + finalCreatedScheduleID);
                            this.put("ACCESS_TYPE", 8);
                            this.put("EVENT_TYPE", 8);
                            this.put("SEVERITY", "adap.ADAPUserAuditSeverities.audit_name.add_computers");
                            this.put("ADDITIONAL_INFO", "-");
                        }
                    };
                    TDHandler.addAuditEntries((HashMap)auditingDetailsMap);
                }
                catch (DataAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (DataAccessException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addWorkStations(ArrayList<String> workStationList, String[] cmdStr, int machineType) {
        String userSelection = "yes";
        if (cmdStr[6].equals("false")) {
            userSelection = "no";
        } else if (cmdStr[6].equals("true")) {
            userSelection = "yes";
        }
        try {
            HashMap<String, ArrayList<HashMap<String, String>>> objectGuidMap = this.getObjectGuidFromWrokStationNames(workStationList);
            ArrayList<String> addedServerList = new ArrayList<String>();
            HashMap errorServerMap = new HashMap();
            for (Map.Entry<String, ArrayList<HashMap<String, String>>> pair : objectGuidMap.entrySet()) {
                ArrayList<HashMap<String, String>> objectGuidList = pair.getValue();
                ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
                this.ioHandle().print("Adding below servers started ");
                for (int i = 0; i < objectGuidList.size(); ++i) {
                    this.ioHandle().print("\n" + objectGuidList.get(i).get("NAME"));
                    addedServerList.add(objectGuidList.get(i).get("NAME"));
                    list.add(objectGuidList.get(i));
                }
                JSONObject msgObj = MSHandler.addORUpdateServers((String)pair.getKey(), list, (String)userSelection, (long)machineType, (boolean)false, (boolean[])new boolean[0]);
                this.ioHandle().print("\n Message : " + msgObj.getString("message") + "\n");
                this.ioHandle().print("\n Adding server finished : ");
            }
            if (addedServerList.size() != workStationList.size()) {
                this.ioHandle().print("\n Below servers not available in Active Directory.So server addition failed\n");
                for (int i = 0; i < workStationList.size(); ++i) {
                    if (addedServerList.contains(workStationList.get(i).toLowerCase()) || addedServerList.contains(workStationList.get(i).toUpperCase())) continue;
                    this.ioHandle().print("\n\t " + workStationList.get(i) + "\n");
                }
            }
            if (!errorServerMap.isEmpty()) {
                this.ioHandle().print("\n Adding of below servers are failed\n");
                Iterator iterator = errorServerMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry pair = iterator.next();
                    this.ioHandle().print("\n\t ServerName : " + pair.getKey() + "  Message :" + pair.getValue());
                    iterator.remove();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private HashMap<String, ArrayList<HashMap<String, String>>> getObjectGuidFromWrokStationNames(ArrayList<String> workStationList) {
        HashMap<String, ArrayList<HashMap<String, String>>> objectGuidMap = new HashMap<String, ArrayList<HashMap<String, String>>>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)workStationList.toArray(), 8);
            crit = crit.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)workStationList.toArray(), 8));
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"IS_DELETED"), (Object)0, 0));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMComputerGeneralDetails", crit);
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows("ADSMComputerGeneralDetails");
                Row rw = null;
                while (it.hasNext()) {
                    rw = (Row)it.next();
                    String domainName = (String)rw.get("DOMAIN_NAME");
                    String objectGuid = (String)rw.get("OBJECT_GUID");
                    String name = (String)rw.get("NAME");
                    ArrayList<Object> objectGuidList = null;
                    HashMap<String, String> computerMap = new HashMap<String, String>();
                    computerMap.put("OBJECT_GUID", objectGuid);
                    computerMap.put("NAME", name);
                    objectGuidList = objectGuidMap.containsKey(domainName) ? objectGuidMap.get(domainName) : new ArrayList();
                    objectGuidList.add(computerMap);
                    objectGuidMap.put(domainName, objectGuidList);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return objectGuidMap;
    }

    private void AddServerCmdUsage() throws Exception {
        this.ioHandle().print("\n\t  Steps :");
        this.ioHandle().print("\n\t\t  Create a file in location 'ADAUDITPLUS_HOME\\bin\\servers.csv'.(Encoding Format - UTF-8) ");
        this.ioHandle().print("\n\t\t  Enter the server names by comma separated in server.csv file");
        this.ioHandle().print("\n\t  Example : ");
        this.ioHandle().print("\n\t\t  TEST-FS1,");
        this.ioHandle().print("\n\t\t  TEST-FS2,");
        this.ioHandle().print("\n\t\t  TEST-FS3");
        this.ioHandle().print("\n  Usage :\n\tserver add -machinetype fs -shares all -issacl false -isauditpolicy true");
        this.ioHandle().print("\n\t  Arguments :");
        this.ioHandle().print("\n\t\t  -machinetype  ---- Type of machine going to configure (Example: fs-FileServer,ws-WorkStation,ms-MemberServer)");
        this.ioHandle().print("\n\t\t  -shares  ---- shares filter should be added only for file server (Example: all(default),single,shares.csv)");
        this.ioHandle().print("\n\t\t\t  all --- To audit all the shares in the given file server");
        this.ioHandle().print("\n\t\t\t  single --- To audit one random share in the given file server");
        this.ioHandle().print("\n\t\t\t  shares.csv --- To audit selected shares in the given file server");
        this.ioHandle().print("\n\t\t\t\t  Enter the share names by comma separated in shares.csv file");
        this.ioHandle().print("\n\t\t\t\t  Example : \n");
        this.ioHandle().print("\n\t\t\t\t  \\\\TEST-FS1\\Share1,");
        this.ioHandle().print("\n\t\t\t\t  \\\\TEST-FS1\\Share2,");
        this.ioHandle().print("\n\t\t\t\t  \\\\TEST-FS1\\Share3");
        this.ioHandle().print("\n\t\t  -issacl  ---- Necessary object level auditing will be set on the Shares");
        this.ioHandle().print("\n\t\t  -isauditpolicy   ----  Object Access policy will be enabled for the server via a GPO");
        this.ioHandle().print("\n\t  Exmaples :");
        this.ioHandle().print("\n\t\t config server add -machinetype fs -shares all -issacl true -isauditpolicy true");
        this.ioHandle().print("\n\t\t config server add -machinetype fs -shares single -issacl true -isauditpolicy true");
        this.ioHandle().print("\n\t\t config server add -machinetype fs -shares shares.csv -issacl false -isauditpolicy true");
        this.ioHandle().print("\n\t\t config server add -machinetype ws -isauditpolicy true");
        this.ioHandle().print("\n\t\t config server add -machinetype ms -isauditpolicy true");
    }

    private void addFileServers(ArrayList<String> serverList, String[] cmdStr, int processIndex) {
        try {
            Iterator it;
            ArrayList<String> addedServerList = new ArrayList<String>();
            HashMap<String, String> errorServerMap = new HashMap<String, String>();
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)serverList.toArray(), 8);
            crit = crit.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)serverList.toArray(), 8));
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"IS_DELETED"), (Object)0, 0));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMComputerGeneralDetails", crit);
            if (!dataObj.isEmpty()) {
                it = dataObj.getRows("ADSMComputerGeneralDetails");
                Row rw = null;
                while (it.hasNext()) {
                    rw = (Row)it.next();
                    try {
                        this.ioHandle().print("\n Adding server started : " + rw.get("NAME") + "\n");
                        addedServerList.add((String)rw.get("NAME"));
                        String shareAction = "all";
                        Hashtable<String, Object> fsDetails = new Hashtable<String, Object>();
                        fsDetails.put("OBJECT_GUID", rw.get("OBJECT_GUID"));
                        fsDetails.put("serverName", rw.get("NAME"));
                        fsDetails.put("domainName", rw.get("DOMAIN_NAME"));
                        fsDetails.put("SHARE_ACTION", shareAction);
                        fsDetails.put("MACHINE_TYPE", 4L);
                        String shares = cmdStr[6];
                        ArrayList<String> shareLocations = this.updateShareDetails((String)rw.get("DOMAIN_NAME"), (String)rw.get("NAME"), shares);
                        fsDetails.put("LOCATIONS", shareLocations);
                        Boolean isSACL = Boolean.valueOf(cmdStr[8]);
                        Boolean isAuditPolicy = Boolean.valueOf(cmdStr[10]);
                        if (isSACL.booleanValue()) {
                            this.ioHandle().print("\n\t Necessary object level auditing will be set on  Shares\n");
                        } else {
                            this.ioHandle().print("\n\t Necessary object level auditing should be set manually on  Shares\n");
                        }
                        if (isAuditPolicy.booleanValue()) {
                            this.ioHandle().print("\n\t Object Access policy will be enabled for the server via a GPO\n");
                        } else {
                            this.ioHandle().print("\n\t Object Access policy need to be enabled for the server via a GPO\n");
                        }
                        HashMap retMap = FileServerHandler.addFileServerEmber(fsDetails, (Boolean)isSACL, (Boolean)isAuditPolicy, (Boolean)true);
                        String message = (String)retMap.get("msgTxt");
                        this.ioHandle().print("\n\t Message  : " + message + "\n\n");
                    }
                    catch (Exception e) {
                        errorServerMap.put((String)rw.get("NAME"), e.getMessage());
                        e.printStackTrace();
                        this.ioHandle().print("\n\t Exception while adding server  : " + e.getMessage() + "\n\n");
                    }
                }
            }
            if (addedServerList.size() != serverList.size()) {
                this.ioHandle().print("\n Below servers not available in Active Directory.So server addition failed\n");
                for (int i = 0; i < serverList.size(); ++i) {
                    if (addedServerList.contains(serverList.get(i).toLowerCase()) || addedServerList.contains(serverList.get(i).toUpperCase())) continue;
                    this.ioHandle().print("\n\t " + serverList.get(i) + "\n");
                }
            }
            if (!errorServerMap.isEmpty()) {
                this.ioHandle().print("\n Adding of below servers failed\n");
                it = errorServerMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry pair = it.next();
                    this.ioHandle().print("\n\t ServerName : " + pair.getKey() + "  Message :" + pair.getValue());
                    it.remove();
                }
            }
            this.ioHandle().print("\n Commands executed successfully\n\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> getShareListFromCSV() throws Exception {
        String homeDir = System.getProperty("server.dir");
        String SHARE_FILE_PATH = homeDir.substring(0, homeDir.length() - 2) + "\\shares.csv";
        ArrayList<String> shareList = new ArrayList<String>();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(SHARE_FILE_PATH, new String[0]), Charset.defaultCharset());
             CSVParser csvParser = new CSVParser((Reader)reader, CSVFormat.DEFAULT);){
            for (CSVRecord csvRecord : csvParser) {
                shareList.add(csvRecord.get(0));
            }
        }
        catch (NoSuchFileException e) {
            this.ioHandle().print("# \n\tshares.csv file not found in specified location.\n\tEnter \"server help\" to view list of available commands.\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.ioHandle().print("# Wrong command! Enter \"server help\" to view list of available commands.\n");
        }
        return shareList;
    }

    private ArrayList<String> updateShareDetails(String domainName, String hostName, String shares) throws Exception {
        ArrayList<String> shareDetails;
        block5: {
            boolean allShares = true;
            if (shares.equalsIgnoreCase("single")) {
                allShares = false;
            }
            shareDetails = new ArrayList<String>();
            Properties shareProperties = null;
            shareProperties = ADHandler.getSharesForServer((String)domainName, (String)hostName);
            DataObject dataObject = ShareHandler.updateSharesForServer((String)domainName, (Properties)shareProperties, (String)hostName);
            if (dataObject.isEmpty()) break block5;
            if (shares.equalsIgnoreCase("shares.csv")) {
                ArrayList<String> shareList = this.getShareListFromCSV();
                Criteria shareListCriteria = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"LOCATION"), (Object)shareList.toArray(), 8);
                Iterator it = dataObject.getRows("ADSMShareGeneralDetails", shareListCriteria);
                Row rw = null;
                while (it.hasNext()) {
                    rw = (Row)it.next();
                    shareDetails.add((String)rw.get("LOCATION"));
                }
            } else {
                Iterator it = dataObject.getRows("ADSMShareGeneralDetails");
                Row rw = null;
                while (it.hasNext()) {
                    rw = (Row)it.next();
                    shareDetails.add((String)rw.get("LOCATION"));
                    if (allShares) continue;
                    break;
                }
            }
        }
        return shareDetails;
    }

    public void processNotImplemented() throws IOException {
        this.ioHandle().print(String.format("\n%s", " # Command not implemented as of now!\n\n"));
    }
}

