/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.sym.adsm.common.server.commandline.ArchiveCmd;
import com.adventnet.sym.adsm.common.server.commandline.ArchiveDataProcessor;
import com.adventnet.sym.adsm.common.server.commandline.Command;
import com.adventnet.sym.adsm.common.server.commandline.LeafCommand;
import com.adventnet.sym.adsm.common.server.commandline.StemCommand;
import com.adventnet.sym.adsm.common.server.commandline.util.DataBaseTroubleshooting;
import com.adventnet.sym.adsm.common.server.commandline.util.FeatureCheckUtil;
import com.adventnet.sym.adsm.common.server.commandline.util.FeatureUpdateUtil;
import java.util.LinkedHashMap;

public class AdminCmd
extends StemCommand {
    public final Command help = new LeafCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            AdminCmd.this.processHelp();
        }
    };
    public final ArchiveCmd archive = new ArchiveCmd(this.getCmdId() + "1", "archive", "Index archive files");
    public final Command syslog_udp_port_check = new LeafCommand(this.getCmdId() + "2", "syslog-udp-port-check", "Check If the Syslog UDP port is listening or not. If yes, we will print first 100 events"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureCheckUtil.checkIfSyslogUDPPortListeningEvents();
        }
    };
    public final Command reset_dashboard_graph = new LeafCommand(this.getCmdId() + "3", "reset-dashboard-graph", "Recreating the default graph in dashboard"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureUpdateUtil.recreateMissedGraphInDashboard();
        }
    };
    public final Command delete_archive_data = new LeafCommand(this.getCmdId() + "4", "delete-archive-data", "Deleting Archive data for given Given time"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DataBaseTroubleshooting.deleteArchiveData(cmdStr, processIndex);
        }
    };
    public final Command syslog_tcp_port_check = new LeafCommand(this.getCmdId() + "5", "syslog-tcp-port-check", "Check If the Syslog port is listening or not. If yes, we will print first 100 events"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureCheckUtil.checkIfSyslogTCPPortListeningEvents();
        }
    };
    public final Command delete_duplicate_archive_data = new LeafCommand(this.getCmdId() + "6", "delete-duplicate-archive-data", "Deleting Duplicate data from  Archive files for given Given time"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ArchiveDataProcessor.deleteDuplicateDEArchiveData(cmdStr);
        }
    };
    public final Command exclude_archive_data = new LeafCommand(this.getCmdId() + "7", "exclude-archive-data", "Exclude and Filter archive data with given Exclude values"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ArchiveDataProcessor.excludeRewriteDEArchiveFiles(cmdStr);
        }
    };

    public AdminCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, Command> childCmdList = new LinkedHashMap<String, Command>();
        childCmdList.put(this.help.getCmdId(), this.help);
        childCmdList.put(this.archive.getCmdId(), this.archive);
        childCmdList.put(this.syslog_udp_port_check.getCmdId(), this.syslog_udp_port_check);
        childCmdList.put(this.reset_dashboard_graph.getCmdId(), this.reset_dashboard_graph);
        childCmdList.put(this.delete_archive_data.getCmdId(), this.delete_archive_data);
        childCmdList.put(this.delete_duplicate_archive_data.getCmdId(), this.delete_duplicate_archive_data);
        childCmdList.put(this.exclude_archive_data.getCmdId(), this.exclude_archive_data);
        childCmdList.put(this.syslog_tcp_port_check.getCmdId(), this.syslog_tcp_port_check);
        this.setChildCmdList(childCmdList);
    }
}

