/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.sym.adsm.common.server.commandline.Command;
import com.adventnet.sym.adsm.common.server.commandline.DeleteCmd;
import com.adventnet.sym.adsm.common.server.commandline.LeafCommand;
import com.adventnet.sym.adsm.common.server.commandline.StemCommand;
import com.adventnet.sym.adsm.common.server.commandline.util.DBTableTroubleshooting;
import com.adventnet.sym.adsm.common.server.commandline.util.DataBaseTroubleshooting;
import com.adventnet.sym.adsm.common.server.commandline.util.FeatureUpdateUtil;
import com.adventnet.sym.adsm.common.server.commandline.util.SupportTroubleshooting;
import java.io.IOException;
import java.util.LinkedHashMap;

public class DatabaseCmd
extends StemCommand {
    public final LeafCommand help = new LeafCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DatabaseCmd.this.processHelp();
        }
    };
    public final DeleteCmd delete = new DeleteCmd(this.getCmdId() + "1", "delete", "Delete Data - Take backup or snapshot of db to avoid data loss");
    public final Command getting_basic_info = new LeafCommand(this.getCmdId() + "2", "get-basic-info", "Getting Basic information about installation"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DataBaseTroubleshooting.gettingDBConfigSettngs();
            DBTableTroubleshooting.getTableColumnDetails();
        }
    };
    public final Command all_data_table_health = new LeafCommand(this.getCmdId() + "3", "all-data-table-health", "Getting all data tables health"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DBTableTroubleshooting.getDataTablesHealth(true, false);
        }
    };
    public final Command main_data_table_health = new LeafCommand(this.getCmdId() + "4", "main-data-table-check", "Getting Main data tables health check"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DBTableTroubleshooting.getMainDataTableCount();
        }
    };
    public final Command index_corruption = new LeafCommand(this.getCmdId() + "5", "index-corruption", "Getting PostgreSQL Table level corruption"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DataBaseTroubleshooting.corruptionCheck();
        }
    };
    public final Command create_table_syntax = new LeafCommand(this.getCmdId() + "6", "create-table-syntax", "Getting PostgreSQL Table level corruption"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DatabaseCmd.this.checkInputAndProcess(cmdStr, processIndex);
        }
    };
    public final Command add_missed_meta_table = new LeafCommand(this.getCmdId() + "7", "add-meta-table-entry", "Getting PostgreSQL Table level corruption"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureUpdateUtil.addMissedMetaTableEntries();
        }
    };
    public final Command top_space_occupied_table = new LeafCommand(this.getCmdId() + "8", "top-10-tables", "Getting Top 10 space occupied tables"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DataBaseTroubleshooting.getTop10SpaceOccupiedTables();
        }
    };
    public final Command create_table = new LeafCommand(this.getCmdId() + "9", "create_table", "Create Table if missing using sql properties file"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DataBaseTroubleshooting.createTable(cmdStr, processIndex);
        }
    };

    public DatabaseCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, Command> childCmdList = new LinkedHashMap<String, Command>();
        childCmdList.put(this.help.getCmdId(), this.help);
        childCmdList.put(this.delete.getCmdId(), this.delete);
        childCmdList.put(this.getting_basic_info.getCmdId(), this.getting_basic_info);
        childCmdList.put(this.all_data_table_health.getCmdId(), this.all_data_table_health);
        childCmdList.put(this.main_data_table_health.getCmdId(), this.main_data_table_health);
        childCmdList.put(this.index_corruption.getCmdId(), this.index_corruption);
        childCmdList.put(this.create_table_syntax.getCmdId(), this.create_table_syntax);
        childCmdList.put(this.add_missed_meta_table.getCmdId(), this.add_missed_meta_table);
        childCmdList.put(this.top_space_occupied_table.getCmdId(), this.top_space_occupied_table);
        childCmdList.put(this.create_table.getCmdId(), this.create_table);
        this.setChildCmdList(childCmdList);
    }

    private boolean checkInputAndProcess(String[] cmdStr, int processIndex) throws IOException {
        boolean isValid = true;
        int len = cmdStr.length;
        String subCommand = cmdStr[2];
        try {
            if (subCommand.equalsIgnoreCase("create-table-syntax")) {
                String tableName = "AUDLogonInfo";
                if (len == 4) {
                    tableName = cmdStr[3];
                }
                SupportTroubleshooting.getCreateTableSyntax(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isValid = false;
        }
        return isValid;
    }
}

