/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.commandline.Command;
import com.adventnet.sym.adsm.common.server.commandline.LeafCommand;
import com.adventnet.sym.adsm.common.server.commandline.StemCommand;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeleteCategoryCmd
extends StemCommand {
    private static final Logger LOGGER = Logger.getLogger(DeleteCategoryCmd.class.getName());
    private static final String MIN_MAX_SELECT_QUERY_PREFIX = "SELECT MIN(TIME_GENERATED) AS START_TIME, MAX(TIME_GENERATED) AS END_TIME, MIN(UNIQUE_ID) AS START_INDEX, MAX(UNIQUE_ID) AS END_INDEX FROM <table_name>";
    private static final String USAGE = "usage";
    private static final String DATA = "data";
    private static String dbType = null;
    private String categoryName = null;
    private String conditionStr = null;
    private Long from = null;
    private Boolean skipDeleteProcess = Boolean.FALSE;
    private Long to = null;
    public final Command help = new LeafCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DeleteCategoryCmd.this.processHelp();
        }
    };
    public final Command usage = new LeafCommand(this.getCmdId() + "1", "usage", "Usage of \"delete category\" command"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DeleteCategoryCmd.this.printUsage();
        }
    };
    public final Command data = new LeafCommand(this.getCmdId() + "2", "data", "Delete Category Based Data -> Take backup or snapshot of db to avoid data loss"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            dbType = CommonUtil.getDBServerName();
            DeleteCategoryCmd.this.categoryName = null;
            DeleteCategoryCmd.this.conditionStr = null;
            DeleteCategoryCmd.this.from = null;
            DeleteCategoryCmd.this.skipDeleteProcess = Boolean.FALSE;
            DeleteCategoryCmd.this.to = null;
            DeleteCategoryCmd.this.processCategory(cmdStr);
        }
    };

    public DeleteCategoryCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, Command> childCmdList = new LinkedHashMap<String, Command>();
        childCmdList.put(this.help.getCmdId(), this.help);
        childCmdList.put(this.usage.getCmdId(), this.usage);
        childCmdList.put(this.data.getCmdId(), this.data);
        this.setChildCmdList(childCmdList);
    }

    private void confirmToProceed() throws IOException {
        this.ioHandle().print("\n****************************************************************************************");
        this.ioHandle().print("\n  Your Options : ");
        this.ioHandle().print("\n\t  Category Table Prefix    : " + this.categoryName);
        this.ioHandle().print("\n\t  Delete From - " + TimeUtil.formatDefaultTimeZoneDate((Long)(this.from * 1000L)) + " <-----> To - " + TimeUtil.formatDefaultTimeZoneDate((Long)(this.to * 1000L)));
        if (this.conditionStr == null) {
            this.ioHandle().print("\n\t  Additional Condition    : No valid condition provided");
        } else {
            this.ioHandle().print("\n\t  Additional Condition    : " + this.conditionStr);
        }
        this.ioHandle().print("\n\n----->  Proceeding may cause unrecoverable data loss <-----");
        String response = this.ioHandle().readLine("\n  Do you want to proceed deleting data (Y/N)? ");
        if (response.trim().toLowerCase().startsWith("n")) {
            this.skipDeleteProcess = Boolean.TRUE;
            this.ioHandle().print("\n\t  Deleting Process cancelled.");
        } else if (response.trim().toLowerCase().startsWith("y")) {
            this.ioHandle().print("\n\t  Deleting Process Started. Wait until it complete.");
        } else {
            this.ioHandle().print("\n\t  Invalid Input : " + response.trim().toLowerCase());
            this.confirmToProceed();
        }
        this.ioHandle().print("\n****************************************************************************************\n\n");
    }

    private void deleteCategory() throws IOException {
        if (dbType.equals("postgres") || dbType.equals("mssql") || dbType.equals("mysql")) {
            List<String> metaTableList = this.getTableList();
            for (String tableName : metaTableList) {
                this.deleteData(tableName);
            }
            this.ioHandle().print("\n\t  Deleting Process completed.\n\n");
            if (dbType.equals("mssql")) {
                this.ioHandle().print(" Shrink your database to gain effective disk space\n\n");
            }
        } else {
            this.ioHandle().print(" Unable to detect Database server\n\n");
        }
    }

    private void deleteData(String tableName) {
        StringBuilder deleteQuery = new StringBuilder("DELETE FROM ").append(tableName).append(" WHERE ");
        deleteQuery.append(this.from).append(" <= TIME_GENERATED AND TIME_GENERATED <= ").append(this.to);
        if (this.conditionStr != null) {
            deleteQuery.append(" AND ").append(this.conditionStr);
        }
        this.logQueryExecution(tableName, deleteQuery.toString());
        boolean queryStatus = QueryUtil.executeSingleQuery((String)tableName, (String)deleteQuery.toString());
        if (queryStatus && tableName.contains("_")) {
            this.updateMinMax(tableName);
        }
    }

    private void dropTable(String tableName) {
        StringBuilder dropQuery = new StringBuilder("DROP TABLE ").append(tableName);
        this.logQueryExecution(tableName, dropQuery.toString());
        boolean queryStatus = QueryUtil.executeSingleQuery((String)tableName, (String)dropQuery.toString());
        if (queryStatus) {
            StringBuilder deleteQuery = new StringBuilder("DELETE FROM AUDMETATABLE WHERE LOOKUP_TABLENAME = '").append(tableName).append("'");
            this.logQueryExecution("AUDMetaTable", deleteQuery.toString());
            QueryUtil.executeSingleQuery((String)"AUDMetaTable", (String)deleteQuery.toString());
        }
    }

    public List<String> getTableList() {
        ArrayList<String> metaTableList = new ArrayList<String>();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDMetaTable"));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"END_TIME"), (Object)this.from, 5);
            Criteria crit1 = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)this.to, 7);
            crit1 = crit1.and(crit);
            Criteria crit2 = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"END_TIME"), (Object)0L, 0);
            crit2 = crit2.or(crit1);
            Criteria crit3 = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"LOOKUP_TABLENAME"), (Object)this.categoryName, 0, false);
            crit3 = crit3.and(crit2);
            selectQuery.setCriteria(crit3);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows("AUDMetaTable");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String metaTableName = (String)row.get("LOOKUP_TABLENAME");
                metaTableList.add(metaTableName);
            }
            LOGGER.log(Level.INFO, " delete category data :: processing list = {0}", metaTableList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return metaTableList;
    }

    private void logQueryExecution(String name, String sql) {
        LOGGER.log(Level.INFO, "Executing query [{0}] for [{1}]", new Object[]{sql, name});
    }

    private Long parseData(String dateStr, int type) {
        String[] dateSplit = dateStr.split(":");
        if (dateSplit.length == 3) {
            Integer date = Integer.parseInt(dateSplit[0]);
            Integer month = Integer.parseInt(dateSplit[1]);
            Integer year = Integer.parseInt(dateSplit[2]);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, date);
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.set(9, 0);
            Long returnTime = calendar.getTimeInMillis() / 1000L;
            if (type == 1) {
                ((Calendar)calendar).add(5, 1);
                returnTime = calendar.getTimeInMillis() / 1000L - 1L;
            }
            return returnTime;
        }
        this.skipDeleteProcess = Boolean.TRUE;
        return null;
    }

    private void printInvalid() throws IOException {
        this.skipDeleteProcess = Boolean.TRUE;
        LOGGER.log(Level.INFO, " Invalid parameters! :: delete category data ");
        this.ioHandle().print("\n  Invalid parameters!\n");
        this.printUsage();
    }

    private void printUsage() throws IOException {
        this.ioHandle().print("\n  Usage :\n\tdelete category data -table [<category table>] -from [<from>] -to [<to>] -condition [<condition>]");
        this.ioHandle().print("\n\t  Arguments :");
        this.ioHandle().print("\n\t\t  data                     ---- delete data in live tables");
        this.ioHandle().print("\n\t\t  -table <category table>  ---- Table prefix of the category");
        this.ioHandle().print("\n\t\t  -from <from>             ---- <date>:<month>:<year>");
        this.ioHandle().print("\n\t\t  -to <to>                 ---- <date>:<month>:<year>");
        this.ioHandle().print("\n\t\t  -condition <condition>   ---- optional    ----    Sql condition. Include Round brackets ' ( ' and ' ) ' if condition includes space. Multiple ' ( ' and ' ) ' in condition may cause unexpected behaviour.");
        this.ioHandle().print("\n\t  Exmaple :");
        this.ioHandle().print("\n\t\t  delete category data -table audfileauditinfo -from 23:02:2018 -to 20:03:2018");
        this.ioHandle().print("\n\t\t  delete category data -table audfileauditinfo -from 23:02:2018 -to 20:03:2018 -condition ACCESS_TYPE=5");
        this.ioHandle().print("\n\t\t  delete category data -table audfileauditinfo -from 23:02:2018 -to 20:03:2018 -condition ( ACCESS_TYPE = 5 AND  ACCESS_TYPE = 4 )\n\n");
    }

    private void processCategory(String[] cmdStr) {
        int cmdLen = cmdStr.length;
        try {
            if (6 > cmdLen) {
                this.printInvalid();
                return;
            }
            this.setParams(cmdStr);
            if (this.skipDeleteProcess.booleanValue()) {
                LOGGER.log(Level.INFO, " delete category data :: Process cancelled due to invalid input");
                this.ioHandle().print("\n\t  Deleting Process cancelled due to invalid input\n\n");
            } else {
                this.confirmToProceed();
            }
            if (!this.skipDeleteProcess.booleanValue()) {
                this.deleteCategory();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void recoverMSSQLSpace(String tableName) {
        StringBuilder reIndex = new StringBuilder("DBCC DBREINDEX(").append(tableName).append(",' ',90)");
        this.logQueryExecution("DBCC DBREINDEX", reIndex.toString());
        QueryUtil.executeSingleQuery((String)"DBCC DBREINDEX", (String)reIndex.toString());
    }

    private void recoverPGSQLSpace(String tableName) {
        tableName = EscapeUtil.escSplCharsAsSQL((Object)tableName);
        String zeroDamagedPageOn = "SET zero_damaged_pages = on;";
        StringBuilder reIndex = new StringBuilder("REINDEX TABLE ").append(tableName).append(";");
        StringBuilder vaccum = new StringBuilder("VACUUM FULL ").append(tableName).append(";");
        String zeroDamagedPageOff = "SET zero_damaged_pages = off;";
        this.logQueryExecution("zero_damaged_pages on", zeroDamagedPageOn);
        QueryUtil.executeSingleQuery((String)"zero_damaged_pages on", (String)zeroDamagedPageOn);
        this.logQueryExecution("REINDEX damaged_table", reIndex.toString());
        QueryUtil.executeSingleQuery((String)"REINDEX damaged_table", (String)reIndex.toString());
        this.logQueryExecution("VACUUM damaged_table", vaccum.toString());
        QueryUtil.executeSingleQuery((String)"VACUUM damaged_table", (String)vaccum.toString());
        this.logQueryExecution("zero_damaged_pages off", zeroDamagedPageOff);
        QueryUtil.executeSingleQuery((String)"zero_damaged_pages off", (String)zeroDamagedPageOff);
    }

    private void recoverSpace(String tableName) {
        if (dbType.equals("postgres")) {
            this.recoverPGSQLSpace(tableName);
        } else if (dbType.equals("mssql")) {
            this.recoverMSSQLSpace(tableName);
        }
    }

    private void setParams(String[] cmdStr) throws IOException {
        block12: for (int i = 5; i < cmdStr.length && !this.skipDeleteProcess.booleanValue(); ++i) {
            LOGGER.log(Level.INFO, " delete category data :: parsing command = {0}", cmdStr[i]);
            switch (cmdStr[i]) {
                case "-table": {
                    this.categoryName = cmdStr[++i];
                    continue block12;
                }
                case "-from": {
                    this.from = this.parseData(cmdStr[++i], 0);
                    continue block12;
                }
                case "-to": {
                    this.to = this.parseData(cmdStr[++i], 1);
                    continue block12;
                }
                case "-condition": {
                    if (cmdStr[++i].startsWith("(")) {
                        StringBuilder conditionStrBldr = new StringBuilder();
                        boolean conditionEnds = false;
                        while (!conditionEnds && i < cmdStr.length) {
                            conditionStrBldr.append(cmdStr[i]).append(" ");
                            if (!cmdStr[++i].endsWith(")")) continue;
                            conditionStrBldr.append(cmdStr[i]);
                            conditionEnds = true;
                        }
                        this.conditionStr = this.validateCondition(conditionStrBldr.toString());
                        continue block12;
                    }
                    this.conditionStr = this.validateCondition(cmdStr[i]);
                    continue block12;
                }
                default: {
                    this.printInvalid();
                }
            }
        }
        if (this.categoryName == null) {
            LOGGER.log(Level.INFO, " table prefix not specified :: Invalid table prefix");
            this.ioHandle().print("\n Invalid 'Table name'. Need valid table name to delete data from");
            this.skipDeleteProcess = Boolean.TRUE;
        }
        if (this.from == null || this.to == null || this.from > this.to) {
            LOGGER.log(Level.INFO, " delete category data :: Invalid from or to");
            this.ioHandle().print("\n  Invalid 'from' date or 'to' date\n");
            if (this.from != null && this.to != null && this.from > this.to) {
                LOGGER.log(Level.INFO, " delete category data :: 'from' date must be smaller than 'to' date");
                this.ioHandle().print("\n 'from' date must be smaller than 'to' date\n");
            }
            this.skipDeleteProcess = Boolean.TRUE;
        }
        if (!this.skipDeleteProcess.booleanValue()) {
            LOGGER.log(Level.INFO, " delete category data :: categoryName = {0}", this.categoryName);
            LOGGER.log(Level.INFO, " delete category data :: from = {0}", this.from);
            LOGGER.log(Level.INFO, " delete category data :: to = {0}", this.to);
            LOGGER.log(Level.INFO, " delete category data :: condition = {0}", this.conditionStr);
        }
    }

    private void updateMetaTable(String tableName, Long startTime, Long endTime, Long startIndex, Long endIndex) throws DataAccessException {
        UpdateQueryImpl updateQuery = new UpdateQueryImpl("AUDMetaTable");
        Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"LOOKUP_TABLENAME"), (Object)tableName, 0);
        updateQuery.setCriteria(crit);
        updateQuery.setUpdateColumn("START_TIME", (Object)startTime);
        updateQuery.setUpdateColumn("END_TIME", (Object)endTime);
        updateQuery.setUpdateColumn("START_INDEX", (Object)startIndex);
        updateQuery.setUpdateColumn("END_INDEX", (Object)endIndex);
        updateQuery.setUpdateColumn("TABLE_SIZE", (Object)"-");
        LOGGER.log(Level.INFO, " delete category data :: updateQuery = {0}", updateQuery);
        CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMinMax(String tableName) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block5: {
            String selectQuery = MIN_MAX_SELECT_QUERY_PREFIX.replace("<table_name>", EscapeUtil.escSplCharsAsSQL((Object)tableName));
            connection = null;
            statement = null;
            resultSet = null;
            try {
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                statement = connection.createStatement();
                this.logQueryExecution("Get Start End Values", selectQuery);
                resultSet = QueryUtil.executeQuery((String)"Get Start End Values", (Statement)statement, (String)selectQuery);
                if (resultSet.next()) {
                    Long startTime = resultSet.getLong("START_TIME");
                    Long endTime = resultSet.getLong("END_TIME");
                    Long startIndex = resultSet.getLong("START_INDEX");
                    Long endIndex = resultSet.getLong("END_INDEX");
                    this.updateMetaTable(tableName, startTime, endTime, startIndex, endIndex);
                    break block5;
                }
                this.dropTable(tableName);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    QueryUtil.close(resultSet, statement, (Connection)connection);
                    throw throwable;
                }
                QueryUtil.close(resultSet, (Statement)statement, (Connection)connection);
            }
        }
        QueryUtil.close((ResultSet)resultSet, (Statement)statement, (Connection)connection);
    }

    private String validateCondition(String conditionStr) {
        String condition = null;
        if (conditionStr.contains("SELECT ") || conditionStr.contains("UPDATE ") || conditionStr.contains("INSERT ")) {
            LOGGER.log(Level.INFO, " delete category data :: condition contains \"Data Manipulation Language\"");
            condition = null;
            this.skipDeleteProcess = Boolean.TRUE;
        } else if (conditionStr.contains("CREATE ") || conditionStr.contains("ALTER ") || conditionStr.contains("DROP ")) {
            LOGGER.log(Level.INFO, " delete category data :: condition contains \"Data Definition Language\"");
            condition = null;
            this.skipDeleteProcess = Boolean.TRUE;
        } else if (conditionStr.contains("GRANT ") || conditionStr.contains("REVOKE ")) {
            LOGGER.log(Level.INFO, " delete category data :: condition contains \"Data Control Language\"");
            condition = null;
            this.skipDeleteProcess = Boolean.TRUE;
        } else if (conditionStr.contains("COMMIT ") || conditionStr.contains("ROLLBACK ")) {
            LOGGER.log(Level.INFO, " delete category data :: condition contains \"Transactional Control Language\"");
            condition = null;
            this.skipDeleteProcess = Boolean.TRUE;
        } else {
            condition = "( " + conditionStr + " )";
        }
        return condition;
    }
}

