/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.mfw.ConsoleOut;
import com.adventnet.sym.adsm.common.server.commandline.IOHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;

public class JLineIOHandler
extends IOHandler {
    private ConsoleReader reader = new ConsoleReader(System.in, (OutputStream)ConsoleOut.out);
    private PrintWriter writer = new PrintWriter(this.reader.getOutput());
    private static int maxStringSizePrinted = 0;
    private static final String FORMAT = "%s[%-50s] %3d%% %s %5d/%-5d\r";

    @Override
    public int read() throws IOException {
        return this.reader.readCharacter();
    }

    @Override
    public String readLine() throws IOException {
        return this.reader.readLine();
    }

    @Override
    public String readLine(String prompt) throws IOException {
        String currentPrompt = this.reader.getPrompt();
        String input = this.reader.readLine(prompt);
        this.reader.setPrompt(currentPrompt);
        return input;
    }

    @Override
    public String readLine(String prompt, Character mask) throws IOException {
        String currentPrompt = this.reader.getPrompt();
        this.reader.setExpandEvents(false);
        String input = this.reader.readLine(prompt, mask);
        this.reader.setPrompt(currentPrompt);
        return input;
    }

    @Override
    public void print(CharSequence s) {
        this.writer.print(s);
    }

    @Override
    public void println(CharSequence s) {
        this.writer.println(s);
    }

    @Override
    public void print(Logger logger, CharSequence s) {
        logger.info(s.toString());
        this.writer.print(s);
    }

    @Override
    public void println(Logger logger, CharSequence s) {
        logger.info(s.toString());
        this.writer.println(s);
    }

    @Override
    public void println() {
        this.writer.println();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public String getPrompt() throws IOException {
        return this.reader.getPrompt();
    }

    @Override
    public void setPrompt(String prompt) throws IOException {
        this.reader.setPrompt(prompt);
    }

    @Override
    public void clearScreen() throws IOException {
        this.reader.clearScreen();
    }

    @Override
    public void addCompleter(Object completer) {
        this.reader.addCompleter((Completer)completer);
    }

    @Override
    public void clearCompleters() {
        List list = (List)this.reader.getCompleters();
        if (list != null) {
            for (Completer completer : list) {
                this.reader.removeCompleter(completer);
            }
        }
    }

    @Override
    public void printProgress(String message, int total, int processed) {
        String msgToBePrinted;
        String position = new String(new char[maxStringSizePrinted]).replace("\u0000", "\b");
        int pers = processed * 100 / total;
        String completed = "";
        if (pers != 0) {
            completed = new String(new char[pers / 2]).replace("\u0000", "=");
        }
        if ((msgToBePrinted = String.format(FORMAT, position, completed, pers, message, processed, total)).length() < maxStringSizePrinted) {
            msgToBePrinted = msgToBePrinted + new String(new char[maxStringSizePrinted - msgToBePrinted.length()]).replace("\u0000", " ");
        }
        maxStringSizePrinted = msgToBePrinted.length();
        this.print(msgToBePrinted);
        if (pers == 100) {
            this.println("");
        }
        this.flush();
    }
}

