/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.sym.adsm.common.server.commandline.CmdUtil;
import com.adventnet.sym.adsm.common.server.commandline.Command;
import com.adventnet.sym.adsm.common.server.commandline.LeafCommand;
import com.adventnet.sym.adsm.common.server.commandline.StemCommand;
import com.adventnet.sym.adsm.common.server.commandline.util.DBTableTroubleshooting;
import com.adventnet.sym.adsm.common.server.commandline.util.DataBaseTroubleshooting;
import com.adventnet.sym.adsm.common.server.commandline.util.FeatureCheckUtil;
import com.adventnet.sym.adsm.common.server.commandline.util.SupportTroubleshooting;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;

public class ServicePackCmd
extends StemCommand {
    public final Command help = new LeafCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ServicePackCmd.this.processHelp();
        }
    };
    public final Command all_data_table_health = new LeafCommand(this.getCmdId() + "1", "all-data-table-health", "Getting all data tables health"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DBTableTroubleshooting.getDataTablesHealth(true, false);
        }
    };
    public final Command main_data_table_health = new LeafCommand(this.getCmdId() + "2", "main-data-table-check", "Getting Main data tables health check"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DBTableTroubleshooting.getMainDataTableCount();
        }
    };
    public final Command index_corruption = new LeafCommand(this.getCmdId() + "3", "index-corruption", "Getting PostgreSQL Table level corruption"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DataBaseTroubleshooting.corruptionCheck();
        }
    };
    public final Command meta_table_check = new LeafCommand(this.getCmdId() + "4", "meta-table-check", "Getting PostgreSQL Table level corruption"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DBTableTroubleshooting.getTableColumnDetails();
        }
    };
    public final Command duplicate_folder_check = new LeafCommand(this.getCmdId() + "5", "duplicate-folder-check", "Getting PostgreSQL Table level corruption"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureCheckUtil.duplicateFolderCheck();
        }
    };
    public final Command unwanted_file_check = new LeafCommand(this.getCmdId() + "6", "", "Getting PostgreSQL Table level corruption"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureCheckUtil.checkUnwantedFilesAvailable();
        }
    };
    public final Command get_db_password = new LeafCommand(this.getCmdId() + "7", "getting-db-password", "To get db password, pass the username as the next argument."){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            if (cmdStr.length < 3) {
                CmdUtil.ioHandler().println("Please provide the username to get the password.");
                return;
            }
            SupportTroubleshooting.getDBPassword(cmdStr[2]);
        }
    };
    public final Command get_mickey_meta_data = new LeafCommand(this.getCmdId() + "8", "get_mickey_meta_data", "To get Mickey Meta Table backup"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ServicePackCmd.this.checkInputAndProcess(cmdStr, processIndex);
        }
    };

    public ServicePackCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, Command> childCmdList = new LinkedHashMap<String, Command>();
        childCmdList.put(this.help.getCmdId(), this.help);
        childCmdList.put(this.index_corruption.getCmdId(), this.index_corruption);
        childCmdList.put(this.main_data_table_health.getCmdId(), this.main_data_table_health);
        childCmdList.put(this.all_data_table_health.getCmdId(), this.all_data_table_health);
        childCmdList.put(this.meta_table_check.getCmdId(), this.meta_table_check);
        childCmdList.put(this.duplicate_folder_check.getCmdId(), this.duplicate_folder_check);
        childCmdList.put(this.unwanted_file_check.getCmdId(), this.unwanted_file_check);
        childCmdList.put(this.get_db_password.getCmdId(), this.get_db_password);
        childCmdList.put(this.get_mickey_meta_data.getCmdId(), this.get_mickey_meta_data);
        this.setChildCmdList(childCmdList);
    }

    private boolean checkInputAndProcess(String[] cmdStr, int processIndex) throws IOException {
        boolean isValid = true;
        int len = cmdStr.length;
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String subCommand = cmdStr[1];
        try {
            if (subCommand.equalsIgnoreCase("get_mickey_meta_data")) {
                String path = System.getProperty("server.home") + File.separator + "logs";
                if (len > 3) {
                    path = cmdStr[3];
                }
                String tableName = cmdStr[2];
                SupportTroubleshooting.getTableBackup(tableName, path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isValid = false;
        }
        return isValid;
    }
}

