/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.sym.adsm.common.server.commandline.Command;
import com.adventnet.sym.adsm.common.server.commandline.LeafCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class StemCommand
extends Command {
    private LinkedHashMap<String, Command> childCmdList = new LinkedHashMap();

    public StemCommand(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
    }

    public LinkedHashMap<String, Command> getChildCmdList() {
        return this.childCmdList;
    }

    public void setChildCmdList(LinkedHashMap<String, Command> childCmdList) {
        this.childCmdList = childCmdList;
    }

    @Override
    public void process(String[] cmdStr, int processIndex) throws Exception {
        int cmdLen = cmdStr.length;
        LinkedHashMap<String, Command> childCmdList = this.getChildCmdList();
        Command cmdHandler = null;
        if (processIndex < cmdLen) {
            for (Command cmdHandlerInst : childCmdList.values()) {
                if (!cmdHandlerInst.getCmdName().equalsIgnoreCase(cmdStr[processIndex])) continue;
                cmdHandler = cmdHandlerInst;
                break;
            }
        }
        if (cmdHandler != null) {
            if (this.userRole().hasAccess(cmdHandler.getCmdId())) {
                if (cmdHandler instanceof LeafCommand) {
                    cmdHandler.process(cmdStr, processIndex);
                } else {
                    cmdHandler.process(cmdStr, ++processIndex);
                }
            } else {
                this.ioHandle().print("\n# Access Denied!\n\n");
            }
        } else {
            this.ioHandle().print("\n# Wrong command! Enter \"help\" to view list of available commands\n\n");
        }
    }

    public void processHelp() throws IOException {
        LinkedHashMap<String, Command> childCmdList = this.getChildCmdList();
        for (Command cmdHandler : childCmdList.values()) {
            if (!this.userRole().hasAccess(cmdHandler.getCmdId())) continue;
            this.ioHandle().print(String.format("\n%-15s%-50s", " " + cmdHandler.getCmdName().toUpperCase(), cmdHandler.getCmdDesc()));
        }
        this.ioHandle().print("\n\n");
    }

    public void getAllCommandTreeList(ArrayList<Command> cmdList) {
        cmdList.add(this);
        LinkedHashMap<String, Command> childCmdList = this.getChildCmdList();
        for (Command cmdHandler : childCmdList.values()) {
            if (cmdHandler instanceof LeafCommand) {
                cmdList.add(cmdHandler);
                continue;
            }
            ((StemCommand)cmdHandler).getAllCommandTreeList(cmdList);
        }
    }

    public JSONArray getCommandTree() throws Exception {
        JSONArray jCmdList = new JSONArray();
        LinkedHashMap<String, Command> childCmdList = this.getChildCmdList();
        for (Command cmdHandler : childCmdList.values()) {
            if (!this.userRole().hasAccess(cmdHandler.getCmdId())) continue;
            JSONObject nodeObj = new JSONObject();
            nodeObj.put("nodeName", (Object)cmdHandler.getCmdName());
            if (!(cmdHandler instanceof LeafCommand)) {
                nodeObj.put("nodeChildList", (Object)((StemCommand)cmdHandler).getCommandTree());
            }
            jCmdList.put((Object)nodeObj);
        }
        return jCmdList;
    }

    public void showSuggestions(String[] cmdStr, int processIndex) throws IOException {
        int cmdLen = cmdStr.length;
        boolean isLastCmd = processIndex == cmdLen - 1;
        LinkedHashMap<String, Command> childCmdList = this.getChildCmdList();
        if (isLastCmd) {
            ArrayList<String> sugList = new ArrayList<String>();
            String cmd = cmdStr[processIndex];
            cmd = cmd.replace("?", "");
            for (Command cmdHandler : childCmdList.values()) {
                if (!cmdHandler.getCmdName().startsWith(cmd) || !this.userRole().hasAccess(cmdHandler.getCmdId())) continue;
                sugList.add(cmdHandler.getCmdName());
            }
            this.ioHandle().print("\n");
            for (String key : sugList) {
                this.ioHandle().print(String.format("  %-20s", key));
            }
            this.ioHandle().print("\n\n");
        } else {
            Command cmdHandler = childCmdList.get(cmdStr[processIndex]);
            if (cmdHandler != null) {
                ((StemCommand)cmdHandler).showSuggestions(cmdStr, ++processIndex);
            } else {
                this.ioHandle().print("\n# Wrong command! Enter \"help\" to view list of available commands\n\n");
            }
        }
    }
}

