/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.sym.adsm.common.server.commandline.Command;
import com.adventnet.sym.adsm.common.server.commandline.LeafCommand;
import com.adventnet.sym.adsm.common.server.commandline.StemCommand;
import com.adventnet.sym.adsm.common.server.commandline.util.DBTableTroubleshooting;
import com.adventnet.sym.adsm.common.server.commandline.util.DataBaseTroubleshooting;
import com.adventnet.sym.adsm.common.server.commandline.util.FeatureCheckUtil;
import com.adventnet.sym.adsm.common.server.commandline.util.FeatureUpdateUtil;
import com.adventnet.sym.adsm.common.server.commandline.util.SupportTroubleshooting;
import java.io.IOException;
import java.util.LinkedHashMap;

public class ToolsCmd
extends StemCommand {
    public final LeafCommand help = new LeafCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ToolsCmd.this.processHelp();
        }
    };
    public final LeafCommand run_query = new LeafCommand(this.getCmdId() + "1", "run-query", "Run DB Queries"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ToolsCmd.this.processRunQuery(cmdStr, processIndex);
        }
    };
    public final Command getting_basic_info = new LeafCommand(this.getCmdId() + "2", "get-basic-info", "Getting Basic information about installation"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            SupportTroubleshooting.getInstalledMachineDetails();
            SupportTroubleshooting.printSystemProperties();
            DataBaseTroubleshooting.gettingDBConfigSettngs();
            DBTableTroubleshooting.getTableColumnDetails();
            FeatureCheckUtil.getObjectCountPerDomain();
            FeatureCheckUtil.getSizeOfSIEMLogFoler();
        }
    };
    public final Command unwanted_jar_check = new LeafCommand(this.getCmdId() + "3", "unwant-jar-check", "List unwanted / duplicated jars available in Lib folder"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureCheckUtil.checkUnwantedFilesAvailable();
        }
    };
    public final Command all_data_table_health = new LeafCommand(this.getCmdId() + "5", "all-data-table-health", "Getting all data tables health"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DBTableTroubleshooting.getDataTablesHealth(true, false);
        }
    };
    public final Command main_data_table_health = new LeafCommand(this.getCmdId() + "6", "main-data-table-check", "Getting Main data tables health check"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            SupportTroubleshooting.getMainDataTableCount();
        }
    };
    public final Command index_corruption = new LeafCommand(this.getCmdId() + "7", "index-corruption", "Getting PostgreSQL Table level corruption"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DataBaseTroubleshooting.corruptionCheck();
        }
    };
    public final Command processed_fold_analyse = new LeafCommand(this.getCmdId() + "8", "processed-folder-analyze", "Processed Folder analysis"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureCheckUtil.duplicateFolderCheck();
            FeatureCheckUtil.processedFilesCheck();
        }
    };
    public final Command ev_temp_fold_analyse = new LeafCommand(this.getCmdId() + "9", "evtemp-folder-analyze", "Raw Folder Analysis"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureCheckUtil.duplicateFolderCheck();
        }
    };
    public final Command all = new LeafCommand(this.getCmdId() + "10", "all", "Getting all info"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            SupportTroubleshooting.allBasicConfiguration();
        }
    };
    public final Command get_table_count = new LeafCommand(this.getCmdId() + "11", "get-table-count", "Getting table info for given time Period"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
        }
    };
    public final Command change_dashboard_schedule = new LeafCommand(this.getCmdId() + "12", "change-dashboard-schedule", "Change the dashboard schedule time to periodically"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
        }
    };
    public final Command reset_dashboard_graph = new LeafCommand(this.getCmdId() + "13", "reset-dashboard-graph", "Recreating the default graph in dashboard"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureUpdateUtil.recreateMissedGraphInDashboard();
        }
    };

    public ToolsCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, Command> childCmdList = new LinkedHashMap<String, Command>();
        childCmdList.put(this.help.getCmdId(), this.help);
        childCmdList.put(this.run_query.getCmdId(), this.run_query);
        childCmdList.put(this.getting_basic_info.getCmdId(), this.getting_basic_info);
        childCmdList.put(this.unwanted_jar_check.getCmdId(), this.unwanted_jar_check);
        childCmdList.put(this.all_data_table_health.getCmdId(), this.all_data_table_health);
        childCmdList.put(this.main_data_table_health.getCmdId(), this.main_data_table_health);
        childCmdList.put(this.index_corruption.getCmdId(), this.index_corruption);
        childCmdList.put(this.processed_fold_analyse.getCmdId(), this.processed_fold_analyse);
        childCmdList.put(this.ev_temp_fold_analyse.getCmdId(), this.ev_temp_fold_analyse);
        childCmdList.put(this.all.getCmdId(), this.all);
        childCmdList.put(this.get_table_count.getCmdId(), this.get_table_count);
        childCmdList.put(this.change_dashboard_schedule.getCmdId(), this.change_dashboard_schedule);
        childCmdList.put(this.reset_dashboard_graph.getCmdId(), this.reset_dashboard_graph);
        this.setChildCmdList(childCmdList);
    }

    private void processRunQuery(String[] cmdStr, int processIndex) throws IOException {
        this.ioHandle().print(String.format("\n%s\n\n", " # Command not implemented!"));
    }
}

