/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.mfw.logging.LoggerUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.commandline.CmdUtil;
import com.adventnet.sym.adsm.common.server.commandline.IOHandler;
import com.adventnet.sym.adsm.common.server.commandline.util.SupportTroubleshooting;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class DBTableTroubleshooting {
    private static Logger _logger = Logger.getLogger("Troubleshooting");
    protected static String DB_NAME = CommonUtil.getDBServerName();
    private static IOHandler ioHandler = CmdUtil.ioHandler();

    public static void checkDataTableSchema() {
        ioHandler.print(_logger, "Getting Data Table Schema.\n");
        StringBuilder sb = new StringBuilder();
        try {
            String query = "SELECT TABLE_NAME,TABLE_SCHEMA FROM INFORMATION_SCHEMA.TABLES where lower(table_name) in (select lower(LOOKUP_TABLENAME) FROM AUDMETATABLE)";
            sb = SupportTroubleshooting.printQueryOutput(query);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ioHandler.print(_logger, "Problem while getting Data Table Schema. Error is " + ex.getMessage());
        }
        _logger.info(sb.toString());
        ioHandler.print("\nThe output is available in the logs ,log name likes SupportTroubleshootinglog_<today>.txt\n");
    }

    public static void getDataTablesHealth(boolean allDataTables, boolean isAlertTableNeeded) {
        StringBuilder sb = new StringBuilder();
        try {
            DataObject dObj = SupportTroubleshooting.getMetaTableDO(allDataTables, isAlertTableNeeded);
            ArrayList<String> tableList = SupportTroubleshooting.getTableList(dObj);
            sb.append("\n");
            for (int i = 0; i < tableList.size(); ++i) {
                String tableName = tableList.get(i);
                String ret = SupportTroubleshooting.getRowCount(tableName);
                String msg = "Processing " + tableName;
                if (i == tableList.size() - 1) {
                    msg = "Completed !!";
                }
                ioHandler.printProgress(msg, tableList.size(), i + 1);
                ioHandler.flush();
                sb.append(String.format("%40s : %s\n", tableName, ret));
            }
            ioHandler.print(_logger, sb.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void getMainDataTableCount() {
        StringBuilder sb = new StringBuilder();
        try {
            DataObject dObj = SupportTroubleshooting.getMetaTableDO(false, false);
            ArrayList<String> tableList = SupportTroubleshooting.getTableList(dObj);
            for (int i = 0; i < tableList.size(); ++i) {
                String tableName = tableList.get(i);
                String msg = "Processing " + tableName;
                if (i == tableList.size() - 1) {
                    msg = "Completed !!";
                }
                ioHandler.printProgress(msg, tableList.size(), i + 1);
                int count = SupportTroubleshooting.getRowsCount("SELECT COUNT(UNIQUE_ID) FROM " + tableName);
                sb.append(String.format("%40s : %s\n", tableName, "Total Count : " + count));
                if (count <= 500000) continue;
                sb.append("\n").append(String.format("%40s : %s\n", tableName, "\t Count is greater than Threshold. The count is " + count));
            }
            ioHandler.print(_logger, sb.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTableColumnDetails() {
        _logger.info(SupportTroubleshooting.getBanner("Rows of TableDetails and ColumnDetails Tables. "));
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String query = "select table_id, table_name from tabledetails";
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            StringBuilder sb = new StringBuilder();
            resultSet = QueryUtil.executeQuery((String)"Getting TableDetails", (Statement)statement, (String)query);
            sb.append(String.format("\n%50s%50s\n", "TABLE_ID", "TABLE_NAME"));
            while (resultSet.next()) {
                sb.append(String.format("%50s%50s\n", resultSet.getString("TABLE_ID"), resultSet.getString("TABLE_NAME")));
            }
            _logger.info(sb.toString());
            sb = new StringBuilder();
            query = "select c.table_id, column_id, table_name , column_name from tabledetails t join columndetails c on t.table_id=c.table_id order by column_id";
            resultSet = QueryUtil.executeQuery((String)"Getting TableDetails along with ColumnDetails", (Statement)statement, (String)query);
            sb.append("\n Getting TableDetails along with ColumnDetails\n");
            sb.append(String.format("%25s%25s%25s%25s\n", "TABLE_ID", "COLUMN_ID", "TABLE_NAME", "COLUMN_NAME"));
            while (resultSet.next()) {
                sb.append(String.format("%25d%25d%25s%25s\n", resultSet.getLong("TABLE_ID"), resultSet.getLong("COLUMN_ID"), resultSet.getString("TABLE_NAME"), resultSet.getString("COLUMN_NAME")));
            }
            _logger.info(sb.toString());
            sb = new StringBuilder();
            query = "select schemaname,tablename as name from pg_tables where schemaname='public'";
            if (DB_NAME.equals("mssql")) {
                query = "select type as schemaname,name from sys.tables where type='U'";
            }
            resultSet = QueryUtil.executeQuery((String)"Getting TableDetails from DB information_schema", (Statement)statement, (String)query);
            sb.append("\n Getting Table Details from Database meta data\n");
            while (resultSet.next()) {
                sb.append(String.format("%50s%50s\n", resultSet.getString("schemaname"), resultSet.getString("name")));
            }
            _logger.info(sb.toString());
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                ioHandler.print(_logger, "\nException while getting TableDetails, ColumnDetails table, Error is " + ex.getMessage());
            }
            catch (Throwable throwable) {
                QueryUtil.close(resultSet, (Statement)statement, (Connection)connection);
                throw throwable;
            }
            QueryUtil.close((ResultSet)resultSet, (Statement)statement, (Connection)connection);
        }
        QueryUtil.close((ResultSet)resultSet, (Statement)statement, (Connection)connection);
        ioHandler.print("\nThe output is available in the logs ,log name likes SupportTroubleshootinglog_<today>.txt\n");
    }

    public static void fromAndToTimeUpdateFromTables() {
        _logger.info(SupportTroubleshooting.getBanner("Updating FROM & TO value of Archived Tables from Archived Files"));
        StringBuilder sb = new StringBuilder();
        Object reader = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"STATUS"), (Object)"SUCCESS", 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"), (Object)"AUDAlert", 1));
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"), (Object)"AUDUnusualCountInput*", 3));
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)0L, 0));
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDMetaTable", crit);
            _logger.info("DO : " + dObj);
            if (dObj.size("AUDMetaTable") > 0) {
                Iterator iter = dObj.getRows("AUDMetaTable");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    String tableName = (String)row.get("LOOKUP_TABLENAME");
                    String query = "SELECT MIN(TIME_GENERATED) MIN_TIME_GENERATED, MAX(TIME_GENERATED) MAX_TIME_GENERATED, MIN(UNIQUE_ID) MIN_UNIQUE_ID, MAX(UNIQUE_ID) MAX_UNIQUE_ID FROM " + tableName;
                    HashMap map = SupportTroubleshooting.getDataSet(query);
                    _logger.info("The Start Time :: " + map.get("START_TIME"));
                    if ((Long)map.get("START_TIME") != null) {
                        row.set("START_TIME", (Object)((Long)map.get("START_TIME")));
                        row.set("END_TIME", (Object)((Long)map.get("END_TIME")));
                        row.set("START_INDEX", (Object)((Long)map.get("START_INDEX")));
                        row.set("END_INDEX", (Object)((Long)map.get("END_INDEX")));
                    }
                    _logger.info("Updated Row is " + row);
                    dObj.updateRow(row);
                }
                DataAccess.update((DataObject)dObj);
            }
        }
        catch (Exception ex) {
            _logger.info("Error getting Details from table ." + ex.getMessage());
        }
    }

    static {
        try {
            String logFileName = "SupportTroubleshooting";
            LoggerUtil.initLog((String)logFileName, (long)0L, (boolean)false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

