/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.mfw.logging.LoggerUtil;
import com.adventnet.persistence.ConfigurationParser;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.analytics.AnalyticsServerHandler;
import com.adventnet.sym.adsm.auditing.server.compliance.TemplateTableHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorHandler;
import com.adventnet.sym.adsm.common.server.DomainAction;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.commandline.CmdUtil;
import com.adventnet.sym.adsm.common.server.commandline.IOHandler;
import com.adventnet.sym.adsm.common.server.commandline.util.SupportTroubleshooting;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.zoho.framework.utils.crypto.CryptoUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;

public class FeatureUpdateUtil {
    private static Logger logger = Logger.getLogger("Troubleshooting");
    protected static String DB_NAME = CommonUtil.getDBServerName();
    private static IOHandler ioHandler = CmdUtil.ioHandler();

    public static void addMissedColumns() {
        try {
            String fileHome = System.getProperty("server.home") + File.separator + "conf" + File.separator + "adap" + File.separator;
            String fileName = "audit-column-configuration.xml";
            DataObject xmlDO = SupportTroubleshooting.getXMLDO(fileHome, fileName);
            ioHandler.print(logger, "\n Total Rows as per xml entries " + String.valueOf(xmlDO.size("AUDColumnConfiguration")));
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDColumnConfiguration"));
            Join innerJoin1 = new Join(Table.getTable((String)"AUDColumnConfiguration"), Table.getTable((String)"UVHValues"), new String[]{"COLUMN_CONF_ID"}, new String[]{"GENVALUES"}, 2);
            query.addJoin(innerJoin1);
            Criteria crit = new Criteria(Column.getColumn((String)"UVHValues", (String)"TABLE_NAME"), (Object)"AUDColumnConfiguration", 0);
            query.setCriteria((Criteria)null);
            query.addSelectColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"UVHValues", (String)"*"));
            DataObject dbDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            ioHandler.print(logger, "\n Total Rows as per uvhValues entries in db " + String.valueOf(dbDO.size("AUDColumnConfiguration")));
            DataObject diffDO = dbDO.diff(xmlDO);
            ioHandler.print(logger, "\n Total missed rows " + String.valueOf(diffDO.size("AUDColumnConfiguration")));
            Iterator iter = diffDO.getRows("AUDColumnConfiguration");
            DataObject newDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                Criteria crit1 = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMN_CONF_ID"), row.get("COLUMN_CONF_ID"), 0);
                Row isRowAvail = dbDO.getRow("AUDColumnConfiguration", crit1 = crit1.and(new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMNALIAS"), row.get("COLUMNALIAS"), 0)));
                if (isRowAvail != null) continue;
                newDO.addRow(row);
            }
            ioHandler.print(logger, "\n To be added rows into db is " + String.valueOf(newDO.size("AUDColumnConfiguration")) + "\n");
            if (newDO.size("AUDColumnConfiguration") > 0) {
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(newDO);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ioHandler.print(logger, ex.getMessage());
        }
    }

    public static void changeDashboardSchedule(int timePeriod) {
        ioHandler.print(logger, "Change the dashboard graph updation to every " + timePeriod + " hours.\n");
        try {
            Long scheduleId = DBObjectUtil.getUVHValues((String)"Schedule", (String)"Schedule:schedule_id:UVH@3480", (boolean)false);
            Criteria crit = new Criteria(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataAccess.delete((Criteria)crit);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("Periodic", new Criteria(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
            if (dObj.size("Periodic") > 0) {
                Row row = dObj.getRow("Periodic");
                row.set("TIME_PERIOD", (Object)timePeriod);
                dObj.updateRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
            } else {
                Row row = new Row("Periodic");
                row.set("SCHEDULE_ID", (Object)scheduleId);
                row.set("TIME_PERIOD", (Object)timePeriod);
                row.set("UNIT_OF_TIME", (Object)"Hours");
                dObj.addRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dObj);
            }
            ioHandler.print(logger, "Successfully changed the dashboard graph updation schedule\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ioHandler.print(logger, "Problem while updating the dashboard graph schedule, the error is " + ex.getMessage() + "\n");
        }
    }

    public static void recreateMissedGraphInDashboard() {
        ioHandler.print(logger, "Recreate missed default graphs in Dashboard\n");
        ArrayList<Long> missedContainerId = new ArrayList<Long>();
        try {
            Long[] layoutId = DBObjectUtil.getUVHValues((String)"ADSLayout", (String[])new String[]{"ADSLayout:LAYOUT_ID:1", "ADSLayout:LAYOUT_ID:2"}, (boolean)false);
            Criteria crit = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"LAYOUT_ID"), (Object)layoutId, 8);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutContainers", crit);
            ArrayList<Long> availConId = new ArrayList<Long>();
            Iterator iter = dObj.getRows("ADSLayoutContainers");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                availConId.add((Long)row.get("CONTAINER_ID"));
            }
            String fileHome = System.getProperty("server.home") + File.separator + "conf" + File.separator + "adsf" + File.separator + "layout" + File.separator;
            String fileName = "ADSLayoutContainers.xml";
            dObj = SupportTroubleshooting.getXMLDO(fileHome, fileName);
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"), (Object)availConId.toArray(new Long[availConId.size()]), 9);
            Iterator iter2 = dObj.getRows("ADSLayoutContainers", criteria.and(crit));
            DataObject newDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            while (iter2.hasNext()) {
                Row row = (Row)iter2.next();
                newDO.addRow(row);
                missedContainerId.add((Long)row.get("CONTAINER_ID"));
            }
            ioHandler.print(logger, "\n Total Missed Graphs in Dashboard is " + missedContainerId.size() + "\n");
            if (missedContainerId.size() > 0) {
                Long[] missedConId = missedContainerId.toArray(new Long[missedContainerId.size()]);
                fileName = "ADSTabVsContainer.xml";
                SupportTroubleshooting.addMissedRowToDO(newDO, fileHome, fileName, missedConId, "ADSTabVsContainer");
                fileName = "ADSContainerVsComponent.xml";
                SupportTroubleshooting.addMissedRowToDO(newDO, fileHome, fileName, missedConId, "ADSContainerVsComponent");
                fileName = "ADSContainerOptions.xml";
                SupportTroubleshooting.addMissedRowToDO(newDO, fileHome, fileName, missedConId, "ADSContainerVsDuration");
                fileName = "ADSContainerVsMenu.xml";
                SupportTroubleshooting.addMissedRowToDO(newDO, fileHome, fileName, missedConId, "ADSContainerVsMenu");
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(newDO);
                ioHandler.print(logger, "\n Successfully added missed Graph(s) in Dashboard\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ioHandler.print(logger, "\n Exception while recreating missed graph(s) in dashboard. Error is " + ex.getMessage() + "\n");
        }
    }

    public static void createAnalyticsProfile(String[] cmdStr, int processIndex) {
        int len = cmdStr.length;
        try {
            ArrayList domainList = DomainHandler.getConfiguredList((Long)1L);
            for (int i = 0; i < domainList.size(); ++i) {
                Properties prop = (Properties)domainList.get(i);
                String domainName = prop.getProperty("DOMAIN_NAME");
                Boolean isEntryMissing = SupportTroubleshooting.checkAnalyticsEntries(domainName);
                if (!isEntryMissing.booleanValue()) continue;
                Long uniqueId = AnalyticsServerHandler.getInstance().getDomainListEntry(domainName);
                if (uniqueId == null) {
                    TemplateTableHandler.putDomainListEntry((String)domainName);
                }
                SupportTroubleshooting.deleteOldAnalyticsEntries(domainName);
                AnalyticsServerHandler.getInstance().createAllAnalyticConfigurations(domainName, Long.valueOf(System.currentTimeMillis()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createDefaultProfiles(String[] cmdStr, int processIndex) {
        int len = cmdStr.length;
        String domainName = "";
        try {
            if (len > 2) {
                domainName = cmdStr[2];
            }
            if (domainName != null && !domainName.equals("")) {
                SupportTroubleshooting.deleteExistingProfiles(domainName);
                Properties domainProperties = DomainAction.getDomainGeneralDetails((String)domainName);
                AuditMonitorHandler.getInstance().createDefaultMonitors(domainProperties);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDuplicateReportProfiles(String[] cmdStr, int processIndex) {
        String subCommandAction;
        Connection connection = null;
        ResultSet dataSet = null;
        PreparedStatement pstatment = null;
        Boolean isDelete = false;
        int len = cmdStr.length;
        if (len > 2 && (subCommandAction = cmdStr[2]).equalsIgnoreCase("delete")) {
            isDelete = true;
        }
        try {
            Row row;
            Iterator iter;
            DataObject dObj;
            ArrayList domainList = DomainHandler.getConfiguredList((Long)1L);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            ArrayList<Long> uniqueIdList = new ArrayList<Long>();
            ArrayList alertIdList = new ArrayList();
            for (int i = 0; i < domainList.size(); ++i) {
                Properties prop = (Properties)domainList.get(i);
                String domainName = prop.getProperty("DOMAIN_NAME");
                String query = "SELECT MONITOR_ID FROM AUDMonitor where MONITOR_ID NOT IN (Select MIN(MONITOR_ID) as MONITOR_ID From AUDMonitor where DOMAIN_NAME  = ? GROUP BY UNIQUE_ID) and DOMAIN_NAME=?";
                pstatment = connection.prepareStatement(query);
                pstatment.setString(1, domainName);
                pstatment.setString(2, domainName);
                dataSet = pstatment.executeQuery();
                while (dataSet.next()) {
                    uniqueIdList.add(dataSet.getLong("MONITOR_ID"));
                }
            }
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)uniqueIdList.toArray(new Long[uniqueIdList.size()]), 8);
            Criteria alertCrit = new Criteria(Column.getColumn((String)"AUDAlertMonitorMap", (String)"MONITOR_ID"), (Object)uniqueIdList.toArray(new Long[uniqueIdList.size()]), 8);
            alertIdList = SupportTroubleshooting.getDuplicateAlertID(alertCrit);
            Criteria alertProfileCrit = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), (Object)alertIdList.toArray(new Long[alertIdList.size()]), 8);
            if (isDelete.booleanValue()) {
                DataAccess.delete((String)"AUDMonitor", (Criteria)crit);
                DataAccess.delete((String)"AUDAlertMonitorMap", (Criteria)alertCrit);
                DataAccess.delete((String)"AUDAlertProfile", (Criteria)alertProfileCrit);
                SupportTroubleshooting.deleteAllDuplicateAnalyticsEntries();
            } else {
                dObj = DataAccess.get((String)"AUDMonitor", (Criteria)crit);
                iter = dObj.getRows("AUDMonitor");
                while (iter.hasNext()) {
                    row = (Row)iter.next();
                    row.set("IS_ENABLED", (Object)false);
                    dObj.updateRow(row);
                }
                DataAccess.update((DataObject)dObj);
                DataObject dObjAlert = DataAccess.get((String)"AUDAlertProfile", (Criteria)alertProfileCrit);
                Iterator iterAlert = dObjAlert.getRows("AUDAlertProfile");
                while (iterAlert.hasNext()) {
                    Row row2 = (Row)iterAlert.next();
                    row2.set("IS_ENABLED", (Object)false);
                    dObjAlert.updateRow(row2);
                }
                DataAccess.update((DataObject)dObjAlert);
            }
            crit = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)uniqueIdList.toArray(new Long[uniqueIdList.size()]), 9);
            dObj = DataAccess.get((String)"AUDMonitor", (Criteria)crit);
            iter = dObj.getRows("AUDMonitor");
            while (iter.hasNext()) {
                row = (Row)iter.next();
                row.set("IS_ENABLED", (Object)true);
                dObj.updateRow(row);
            }
            DataAccess.update((DataObject)dObj);
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                QueryUtil.closePrep(dataSet, pstatment, connection);
                throw throwable;
            }
            QueryUtil.closePrep(dataSet, pstatment, (Connection)connection);
        }
        QueryUtil.closePrep((ResultSet)dataSet, (PreparedStatement)pstatment, (Connection)connection);
    }

    public static void haConfiguration(String[] cmdStr, int processIndex) {
        int len = cmdStr.length;
        try {
            if (len > 4) {
                String query;
                if (cmdStr[2].equalsIgnoreCase(cmdStr[3])) {
                    ioHandler.print(logger, "Primary server and secondary Server should not be same!!!\n");
                    return;
                }
                if (!SupportTroubleshooting.isValidInet4Address(cmdStr[4])) {
                    ioHandler.print(logger, "Invalid public IP address!!!\n");
                    return;
                }
                String referenceCountQuery = "SELECT MAX(CONFIG_ID) as COUNT FROM ADSHACONFIGURATION";
                int referenceCount = QueryUtil.getRowsCount((String)referenceCountQuery);
                String db = DB_NAME;
                if (DB_NAME.equals("postgres")) {
                    db = "Postgres";
                    query = "insert into adshaconfiguration values (" + (referenceCount + 1) + ", 3, '" + cmdStr[2] + "', '" + cmdStr[3] + "', '" + db + "', '" + cmdStr[4] + "', '', '', '')";
                } else {
                    query = "insert into adshaconfiguration values (" + (referenceCount + 1) + ", 3, '" + cmdStr[2] + "', '" + cmdStr[3] + "', '" + db + "', '" + cmdStr[4] + "', '', '', null)";
                }
                boolean res = QueryUtil.executeSingleQuery((String)"ha insert", (String)query);
                if (res) {
                    ioHandler.print(logger, "Updated Successfully!!!\n");
                } else {
                    ioHandler.print(logger, "Failed!!!\n");
                }
            } else {
                ioHandler.print(logger, "Syntax: config haquery <primary server name> <secondary Server name> <public IP>");
                ioHandler.print(logger, "\nFor Example: config haquery adap-ms1 adap-ms2 192.168.112.114\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void updatePDFExportPrams(String country) {
        country = EscapeUtil.escSplCharsAsSQL((Object)country);
        ioHandler.print(logger, "\nUpdating PDF font info for the country " + country);
        String query = "update exportparams set param_value = '' where param_name = 'pdf_font_encoding';update exportparams set param_value = '' where param_name = 'pdf_font_file'";
        if (country.equalsIgnoreCase("japan")) {
            query = "update exportparams set param_value = 'UniJIS-UCS2-H' where param_name = 'pdf_font_encoding';update exportparams set param_value = 'KozMinPro-Regular' where param_name = 'pdf_font_file'";
        } else if (country.equalsIgnoreCase("china")) {
            query = "update exportparams set param_value = 'STSong-Light' where param_name = 'pdf_font_file';update exportparams set param_value = 'UniGB-UCS2-H' where param_name = 'pdf_font_encoding';";
        } else if (country.equalsIgnoreCase("russia") || country.equalsIgnoreCase("arabic")) {
            query = "update exportparams set param_value = 'c:/windows/fonts/arial.ttf' where param_name = 'pdf_font_file';update exportparams set param_value = 'Identity-H' where param_name = 'pdf_font_encoding';";
        } else if (country.equalsIgnoreCase("isreal") || country.equalsIgnoreCase("hebrew")) {
            query = "update exportparams set param_value = 'c:/windows/fonts/david.ttf' where param_name = 'pdf_font_file';update exportparams set param_value = 'Identity-H' where param_name = 'pdf_font_encoding';";
        }
        if (country.equalsIgnoreCase("arabic") || country.equalsIgnoreCase("isreal") || country.equalsIgnoreCase("hebrew")) {
            query = query + "update exportparams set param_value='1' where param_name='write_direction';update exportparams set param_value = '1' where param_name = 'pdf_rundir_rtl';";
        }
        QueryUtil.executeSingleQuery((String)"Update PDF fond Info", (String)query);
        ioHandler.print(logger, "Successfully updated the PDF font info for the country " + country + "\n");
    }

    public static void addMissedMetaTableEntries() {
        ioHandler.print("\n Its under development\n");
    }

    public static void updateMasterKeyPassword(String[] cmdStr, int processIndex) {
        ioHandler.print(logger, "Going to update the Master Key Password\n");
        try {
            int len = cmdStr.length;
            if (len > 2) {
                String pwd = cmdStr[2];
                pwd = CryptoUtil.encrypt((String)pwd, (int)2);
                HashMap<String, Properties> confNameVsProps = new HashMap<String, Properties>();
                Properties prop = new Properties();
                prop.put("masterkey.password", pwd);
                confNameVsProps.put("mssql", prop);
                ConfigurationParser.writeExtendedPersistenceConfFile(null, confNameVsProps, null, null);
                ioHandler.print(logger, "Successfully updated the Master key password.\n");
            } else {
                ioHandler.print(logger, "Please type the password.\n");
            }
        }
        catch (Exception ex) {
            ioHandler.print(logger, "Error updating the Master Key Password" + ex.getMessage() + "\n");
        }
    }

    public static void addMissedAUDGroupEntries() {
        try {
            Row isRowAvail;
            Criteria crit1;
            Row row;
            String fileHome = System.getProperty("server.home") + File.separator + "conf" + File.separator + "adap" + File.separator;
            String fileName = "event-categories.xml";
            DataObject xmlDO = SupportTroubleshooting.getXMLDO(fileHome, fileName);
            DataObject newDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            ioHandler.print(logger, "\n Total Rows as per xml entries of AUDAction " + String.valueOf(xmlDO.size("AUDAction")));
            ioHandler.print(logger, "\n Total Rows as per xml entries of AUDGroup " + String.valueOf(xmlDO.size("AUDGroup")));
            DataObject actionDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDAction", (Criteria)null);
            ioHandler.print(logger, "\n Total Rows in AUDAction entries in db " + String.valueOf(actionDO.size("AUDAction")));
            DataObject groupDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDGroup", (Criteria)null);
            ioHandler.print(logger, "\n Total Rows in AUDGroup entries in db " + String.valueOf(groupDO.size("UVHValues")));
            Criteria crit = new Criteria(Column.getColumn((String)"UVHValues", (String)"TABLE_NAME"), (Object)new String[]{"AUDAction", "AUDGroup"}, 8);
            DataObject uvhDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("UVHValues", crit);
            ioHandler.print(logger, "\n Total Rows in UVHValues entries in db " + String.valueOf(uvhDO.size("UVHValues")));
            DataObject diffDO = actionDO.diff(xmlDO);
            ioHandler.print(logger, "\n Total missed rows of AUDAction " + String.valueOf(diffDO.size("AUDAction")));
            Iterator iter = diffDO.getRows("AUDAction");
            while (iter.hasNext()) {
                row = (Row)iter.next();
                crit1 = new Criteria(Column.getColumn((String)"AUDAction", (String)"ACTION_ID"), row.get("ACTION_ID"), 0);
                isRowAvail = actionDO.getRow("AUDAction", crit1);
                if (isRowAvail != null) continue;
                newDO.addRow(row);
            }
            ioHandler.print(logger, "\n To be added AUDAction rows into db is " + String.valueOf(newDO.size("AUDAction")) + "\n");
            diffDO = groupDO.diff(xmlDO);
            ioHandler.print(logger, "\n Total missed rows of AUDGroup " + String.valueOf(diffDO.size("AUDGroup")));
            iter = diffDO.getRows("AUDGroup");
            while (iter.hasNext()) {
                row = (Row)iter.next();
                crit1 = new Criteria(Column.getColumn((String)"AUDGroup", (String)"GROUP_ID"), row.get("GROUP_ID"), 0);
                isRowAvail = groupDO.getRow("AUDGroup", crit1);
                if (isRowAvail != null) continue;
                newDO.addRow(row);
            }
            ioHandler.print(logger, "\n To be added AUDGroup rows into db is " + String.valueOf(newDO.size("AUDGroup")) + "\n");
            diffDO = uvhDO.diff(xmlDO);
            iter = diffDO.getRows("UVHValues");
            while (iter.hasNext()) {
                row = (Row)iter.next();
                crit1 = new Criteria(Column.getColumn((String)"UVHValues", (String)"GENVALUES"), row.get("GENVALUES"), 0);
                isRowAvail = uvhDO.getRow("UVHValues", crit1 = crit1.and(new Criteria(Column.getColumn((String)"UVHValues", (String)"TABLE_NAME"), (Object)"AUDAction", 0)));
                if (isRowAvail == null) {
                    newDO.addRow(row);
                }
                crit1 = new Criteria(Column.getColumn((String)"UVHValues", (String)"GENVALUES"), row.get("GENVALUES"), 0);
                isRowAvail = uvhDO.getRow("UVHValues", crit1 = crit1.and(new Criteria(Column.getColumn((String)"UVHValues", (String)"TABLE_NAME"), (Object)"AUDGroup", 0)));
                if (isRowAvail != null) continue;
                newDO.addRow(row);
            }
            ioHandler.print(logger, "\n To be added UVHValues rows into db is " + String.valueOf(newDO.size("UVHValues")) + "\n");
            if (newDO.size("AUDGroup") > 0 || newDO.size("UVHValues") > 0 || newDO.size("AUDAction") > 0) {
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(newDO);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ioHandler.print(logger, ex.getMessage());
        }
    }

    public static void enableUWHBatchUpdate() {
        try {
            UpdateQueryImpl query = new UpdateQueryImpl("UserWorkHoursParams");
            query.setCriteria(new Criteria(Column.getColumn((String)"UserWorkHoursParams", (String)"PARAM_NAME"), (Object)"UserWorkHoursBatchUpdate", 0));
            query.setUpdateColumn("PARAM_VALUE", (Object)"true");
            DataAccess.update((UpdateQuery)query);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void resetDefaultVisibleColumns(Long reportId) {
        ioHandler.print(logger, "Going to reset the visible column as defualt for the given report " + reportId);
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDReportCVMapping", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            DataObject mapDO = CommonUtil.getPersistenceLite().get("AUDReportCVMapping", crit);
            if (mapDO.size("AUDReportCVMapping") > 0) {
                Iterator iter = mapDO.getRows("AUDReportCVMapping");
                ArrayList<Long> list = new ArrayList<Long>();
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    list.add((Long)row.get("CV_ID"));
                }
                DataObject columnDO = CommonUtil.getPersistenceLite().get("AUDColumnConfiguration", new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)list.toArray(), 8));
                Iterator iter1 = columnDO.getRows("AUDColumnConfiguration");
                while (iter1.hasNext()) {
                    Row row = (Row)iter1.next();
                    row.set("VISIBLE", row.get("DEFAULTVISIBLE"));
                    columnDO.updateRow(row);
                }
                DataAccess.update((DataObject)columnDO);
                ioHandler.print(logger, "Successfully reset the visible column as defualt for the given report " + reportId);
            }
        }
        catch (Exception ex) {
            ioHandler.print(logger, "Exception while resetting the visible column as defualt for the given report " + reportId);
            logger.info("Error is " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    static {
        try {
            String logFileName = "SupportTroubleshooting";
            LoggerUtil.initLog((String)logFileName, (long)0L, (boolean)false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

