/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.mfw.logging.LoggerUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.SchemaBrowserUtil;
import com.adventnet.persistence.xml.Xml2DoConverter;
import com.adventnet.sym.adsm.auditing.server.analytics.AnalyticsServerHandler;
import com.adventnet.sym.adsm.auditing.server.util.MetaTableHandler;
import com.adventnet.sym.adsm.auditing.server.util.MoveRecreateTableHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.commandline.CmdUtil;
import com.adventnet.sym.adsm.common.server.commandline.IOHandler;
import com.adventnet.sym.adsm.common.server.mysql.tools.ChangeDBServer;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.server.util.MssqlUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.zoho.framework.utils.crypto.CryptoUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class SupportTroubleshooting {
    private static Logger logger = Logger.getLogger("Troubleshooting");
    public static String tABLE_INSTALLED_MACHINE = "ADAPInstalledMachineDetails";
    public static String tABLE_META_TABLE = "AUDMetaTable";
    public static String tABLE_BACKUP_META_TABLE = "AUDBackupMetaTable";
    public static String tABLE_TABLE_DET = "TableDetails";
    public static String tABLE_COLUMN_DET = "ColumnDetails";
    public static String dB_NAME = CommonUtil.getDBServerName();
    private static IOHandler ioHandler = CmdUtil.ioHandler();
    public static String dOMAIN_TABLE = "ADSMDomainConfiguration";
    public static String dc_TABLE = "ADSMDCConfiguration";
    public static String dC_EVT_READ_TABLE = "AUDDCEventRead";
    public static String[] eventFetchMethod = new String[]{"WMI", "Native Method", "EvtQuery", "Real time", "Real time failure switch"};
    public static long[] machineType = new long[]{4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L};
    public static String[] machineTypeStr = new String[]{"FILE_SERVER_ENABLED", "FILE_SERVER_DISABLED", "MEMBER_SERVER_ENABLED", "MEMBER_SERVER_DISABLED", "CLUSTER_FILE_SERVER_ENABLED", "CLUSTER_FILE_SERVER_DISABLED", "NETAPP_FILER_ENABLED", "NETAPP_FILER_DISABLED", "COLLECTOR_ENABLED", "COLLECTOR_DISABLED", "WORK_STATION_ENABLED", "WORK_STATION_DISABLED", "FILE_INTEGRITY_MONITORING_ENABLED", "EMC_STATION_ENABLED", "EMC_STATION_DISABLED", "NETAPP_VSERVER_ENABLED", "NETAPP_VSERVER_DISABLED", "TERMINAL_GATEWAY_SERVER"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getInstalledMachineDetails() {
        logger.info(SupportTroubleshooting.getBanner("To get ADAudit Plus installed Machine Details"));
        StringBuilder sb = new StringBuilder();
        Connection conn = null;
        try {
            DataObject dObj = CommonUtil.getPersistenceLite().get(tABLE_INSTALLED_MACHINE, (Criteria)null);
            if (dObj.size(tABLE_INSTALLED_MACHINE) > 0) {
                Row row = dObj.getRow(tABLE_INSTALLED_MACHINE);
                List columns = row.getColumns();
                for (int i = 0; i < columns.size(); ++i) {
                    sb.append(String.format("%40s : %s\n", columns.get(i), row.get((String)columns.get(i))));
                }
            } else {
                sb.append("Cannot Get the Machine Details from Database");
            }
            if (dB_NAME.equals("mssql")) {
                sb.append("\n").append(String.format("%40s : %s\n", "BCP Status", ChangeDBServer.checkBCPFiles()));
            }
            sb.append("\n\n");
            conn = RelationalAPI.getInstance().getConnection();
            DatabaseMetaData dmd = conn.getMetaData();
            sb.append("\n").append(String.format("%40s : %s\n", "Connection Url", dmd.getURL()));
            QueryUtil.close(null, null, (Connection)conn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            sb.append("Error while getting Machine Details from DB . Error is : " + ex.getMessage());
        }
        finally {
            QueryUtil.close(null, null, conn);
        }
        ioHandler.print(logger, sb.toString());
    }

    public static void printSystemProperties() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(String.format("\n\n%48s\n%48s\n", "System Properties", "-----------------"));
            sb.append(String.format("%40s : %s\n", "The Java TimeZone", TimeUtil.getDefaultTimeZoneId()));
            Process p = Runtime.getRuntime().exec("systeminfo");
            BufferedReader bufReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = bufReader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            sb.append("\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            sb.append("Exception while fetching System Info . Error is : " + ex.getMessage());
        }
        logger.info(sb.toString());
    }

    public static void getMainDataTableCount() {
        StringBuilder sb = new StringBuilder();
        try {
            DataObject dObj = SupportTroubleshooting.getMetaTableDO(false, false);
            ArrayList<String> tableList = SupportTroubleshooting.getTableList(dObj);
            for (int i = 0; i < tableList.size(); ++i) {
                String tableName = tableList.get(i);
                String msg = "Processing " + tableName;
                if (i == tableList.size() - 1) {
                    msg = "Completed !!";
                }
                ioHandler.printProgress(msg, tableList.size(), i + 1);
                int count = SupportTroubleshooting.getRowsCount("SELECT COUNT(UNIQUE_ID) FROM " + tableName);
                sb.append(String.format("%40s : %s\n", tableName, "Total Count : " + count));
                if (count <= 500000) continue;
                sb.append("\n").append(String.format("%40s : %s\n", tableName, "\t Count is greater than Threshold. The count is " + count));
            }
            ioHandler.print(logger, sb.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void eventsBasedCount(File directory, FileFilter fileFilter) {
        boolean totalFileCount = false;
        HashMap<String, Integer> hashmap = new HashMap<String, Integer>();
        try {
            File[] afile;
            StringBuilder sb = new StringBuilder();
            File[] afile1 = afile = directory.listFiles(fileFilter);
            int i = afile1.length;
            int totalEvent = 0;
            for (int j = 0; j < i; ++j) {
                String msg = "Processing";
                if (j == i - 1) {
                    msg = "Completed";
                }
                ioHandler.printProgress(msg, i, j + 1);
                File file1 = afile1[j];
                if (!file1.getName().endsWith(".dmp")) continue;
                Vector vector = null;
                Vector vector1 = new Vector();
                FileInputStream fileinputstream = new FileInputStream(file1);
                ObjectInputStream objectinputstream = new ObjectInputStream(fileinputstream);
                try {
                    vector = (Vector)objectinputstream.readObject();
                    int k = vector.size();
                    totalEvent += k;
                    boolean flag = false;
                    for (int l = 0; l < k; ++l) {
                        HashMap hashtable = (HashMap)vector.get(l);
                        Integer integer = (Integer)hashtable.get("EventCode");
                        int i1 = hashmap.get(integer) == null ? 0 : hashmap.get(integer);
                        hashmap.put((String)((Object)integer), ++i1);
                    }
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                finally {
                    if (objectinputstream != null) {
                        objectinputstream.close();
                    }
                    if (fileinputstream != null) {
                        fileinputstream.close();
                    }
                }
            }
            sb.append("\nTotal Event " + totalEvent).append("\n");
            hashmap = SupportTroubleshooting.sortByValue(hashmap);
            Set<String> keys = hashmap.keySet();
            for (String obj : keys) {
                sb.append(String.format("%40s : %s\n", obj, hashmap.get(obj)));
            }
            sb.append("\n");
            ioHandler.print(logger, sb.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static ArrayList<String> getTableList(DataObject dObj) {
        ArrayList<String> tableList = new ArrayList<String>();
        try {
            Iterator iter = dObj.getRows(tABLE_META_TABLE);
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                tableList.add((String)row.get("LOOKUP_TABLENAME"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tableList;
    }

    public static DataObject getMetaTableDO(boolean allDataTables, boolean isAlertTableNeeded) throws Exception {
        Criteria crit = null;
        if (!allDataTables) {
            crit = new Criteria(Column.getColumn((String)tABLE_META_TABLE, (String)"STATUS"), (Object)"DEFAULT", 0);
        }
        if (isAlertTableNeeded) {
            Criteria crit1 = new Criteria(Column.getColumn((String)tABLE_META_TABLE, (String)"TABLE_NAME"), (Object)"AUDAlert", 0);
            crit = crit != null ? crit.and(crit1) : crit1;
        }
        DataObject dObj = CommonUtil.getPersistenceLite().get(tABLE_META_TABLE, crit);
        return dObj;
    }

    public static String getBanner(String msg) {
        char bannerChar = '*';
        String leftDivider = "----------|| ";
        String rightDivider = " ||----------";
        int bannerLen = 80;
        int leftPadding = 30;
        int lineLen = leftPadding + bannerLen;
        int msgLen = msg.length();
        int dividerLen = leftDivider.length();
        int dividerLeftSpaceLen = (bannerLen - 2 - msgLen) / 2;
        int dividerRightSpaceLen = bannerLen - 2 - msgLen - dividerLeftSpaceLen;
        return String.format("\n\n\n\n\n%" + lineLen + "s\n%" + lineLen + "s\n%" + lineLen + "s\n%" + lineLen + "s\n%" + lineLen + "s\n\n", StringUtils.rightPad((String)"", (int)bannerLen, (char)bannerChar), StringUtils.rightPad((String)(bannerChar + ""), (int)(bannerLen - 1), (char)' ') + bannerChar, StringUtils.leftPad((String)(bannerChar + ""), (int)(leftPadding + 1), (char)' ') + StringUtils.leftPad((String)leftDivider, (int)dividerLeftSpaceLen, (char)' ') + msg + StringUtils.rightPad((String)rightDivider, (int)dividerRightSpaceLen, (char)' ') + bannerChar, StringUtils.rightPad((String)(bannerChar + ""), (int)(bannerLen - 1), (char)' ') + bannerChar, StringUtils.rightPad((String)"", (int)bannerLen, (char)bannerChar));
    }

    public static Date getCutOffDate() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        Date cutoffDate = cal.getTime();
        return cutoffDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRowCount(String tableName) {
        String ret = "OK";
        String query = "SELECT COUNT(*) FROM " + tableName;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            statement.setQueryTimeout(10);
            logger.info("Executing Query :: " + query);
            statement.execute(query);
        }
        catch (Exception e) {
            logger.info("Problem while executing the query: " + query);
            e.printStackTrace();
            ret = e.getMessage();
        }
        finally {
            QueryUtil.close(null, (Statement)statement, (Connection)connection);
        }
        return ret;
    }

    public static int getRowsCount(String query) {
        Integer count = -1;
        try {
            count = QueryUtil.getRowsCountX((String)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder printQueryOutput(String query) {
        StringBuilder sb = new StringBuilder();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery((String)"Get Rows For Custom Query", (Statement)statement, (String)query);
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int columnsNumber = rsmd.getColumnCount();
            String formatPattern = SupportTroubleshooting.getStrFormatPattern(columnsNumber);
            Object[] columnNames = new Object[columnsNumber];
            for (int i = 1; i <= columnsNumber; ++i) {
                columnNames[i - 1] = rsmd.getColumnName(i);
            }
            sb.append(String.format(formatPattern, columnNames));
            while (resultSet.next()) {
                Object[] columnValues = new Object[columnsNumber];
                for (int i = 1; i <= columnsNumber; ++i) {
                    String columnValue = resultSet.getObject(i) == null ? "" : resultSet.getObject(i).toString();
                    columnValues[i - 1] = columnValue;
                }
                sb.append(String.format(formatPattern, columnValues));
            }
            sb.append("\n");
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                sb.append("\nProblem while writing the output : Error is " + ex.getMessage());
            }
            catch (Throwable throwable) {
                QueryUtil.close(resultSet, (Statement)statement, (Connection)connection);
                throw throwable;
            }
            QueryUtil.close((ResultSet)resultSet, (Statement)statement, (Connection)connection);
        }
        QueryUtil.close((ResultSet)resultSet, (Statement)statement, (Connection)connection);
        return sb;
    }

    public static void allBasicConfiguration() {
        logger.info(SupportTroubleshooting.getBanner("Get ADAudit Plus basic configuration."));
        int domainCount = 0;
        int dcCount = 0;
        HashMap domainMap = new HashMap();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)dOMAIN_TABLE));
            Join innerJoin1 = new Join(Table.getTable((String)dOMAIN_TABLE), Table.getTable((String)dc_TABLE), new String[]{"DOMAIN_NAME"}, new String[]{"DOMAIN_NAME"}, 2);
            query.addJoin(innerJoin1);
            Join innerJoin2 = new Join(Table.getTable((String)dc_TABLE), Table.getTable((String)dC_EVT_READ_TABLE), new String[]{"DOMAIN_CONTROLLER_ID"}, new String[]{"DOMAIN_CONTROLLER_ID"}, 2);
            query.addJoin(innerJoin2);
            query.setCriteria((Criteria)null);
            query.addSelectColumn(Column.getColumn((String)dOMAIN_TABLE, (String)"*"));
            query.addSelectColumn(Column.getColumn((String)dc_TABLE, (String)"*"));
            query.addSelectColumn(Column.getColumn((String)dC_EVT_READ_TABLE, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator domainIter = dataObject.getRows(dOMAIN_TABLE);
            ioHandler.print(logger, SupportTroubleshooting.getBanner("Configured Domain Details"));
            Long currTime = System.currentTimeMillis() / 1000L;
            while (domainIter.hasNext()) {
                Row domainRow = (Row)domainIter.next();
                ++domainCount;
                String domainName = (String)domainRow.get("DOMAIN_NAME");
                ioHandler.print(logger, SupportTroubleshooting.getBanner("Getting the Details of " + domainName));
                Iterator dcIter = dataObject.getRows(dc_TABLE, new Criteria(Column.getColumn((String)dc_TABLE, (String)"DOMAIN_NAME"), (Object)domainName, 0));
                int realTime = 0;
                int evtQuery = 0;
                int nativeM = 0;
                int wmi = 0;
                StringBuilder probDCs = new StringBuilder();
                block8: while (dcIter.hasNext()) {
                    Row dcRow = (Row)dcIter.next();
                    Long dcId = (Long)dcRow.get("DOMAIN_CONTROLLER_ID");
                    Row dcProp = dataObject.getRow(dC_EVT_READ_TABLE, new Criteria(Column.getColumn((String)dC_EVT_READ_TABLE, (String)"DOMAIN_CONTROLLER_ID"), (Object)dcId, 0));
                    ++dcCount;
                    StringBuilder sb = new StringBuilder();
                    int eventFetchMode = -1;
                    if (dcProp != null) {
                        eventFetchMode = (Integer)dcProp.get("EVENT_FETCH_MODE");
                        sb.append("\n").append(domainName).append("\t").append((String)dcRow.get("DOMAIN_CONTROLLER_NAME")).append("\t").append(eventFetchMethod[eventFetchMode]);
                        Long recentEventFetch = (Long)dcProp.get("RECENT_EVENT_TIME");
                        if (recentEventFetch < currTime - 86400L) {
                            probDCs.append("\t").append((String)dcRow.get("DOMAIN_CONTROLLER_NAME")).append("\t(Recent Event Time").append(new Date(recentEventFetch)).append(")").append("\n");
                        }
                    } else {
                        sb.append("\n").append(domainName).append("\t").append((String)dcRow.get("DOMAIN_CONTROLLER_NAME")).append("\t").append("Had issue with Event Fetch Details Table");
                    }
                    ioHandler.print(logger, sb.toString());
                    switch (eventFetchMode) {
                        case 0: {
                            ++wmi;
                            continue block8;
                        }
                        case 1: {
                            ++nativeM;
                        }
                        case 2: {
                            ++evtQuery;
                        }
                    }
                    ++realTime;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("\n\n\nTotal DCs and its count based on Event Fetch Mode").append("\n\t").append("Domain Name : ").append(domainName);
                sb.append("\n\tTotal DC Count : ").append(wmi + nativeM + evtQuery + realTime);
                if (wmi > 0) {
                    sb.append("\n\t").append(eventFetchMethod[0]).append("\t").append(wmi);
                }
                if (nativeM > 0) {
                    sb.append("\n\t").append(eventFetchMethod[1]).append("\t").append(nativeM);
                }
                if (evtQuery > 0) {
                    sb.append("\n\t").append(eventFetchMethod[2]).append("\t").append(evtQuery);
                }
                if (realTime > 0) {
                    sb.append("\n\t").append(eventFetchMethod[3]).append("\t").append(realTime);
                }
                sb.append("\n\nThe following DCs Recent Event Time is old than oneday as of now\n");
                sb.append("\n").append(probDCs.toString());
                ioHandler.print(logger, sb.toString());
                DataObject rpDO = CommonUtil.getPersistenceLite().get("AUDMonitor", new Criteria(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                int rpCount = rpDO.size("AUDMonitor");
                ioHandler.print(logger, "\n\nTotal Report Profiles for " + domainName + " is " + rpCount);
                int apCount = 0;
                rpDO = CommonUtil.getPersistenceLite().get("AUDPrinterAlertCriteria", new Criteria(Column.getColumn((String)"AUDPrinterAlertCriteria", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                apCount = rpDO.size("AUDPrinterAlertCriteria");
                rpDO = CommonUtil.getPersistenceLite().get("AUDAnalyticsAlertCriteria", new Criteria(Column.getColumn((String)"AUDAnalyticsAlertCriteria", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                apCount += rpDO.size("AUDAnalyticsAlertCriteria");
                SelectQueryImpl query1 = new SelectQueryImpl(Table.getTable((String)"AUDAlertProfile"));
                Join innerJoin3 = new Join(Table.getTable((String)"AUDAlertProfile"), Table.getTable((String)"AUDAlertMonitorMap"), new String[]{"ALERT_PROFILE_ID"}, new String[]{"ALERT_PROFILE_ID"}, 2);
                query1.addJoin(innerJoin3);
                Join innerJoin4 = new Join(Table.getTable((String)"AUDAlertMonitorMap"), Table.getTable((String)"AUDMonitor"), new String[]{"MONITOR_ID"}, new String[]{"MONITOR_ID"}, 2);
                query1.addJoin(innerJoin4);
                query1.setCriteria(new Criteria(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                query1.addSelectColumn(Column.getColumn((String)"AUDAlertProfile", (String)"*"));
                query1.addSelectColumn(Column.getColumn((String)"AUDAlertMonitorMap", (String)"*"));
                query1.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"*"));
                rpDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query1);
                ioHandler.print(logger, "\n\nTotal Alert Profiles for " + domainName + " is " + (apCount += rpDO.size("AUDAlertProfile")));
                ioHandler.print(logger, "\n");
                SelectQueryImpl query2 = new SelectQueryImpl(Table.getTable((String)"AUDComputerEventRead"));
                Join innerJoin5 = new Join(Table.getTable((String)"AUDComputerEventRead"), Table.getTable((String)"ADSMComputerGeneralDetails"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
                query2.addJoin(innerJoin5);
                query2.setCriteria(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                query2.addSelectColumn(Column.getColumn((String)"AUDComputerEventRead", (String)"*"));
                query2.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"*"));
                DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query2);
                Iterator iter = dObj.getRows("AUDComputerEventRead");
                HashMap<String, Integer> serverCountMap = new HashMap<String, Integer>();
                HashMap<String, Integer> agentMap = new HashMap<String, Integer>();
                HashMap<String, String> probsServer = new HashMap<String, String>();
                while (iter.hasNext()) {
                    Row compRow = (Row)iter.next();
                    long mType = (Long)compRow.get("MACHINE_TYPE_LONG");
                    boolean isAgent = (Boolean)compRow.get("IS_AGENT");
                    long recentEventTime = (Long)compRow.get("RECENT_EVENT_TIME");
                    for (int j = 0; j < machineType.length; ++j) {
                        long mT = machineType[j];
                        if ((mType & mT) != mT) continue;
                        int count = serverCountMap.get("machineType_" + mT) != null ? (Integer)serverCountMap.get("machineType_" + mT) : 0;
                        serverCountMap.put("machineType_" + mT, count + 1);
                        int agentCount = agentMap.get("machineType_" + mT) != null ? (Integer)agentMap.get("machineType_" + mT) : 0;
                        agentMap.put("machineType_" + mT, agentCount);
                        if (recentEventTime <= 0L || recentEventTime >= currTime - 86400L) continue;
                        String objectGuid = (String)compRow.get("OBJECT_GUID");
                        Row compDetRow = dObj.getRow("ADSMComputerGeneralDetails", new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0));
                        String probServer = probsServer.get("machineType_" + mT) != null ? (String)probsServer.get("machineType_" + mT) + " , " + (String)compDetRow.get("NAME") : (String)compDetRow.get("NAME");
                        probsServer.put("machineType_" + mT, probServer);
                    }
                }
                ioHandler.print(logger, "\nGetting Server Details\n\n");
                SupportTroubleshooting.printServerDetails(serverCountMap);
                ioHandler.print(logger, "\nGetting Agent Details:\n\n");
                SupportTroubleshooting.printServerDetails(agentMap);
                ioHandler.print(logger, "\nThe following Servers Recent Event Time is old than oneday as of now:\n\n");
                SupportTroubleshooting.printServerDetails(probsServer);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void printServerDetails(HashMap serverCountMap) {
        StringBuilder sb = new StringBuilder();
        try {
            Set keySet = serverCountMap.keySet();
            for (Object key : keySet) {
                long mType = Long.parseLong(((String)key).split("_")[1]);
                for (int j = 0; j < machineType.length; ++j) {
                    if ((mType & machineType[j]) != mType) continue;
                    try {
                        int count = (Integer)serverCountMap.get(key);
                        if (count <= 0) continue;
                        sb.append("\t").append(machineTypeStr[j]).append("\t:\t").append(count).append("\n");
                        continue;
                    }
                    catch (Exception ex) {
                        sb.append("\t").append(machineTypeStr[j]).append("\t:\t").append(serverCountMap.get(key)).append("\n");
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            sb.append("Proble while print the Details , Error is " + ex.getMessage());
        }
        ioHandler.print(logger, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reindexTable(String fileName, boolean isReindex, boolean isVacuum) {
        Connection connection = null;
        Statement statement = null;
        StringBuilder query = new StringBuilder();
        ResultSet rs = null;
        try {
            String initQuery1 = "set zero_damaged_pages=on;";
            String initQuery2 = "set zero_damaged_pages=off;";
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            rs = SupportTroubleshooting.getTableNameRS(fileName, statement);
            String tableName = null;
            while (rs.next()) {
                tableName = rs.getString("relname");
            }
            query.append(initQuery1);
            if (isVacuum) {
                query.append("vacuum verbose ").append(tableName).append(";");
            }
            if (isReindex) {
                query.append("reindex table ").append(tableName).append(";");
            }
            query.append(initQuery2);
            logger.info("Executing Query :: " + query.toString());
            statement.executeUpdate(query.toString());
        }
        catch (Exception e) {
            try {
                logger.info("Problem while executing the query: " + query.toString());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                QueryUtil.close(rs, statement, connection);
                throw throwable;
            }
            QueryUtil.close((ResultSet)rs, (Statement)statement, (Connection)connection);
        }
        QueryUtil.close((ResultSet)rs, (Statement)statement, (Connection)connection);
    }

    private static ResultSet getTableNameRS(String relFileNode, Statement statement) throws Exception {
        String query = "select relname from pg_class where relfilenode = " + EscapeUtil.escSplCharsAsSQL((Object)relFileNode);
        return QueryUtil.executeQuery((String)"Getting Table Name", (Statement)statement, (String)query);
    }

    public static HashMap<String, Integer> sortByValue(HashMap<String, Integer> hm) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(hm.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        LinkedHashMap<String, Integer> temp = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            temp.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return temp;
    }

    public static void getTableCount(String tableName, Long startTime, Long endTime) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        StringBuilder sb = new StringBuilder();
        sb.append("\nGetting the Table Count ");
        sb.append("\nTable Name : ").append(tableName);
        sb.append("\nStart Time : ").append(new Date(startTime));
        sb.append("\nEnd Time   : ").append(new Date(endTime));
        try {
            map.put("from", startTime);
            map.put("to", endTime);
            String query = "select unique_id from ${TABLE:" + tableName + "} as a";
            ArrayList tableList = MetaTableHandler.getTableNames((String)query, map);
            sb.append("The available Tables are/is \n");
            int count = 0;
            for (int i = 0; i < tableList.size(); ++i) {
                String[] tables = (String[])tableList.get(i);
                for (int j = 0; j < tables.length; ++j) {
                    ++count;
                    sb.append(tables[i]).append("\n");
                }
            }
            sb.append("\nTotal TableList Count is ").append(tableList.size()).append("\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            sb.append("Problem while getting the Table Count for given Time Period . The Error is : ").append(ex.getMessage()).append("\n");
        }
        ioHandler.print(logger, sb.toString());
    }

    public static void addMissedRowToDO(DataObject newDO, String fileHome, String fileName, Long[] containerId, String tableName) {
        Iterator iter = null;
        try {
            DataObject dObj = SupportTroubleshooting.getXMLDO(fileHome, fileName);
            iter = dObj.getRows(tableName, new Criteria(Column.getColumn((String)tableName, (String)"CONTAINER_ID"), (Object)containerId, 8));
            while (iter.hasNext()) {
                newDO.addRow((Row)iter.next());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static DataObject getXMLDO(String fileHome, String fileName) throws Exception {
        HashMap patternValues = SchemaBrowserUtil.getPatternValues((String)fileName);
        DataObject dObj = Xml2DoConverter.transform((URL)new File(fileHome + fileName).toURI().toURL(), (boolean)false, (Map)patternValues);
        return dObj;
    }

    public static void scheduleTime2RunNow(String scheduleName) {
        ioHandler.print(logger, "Going to change the Next Schedule Time as Run Now for the scheduler " + scheduleName + ", the schedule starts within 10 minutes\n");
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)scheduleName, 0);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("Schedule", crit);
            if (dObj.size("Schedule") > 0) {
                Row row = dObj.getRow("Schedule");
                crit = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), row.get("SCHEDULE_ID"), 0);
                dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("Task_Input", crit);
                row = dObj.getRow("Task_Input");
                row.set("SCHEDULE_TIME", (Object)new Date(System.currentTimeMillis() + 6000L));
                dObj.updateRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
            } else {
                ioHandler.print(logger, "Please Enter valid schedule name\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ioHandler.print(logger, "Exception while updating the Schedule Time . Error is " + ex.getMessage() + "\n");
        }
    }

    public static void getSizeOfFolder(String prodHome, String folderName) {
        long size = 0L;
        long filesCount = 0L;
        StringBuilder sb = new StringBuilder();
        try {
            File folder = new File(prodHome + folderName);
            if (folder.exists() && folder.isDirectory()) {
                sb.append("\nDetails of the Folder : ").append(folderName);
                size = FileUtils.sizeOfDirectory((File)folder);
                sb.append("\nSize of Folder : ").append(String.valueOf((double)size / 1024.0 / 1024.0)).append(" MB");
                filesCount = folder.listFiles().length;
                sb.append("\nFiles Count : ").append(String.valueOf(filesCount));
            } else {
                ioHandler.print(logger, "\nThe folder " + folderName + " is not available");
            }
        }
        catch (Exception ex) {
            sb.append("\nError while getting details of folder ").append(folderName).append(", Error is ").append(ex.getMessage()).append("\n");
        }
        sb.append("\n");
        ioHandler.print(logger, sb.toString());
    }

    public static void processRunQuery(String[] cmdStr, int processIndex) throws IOException {
        ioHandler.print(logger, String.format("\n%s\n\n", " # Command not implemented!"));
    }

    public static void getFeatureStatus() {
        ioHandler.print(logger, "Getting feature status\n");
        StringBuilder sb = new StringBuilder();
        try {
            String query = "select * from ((select 'SystemParams' as table_name, param_name, param_value  from SystemParams  ) union all (select 'ExportParams' as table_name, param_name, param_value  from ExportParams  ) union all (select 'CloudSystemParams' as table_name, param_name, param_value  from CloudSystemParams  ) union all (select 'AudAclIndexParams' as table_name, param_name, param_value  from AudAclIndexParams  ) union all (select 'AUDFileServerParams' as table_name, param_name, param_value  from AUDFileServerParams  ) union all (select 'AgentSystemParams' as table_name, param_name, param_value  from AgentSystemParams  ) ) as a";
            sb = SupportTroubleshooting.printQueryOutput(query);
            ioHandler.print(logger, sb.toString());
            sb = SupportTroubleshooting.printQueryOutput("select 'SyslogParams' as table_name, * from SyslogParams");
            ioHandler.print(logger, sb.toString());
            sb = SupportTroubleshooting.printQueryOutput("select 'AUDAnalyticsParams' as table_name, * from AUDAnalyticsParams");
            logger.info(sb.toString());
            ioHandler.print("\nThe output is available in the logs ,log name likes SupportTroubleshootinglog_<today>.txt\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ioHandler.print(logger, "\nProblem while getting the Feature Status Settings. Error is " + ex.getMessage());
        }
    }

    public static void getCreateTableSyntax(String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n Going to get the Create Table Syntax for the table ").append(tableName).append("\n");
        String syntax = MoveRecreateTableHandler.getPSQLCreateTableSyntax((String)tableName, (String)dB_NAME);
        sb.append(syntax).append("\n");
        ioHandler.print(logger, sb.toString());
    }

    private static String getStrFormatPattern(int columnCount) {
        int percent = 100 / columnCount;
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < columnCount; ++i) {
            ret.append("%").append(String.valueOf(percent)).append("s");
        }
        ret.append("\n");
        return ret.toString();
    }

    public static void dbUpdateCall() {
        SupportTroubleshooting.addNewColumnConfigRow();
    }

    public static void addNewColumnConfigRow() {
        try {
            ioHandler.print(logger, "Under construction");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int getIndexVal(String tableName) {
        int retIndex = 0;
        if (tableName.equalsIgnoreCase("AUDGroupMgmt")) {
            retIndex = 7;
        } else if (tableName.equalsIgnoreCase("ADAPUserAuditInfo")) {
            retIndex = 9;
        } else if (tableName.equalsIgnoreCase("AUDCDSAccountMgmt")) {
            retIndex = 11;
        } else if (tableName.equalsIgnoreCase("AUDUserActiveTimeInfo") || tableName.equalsIgnoreCase("AudPrintJobsInQueue")) {
            retIndex = 6;
        } else if (tableName.equalsIgnoreCase("AUDLogonInfo") || tableName.equalsIgnoreCase("AUDADFSLogonLogoffInfo") || tableName.equalsIgnoreCase("AUDLogonLogoffInfo")) {
            retIndex = 5;
        } else if (tableName.equalsIgnoreCase("AUDUserMgmt") || tableName.equalsIgnoreCase("AUDAccountCreation") || tableName.equalsIgnoreCase("AUDADOAuditInfo") || tableName.equalsIgnoreCase("AUDComputerMgmt") || tableName.equalsIgnoreCase("AUDDNSAuditInfo") || tableName.equalsIgnoreCase("AUDFileAuditInfo") || tableName.equalsIgnoreCase("AUDFileIntegrityMonitor") || tableName.equalsIgnoreCase("AUDGPOMgmt") || tableName.equalsIgnoreCase("AUDOUMgmt")) {
            retIndex = 3;
        } else if (tableName.equalsIgnoreCase("AUDPolicyChange") || tableName.equalsIgnoreCase("AUDCDSLogonInfo") || tableName.equalsIgnoreCase("AudGPOAuditInfo") || tableName.equalsIgnoreCase("AUDComputerAuditInfo") || tableName.equalsIgnoreCase("AUDNPSAuditInfo") || tableName.equalsIgnoreCase("AUDSystemStartShutdownInfo") || tableName.equalsIgnoreCase("AUDLDAPAuditInfo")) {
            retIndex = 2;
        }
        return retIndex;
    }

    private static String returnTimeVal(String[] splitVal, String tableName) {
        String returnVal = splitVal[0];
        logger.info("Initially " + returnVal);
        if (tableName.equalsIgnoreCase("AUDGroupMgmt")) {
            returnVal = splitVal[7];
        } else if (tableName.equalsIgnoreCase("ADAPUserAuditInfo")) {
            returnVal = splitVal[9];
        } else if (tableName.equalsIgnoreCase("AUDCDSAccountMgmt")) {
            returnVal = splitVal[11];
        } else if (tableName.equalsIgnoreCase("AUDUserActiveTimeInfo") || tableName.equalsIgnoreCase("AudPrintJobsInQueue")) {
            returnVal = splitVal[6];
        } else if (tableName.equalsIgnoreCase("AUDLogonInfo") || tableName.equalsIgnoreCase("AUDADFSLogonLogoffInfo") || tableName.equalsIgnoreCase("AUDLogonLogoffInfo")) {
            returnVal = splitVal[5];
        } else if (tableName.equalsIgnoreCase("AUDUserMgmt") || tableName.equalsIgnoreCase("AUDAccountCreation") || tableName.equalsIgnoreCase("AUDADOAuditInfo") || tableName.equalsIgnoreCase("AUDComputerMgmt") || tableName.equalsIgnoreCase("AUDDNSAuditInfo") || tableName.equalsIgnoreCase("AUDFileAuditInfo") || tableName.equalsIgnoreCase("AUDFileIntegrityMonitor") || tableName.equalsIgnoreCase("AUDGPOMgmt") || tableName.equalsIgnoreCase("AUDOUMgmt")) {
            returnVal = splitVal[3];
        } else if (tableName.equalsIgnoreCase("AUDPolicyChange") || tableName.equalsIgnoreCase("AUDCDSLogonInfo") || tableName.equalsIgnoreCase("AudGPOAuditInfo") || tableName.equalsIgnoreCase("AUDComputerAuditInfo") || tableName.equalsIgnoreCase("AUDNPSAuditInfo") || tableName.equalsIgnoreCase("AUDSystemStartShutdownInfo") || tableName.equalsIgnoreCase("AUDLDAPAuditInfo")) {
            returnVal = splitVal[2];
        }
        logger.info("Finally " + returnVal);
        return returnVal;
    }

    public static ArrayList getDuplicateAlertID(Criteria crit) {
        ArrayList<Long> alertIdList = new ArrayList<Long>();
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDAlertMonitorMap"));
        selectQuery.setCriteria(crit);
        selectQuery.addSelectColumn(Column.getColumn((String)"AUDAlertMonitorMap", (String)"ALERT_PROFILE_ID"));
        try {
            DataObject dataObj = DataAccess.get((String)"AUDAlertMonitorMap", (Criteria)crit);
            if (!dataObj.isEmpty()) {
                Iterator itr = dataObj.getRows("AUDAlertMonitorMap");
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    Long alertProfileId = (Long)row.get("ALERT_PROFILE_ID");
                    alertIdList.add(alertProfileId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return alertIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteExistingProfiles(String domainName) {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            ArrayList<Long> uniqueIdList = new ArrayList<Long>();
            ArrayList alertIdList = new ArrayList();
            String query = "SELECT MONITOR_ID FROM AUDMONITOR WHERE DOMAIN_NAME  = '" + domainName + "'";
            dataSet = relationalAPI.executeQuery(query, connection);
            while (dataSet.next()) {
                uniqueIdList.add((Long)dataSet.getValue("MONITOR_ID"));
            }
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)uniqueIdList.toArray(new Long[uniqueIdList.size()]), 8);
            Criteria alertCrit = new Criteria(Column.getColumn((String)"AUDAlertMonitorMap", (String)"MONITOR_ID"), (Object)uniqueIdList.toArray(new Long[uniqueIdList.size()]), 8);
            alertIdList = SupportTroubleshooting.getDuplicateAlertID(alertCrit);
            Criteria alertProfileCrit = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), (Object)alertIdList.toArray(new Long[alertIdList.size()]), 8);
            DataAccess.delete((String)"AUDMonitor", (Criteria)crit);
            DataAccess.delete((String)"AUDAlertMonitorMap", (Criteria)alertCrit);
            DataAccess.delete((String)"AUDAlertProfile", (Criteria)alertProfileCrit);
            QueryUtil.closeDS((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            QueryUtil.closeDS(dataSet, (Connection)connection);
        }
    }

    public static Boolean checkAnalyticsEntries(String domainName) {
        String referenceCountQuery = "SELECT COUNT(*) FROM AUDAnalyticsReference WHERE DOMAIN_NAME = '" + domainName + "'";
        int referenceCount = QueryUtil.getRowsCount((String)referenceCountQuery);
        if (referenceCount < 16) {
            return true;
        }
        String settingsCountQuery = "SELECT COUNT(*) FROM AUDAnalyticsSettings WHERE DOMAIN_NAME = '" + domainName + "'";
        int settingsCount = QueryUtil.getRowsCount((String)settingsCountQuery);
        if (settingsCount < 16) {
            return true;
        }
        String paramCountQuery = "SELECT COUNT(*) FROM AUDAnalyticsParams WHERE PARAM_NAME_1 = '" + domainName + "'";
        int paramCount = QueryUtil.getRowsCount((String)paramCountQuery);
        if (paramCount < 1) {
            return true;
        }
        String alertCountQuery = "SELECT COUNT(*) FROM AUDAnalyticsAlertCriteria WHERE DOMAIN_NAME = '" + domainName + "'";
        int alertCount = QueryUtil.getRowsCount((String)alertCountQuery);
        if (alertCount < 17) {
            return true;
        }
        return false;
    }

    public static void deleteOldAnalyticsEntries(String domainName) {
        Criteria referenceCrit = new Criteria(Column.getColumn((String)"AUDAnalyticsReference", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        Criteria settingsCrit = new Criteria(Column.getColumn((String)"AUDAnalyticsSettings", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        Criteria paramsCrit = new Criteria(Column.getColumn((String)"AUDAnalyticsParams", (String)"PARAM_NAME_1"), (Object)domainName, 0);
        Criteria alertCrit = new Criteria(Column.getColumn((String)"AUDAnalyticsAlertCriteria", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        try {
            DataAccess.delete((Criteria)referenceCrit);
            DataAccess.delete((Criteria)settingsCrit);
            DataAccess.delete((Criteria)paramsCrit);
            DataAccess.delete((Criteria)alertCrit);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllDuplicateAnalyticsEntries() {
        Connection connection = null;
        ResultSet dataSet = null;
        PreparedStatement pstat = null;
        try {
            ArrayList domainList = DomainHandler.getConfiguredList((Long)1L);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            ArrayList<Long> uniqueIdList = new ArrayList<Long>();
            for (int i = 0; i < domainList.size(); ++i) {
                Properties prop = (Properties)domainList.get(i);
                String domainName = prop.getProperty("DOMAIN_NAME");
                String query = "SELECT REF_UNIQUE_ID FROM AUDAnalyticsReference WHERE REF_UNIQUE_ID NOT IN (SELECT MIN(REF_UNIQUE_ID) FROM AUDAnalyticsReference WHERE DOMAIN_NAME  = ? GROUP BY CONF_ID) AND DOMAIN_NAME = ?";
                pstat = connection.prepareStatement(query);
                pstat.setString(1, domainName);
                pstat.setString(2, domainName);
                dataSet = pstat.executeQuery();
                while (dataSet.next()) {
                    uniqueIdList.add(dataSet.getLong("REF_UNIQUE_ID"));
                }
            }
            if (uniqueIdList.size() > 0) {
                Criteria crit = new Criteria(Column.getColumn((String)"AUDAnalyticsReference", (String)"REF_UNIQUE_ID"), (Object)uniqueIdList.toArray(new Long[uniqueIdList.size()]), 8);
                Criteria critAnalyticsSettings = new Criteria(Column.getColumn((String)"AUDAnalyticsSettings", (String)"REF_UNIQUE_ID"), (Object)uniqueIdList.toArray(new Long[uniqueIdList.size()]), 8);
                DataAccess.delete((Criteria)crit);
                DataAccess.delete((Criteria)critAnalyticsSettings);
                AnalyticsServerHandler.deleteAllDuplicateAnalyticsSettingsEntries();
            }
            SupportTroubleshooting.deleteAllDuplicateAnalyticsAlertEntries();
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                QueryUtil.closePrep(dataSet, pstat, connection);
                throw throwable;
            }
            QueryUtil.closePrep(dataSet, pstat, (Connection)connection);
        }
        QueryUtil.closePrep(dataSet, pstat, (Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteAllDuplicateAnalyticsAlertEntries() {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            ArrayList domainList = DomainHandler.getConfiguredList((Long)1L);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            ArrayList<Long> uniqueIdList = new ArrayList<Long>();
            for (int i = 0; i < domainList.size(); ++i) {
                Properties prop = (Properties)domainList.get(i);
                String domainName = prop.getProperty("DOMAIN_NAME");
                String query = "SELECT ALERT_PROFILE_ID FROM AUDAnalyticsAlertCriteria  WHERE ALERT_PROFILE_ID NOT IN (SELECT MIN(ALERT_PROFILE_ID) AS ALERT_PROFILE_ID FROM AUDAnalyticsAlertCriteria  WHERE DOMAIN_NAME  = '" + domainName + "' GROUP BY REPORT_ID) AND DOMAIN_NAME = '" + domainName + "'";
                dataSet = relationalAPI.executeQuery(query, connection);
                while (dataSet.next()) {
                    uniqueIdList.add((Long)dataSet.getValue("ALERT_PROFILE_ID"));
                }
            }
            if (uniqueIdList.size() > 0) {
                Criteria crit = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), (Object)uniqueIdList.toArray(new Long[uniqueIdList.size()]), 8);
                Criteria critAnalyticsAlert = new Criteria(Column.getColumn((String)"AUDAnalyticsAlertCriteria", (String)"ALERT_PROFILE_ID"), (Object)uniqueIdList.toArray(new Long[uniqueIdList.size()]), 8);
                DataAccess.delete((Criteria)crit);
                DataAccess.delete((Criteria)critAnalyticsAlert);
            }
            QueryUtil.closeDS(dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            QueryUtil.closeDS(dataSet, connection);
        }
    }

    public static boolean isValidInet4Address(String ip) {
        String IPV4_REGEX = "^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
        Pattern IPv4_PATTERN = Pattern.compile(IPV4_REGEX);
        if (ip == null) {
            return false;
        }
        Matcher matcher = IPv4_PATTERN.matcher(ip);
        return matcher.matches();
    }

    public static Criteria getdeleteArchiveDataCriteria(String operator, String[] cmdStr) {
        Criteria crit = null;
        try {
            if (operator.equalsIgnoreCase("lt")) {
                Long ltTime = SupportTroubleshooting.convertDateToTimeStamp(cmdStr[3]);
                if (!ltTime.equals(0L)) {
                    crit = new Criteria(Column.getColumn((String)tABLE_BACKUP_META_TABLE, (String)"END_TIME"), (Object)ltTime, 7);
                }
            } else if (operator.equalsIgnoreCase("bt")) {
                Long gtTime = SupportTroubleshooting.convertDateToTimeStamp(cmdStr[3]);
                Long ltTime = SupportTroubleshooting.convertDateToTimeStamp(cmdStr[4]);
                if (!ltTime.equals(0L) && !gtTime.equals(0L)) {
                    crit = new Criteria(Column.getColumn((String)tABLE_BACKUP_META_TABLE, (String)"END_TIME"), (Object)ltTime, 7);
                    crit = crit.and(new Criteria(Column.getColumn((String)tABLE_BACKUP_META_TABLE, (String)"START_TIME"), (Object)gtTime, 5));
                }
            }
            logger.info("Returned Criteria :: " + crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public static Long convertDateToTimeStamp(String date) {
        Long timeStamp = 0L;
        try {
            logger.info("Converting date :: " + date);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date dt = null;
            sdf.setLenient(false);
            dt = sdf.parse(date);
            timeStamp = dt.getTime() / 1000L;
            logger.info("Converting date to Timestamp :: " + date + " = " + timeStamp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timeStamp;
    }

    public static void deleteDuplicateRows(String baseTableName, String groupBy, String uniqueCol) {
        SupportTroubleshooting.deleteDuplicateRows(new String[]{baseTableName}, groupBy, uniqueCol);
    }

    public static void deleteDuplicateRows(String[] baseTableName, String groupBy, String uniqueCol) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"), (Object)baseTableName, 8);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDMetaTable", crit);
            Iterator iter = dObj.getRows("AUDMetaTable");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String lookupTableName = (String)row.get("LOOKUP_TABLENAME");
                logger.info("Table Name      :: " + lookupTableName);
                String query = "delete from " + lookupTableName + " where " + uniqueCol + " not in (select min(" + uniqueCol + ") from " + lookupTableName + " group by " + groupBy + ")";
                logger.info("Query to delete :: " + query);
                QueryUtil.executeSingleQuery((String)"Delete Duplicate Rows ", (String)query);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void getDBPassword(String username) {
        try {
            if (!dB_NAME.equalsIgnoreCase("mssql")) {
                if (username.equalsIgnoreCase("postgres")) {
                    DataObject dbcredentialsaudit = DataAccess.get((String)"DBCredentialsAudit", (Criteria)new Criteria(Column.getColumn((String)"DBCredentialsAudit", (String)"USERNAME"), (Object)"postgres", 0));
                    Row credentialRow = dbcredentialsaudit.getRow("DBCredentialsAudit");
                    String postgresPassword = (String)credentialRow.get("PASSWORD");
                    ioHandler.print("The PG Password is " + postgresPassword + "\n");
                } else {
                    String encPassword = ChangeDBServer.getPropertyValue((String)"password");
                    String password = CryptoUtil.decrypt((String)encPassword, (int)2);
                    ioHandler.print("The Password is " + password + "\n");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void backupMickeyMetaTables(String path) {
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("TableDetails");
            tableList.add("ColumnDetails");
            tableList.add("UniqueKeyDefinition");
            tableList.add("PKDefinition");
            tableList.add("FKDefinition");
            tableList.add("FKColumnDefinition");
            tableList.add("ConstraintDefinition");
            tableList.add("IndexDefinition");
            if (dB_NAME.equalsIgnoreCase("mssql")) {
                tableList.add("sys.tables");
            } else if (dB_NAME.equalsIgnoreCase("postgres")) {
                tableList.add("pg_tables");
                tableList.add("pg_class");
            }
            for (int i = 0; i < tableList.size(); ++i) {
                SupportTroubleshooting.getTableBackup((String)tableList.get(i), path);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void getTableBackup(String tableName, String storagePath) {
        try {
            String fileName = storagePath + File.separator + tableName + ".csv";
            if (dB_NAME.equalsIgnoreCase("mssql")) {
                MssqlUtil.archiveTablesForSQLServer((String)tableName, (String)fileName, (int)25000);
            } else if (dB_NAME.equalsIgnoreCase("postgres")) {
                QueryUtil.copyDataToFile((String)tableName, null, (String)fileName, (boolean)false);
            } else {
                fileName = fileName.replace("\\", "\\\\");
                String query = "SELECT * INTO OUTFILE \"" + fileName + "\" FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"' LINES TERMINATED BY '\n' FROM " + tableName;
                QueryUtil.executeSingleQuery((String)"Backup the Table", (String)query);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getDataSet(String query) {
        HashMap<String, Long> tableDetails = new HashMap<String, Long>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = RelationalAPI.getInstance().getConnection();
            stmt = con.prepareStatement(query);
            rs = stmt.executeQuery();
            tableDetails.put("START_TIME", rs.getLong("MIN_TIME_GENERATED"));
            tableDetails.put("END_TIME", rs.getLong("MAX_TIME_GENERATED"));
            tableDetails.put("START_INDEX", rs.getLong("MIN_UNIQUE_ID"));
            tableDetails.put("END_INDEX", rs.getLong("MAX_UNIQUE_ID"));
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                QueryUtil.closePrep(rs, stmt, (Connection)con);
                throw throwable;
            }
            QueryUtil.closePrep(rs, (PreparedStatement)stmt, (Connection)con);
        }
        QueryUtil.closePrep((ResultSet)rs, (PreparedStatement)stmt, (Connection)con);
        return tableDetails;
    }

    public static void fixProcessedErr() {
        logger.info("Going to fix processed_err folder");
        String processedFolderPath = System.getProperty("server.home") + File.separator + "eventdata" + File.separator + "processed";
        String processedErrFolderPath = System.getProperty("server.home") + File.separator + "eventdata" + File.separator + "processed_err";
        File processedErrFolder = new File(processedErrFolderPath);
        File[] listOfFiles = processedErrFolder.listFiles();
        String encoding = "UTF-8";
        String delimiter = "\\^";
        String deDelimiter = "\t";
        int initialFileCount = listOfFiles.length;
        int fixedFiles = 0;
        boolean isMssql = true;
        if (dB_NAME.equalsIgnoreCase("mssql")) {
            encoding = "UTF-16LE";
            delimiter = "\\|\\*\\*\\|";
        } else if (dB_NAME.equalsIgnoreCase("postgres")) {
            isMssql = false;
        } else {
            ioHandler.print(logger, "\nUnable to fix processed_err folder for Database " + dB_NAME + " Collect few sample files and contact support\n");
            return;
        }
        for (File tempFile : listOfFiles) {
            try (FileInputStream inputStream = new FileInputStream(tempFile.getAbsolutePath());
                 InputStreamReader in = new InputStreamReader((InputStream)inputStream, encoding);
                 BufferedReader reader = new BufferedReader(in);){
                String line;
                int inputFileLineCount = 0;
                int outputFileLineCount = 0;
                ioHandler.print(logger, "\nProcessing file :" + tempFile.getName());
                StringBuilder oldtext = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    ++inputFileLineCount;
                    oldtext.append(line).append("\r\n");
                }
                if (inputFileLineCount == 0) {
                    ioHandler.print(logger, "\nUnable to read temp file : " + tempFile + ", Collect few sample and contact support");
                    continue;
                }
                String replacedtext = oldtext.toString().replaceAll(delimiter, deDelimiter);
                if (isMssql) {
                    replacedtext = replacedtext.replaceAll("\u0a0d\u0d00", "");
                    replacedtext = replacedtext.replaceAll("\u0a0d", "");
                }
                String newFilename = tempFile.getName();
                newFilename = newFilename.replaceAll("AUDLogonInfo", "AdapADLogonAuditLog");
                newFilename = newFilename.replaceAll("AUDFileAuditInfo", "AdapFileAuditInfo");
                File newFile = new File(processedFolderPath + File.separator + newFilename);
                FileWriter writer = new FileWriter(newFile);
                writer.write(replacedtext);
                writer.close();
                BufferedReader outputReader = new BufferedReader(new FileReader(newFile));
                while (outputReader.readLine() != null) {
                    ++outputFileLineCount;
                }
                outputReader.close();
                if (outputFileLineCount == inputFileLineCount) {
                    ++fixedFiles;
                    continue;
                }
                ioHandler.print(logger, "\nMismatch in input and output line count, Collect few sample and contact support\n");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        ioHandler.print(logger, "\n\nInitial no of files in processed_err :" + initialFileCount);
        ioHandler.print(logger, "\nTotal no of files fixed :" + fixedFiles + "\n\n");
        if (initialFileCount == fixedFiles) {
            ioHandler.print(logger, "\nRename processed_err folder and start product, check whether data is inserted");
            ioHandler.print(logger, "\nIf inserted Successfully you can delete the folder which was renamed\n\n\n");
        } else {
            ioHandler.print(logger, "\nMismatch in fixed files count");
            ioHandler.print(logger, "\nDon't delete the processed_err folder");
            ioHandler.print(logger, "\nDon't delete the processed_err folder\n\n\n");
        }
    }

    static {
        try {
            String logFileName = "SupportTroubleshooting";
            LoggerUtil.initLog((String)logFileName, (long)0L, (boolean)false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static class CheckTableHealth
    implements Callable<Boolean> {
        String table;
        Logger logger;
        int totalCount;
        int processed;
        StringBuilder sb;

        CheckTableHealth(String table, Logger logger, int totalCount, int processed, StringBuilder sb) {
            this.table = table;
            this.logger = logger;
            this.totalCount = totalCount;
            this.processed = processed;
            this.sb = sb;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                String ret = SupportTroubleshooting.getRowCount(this.table);
                String msg = "Processing " + this.table;
                if (this.processed == this.totalCount) {
                    msg = "Completed !!";
                }
                ioHandler.printProgress(msg, this.totalCount, this.processed);
                if (!ret.equals("OK")) {
                    this.sb.append(String.format("%40s : %s\n", this.table, ret));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        }
    }
}

