/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.mickey.db;

import com.zoho.mickey.db.DefaultConnectExceptionHandler;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

public class BackoutConnectExceptionHandler
extends DefaultConnectExceptionHandler {
    protected LocalDateTime lastLogTime;
    protected int failCount;
    protected long maxWaitSeconds = TimeUnit.MINUTES.toSeconds(1L);
    protected long[] series = this.generateSeries();

    protected long[] generateSeries() {
        long start = 1L;
        long next = 2L;
        long max = this.maxWaitSeconds;
        double factor = this.factor();
        LinkedList<Long> fibsList = new LinkedList<Long>();
        while ((double)next * factor < (double)max) {
            fibsList.add(Math.round((double)next * factor));
            long newLast = start + next;
            start = next;
            next = newLast;
        }
        int n = fibsList.size();
        long[] fibs = new long[n];
        for (int i = 0; i < n; ++i) {
            fibs[i] = (Long)fibsList.get(i);
        }
        return fibs;
    }

    protected double factor() {
        return 1.0;
    }

    @Override
    protected synchronized void operationForNoManagedConnection() {
        boolean needToDump;
        LocalDateTime currentTime = LocalDateTime.now();
        if (this.lastLogTime == null) {
            this.failCount = 0;
            needToDump = true;
        } else {
            long remainSec = Duration.between(this.lastLogTime, currentTime).getSeconds();
            if (remainSec >= this.maxWaitSeconds) {
                this.failCount = 0;
                needToDump = true;
            } else if (this.failCount == this.series.length) {
                this.failCount = 0;
                needToDump = true;
            } else {
                long upperBound = this.series[this.failCount - 1];
                boolean bl = needToDump = remainSec >= upperBound;
            }
        }
        if (needToDump) {
            this.dumpInfo();
            this.lastLogTime = currentTime;
            ++this.failCount;
        } else {
            LOGGER.info("Skipping information dump");
        }
    }
}

