/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.mickey.db;

import com.adventnet.db.adapter.DBAdapter;
import com.adventnet.db.api.RelationalAPI;
import com.zoho.mickey.db.TableLogger;
import com.zoho.mickey.db.mssql.MssqlRunningQueries;
import com.zoho.mickey.db.mysql.MysqlRunningQueries;
import com.zoho.mickey.db.postgres.PostgresRunningQueries;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public abstract class RunningQueries {
    private static final Logger LOGGER = Logger.getLogger(RunningQueries.class.getName());

    public static synchronized void dumpInformation() {
        String className = RunningQueries.getClassName();
        if (className != null && !className.isEmpty()) {
            try {
                RunningQueries runningQueries = (RunningQueries)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
                runningQueries.dumpQueryInformation();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            LOGGER.severe("Unknown DB Specified");
        }
    }

    private static String getClassName() {
        DBAdapter dbAdapter = RelationalAPI.getInstance().getDBAdapter();
        String className = dbAdapter.getDBProps().getProperty("RunningQueries");
        if (className == null) {
            switch (dbAdapter.getDBType()) {
                case "mssql": {
                    className = MssqlRunningQueries.class.getName();
                    break;
                }
                case "postgres": {
                    className = PostgresRunningQueries.class.getName();
                    break;
                }
                case "mysql": {
                    className = MysqlRunningQueries.class.getName();
                }
            }
        }
        return className;
    }

    protected void dumpInformation(JSONObject jsonObject) {
        LOGGER.fine(() -> ((JSONObject)jsonObject).toString());
        String lineSeparator = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        for (Object key : jsonObject.keySet()) {
            JSONObject table = jsonObject.getJSONObject((String)key);
            if (table.length() <= 0) continue;
            String tableHeader = key.toString().replaceAll("_", " ");
            sb.append(lineSeparator);
            sb.append(new TableLogger(tableHeader, table).getTableContent());
            sb.append(lineSeparator);
        }
        sb.append(lineSeparator).append(lineSeparator);
        LOGGER.info(sb.toString());
    }

    /*
     * Exception decompiling
     */
    protected JSONObject getAsJson(String query, Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Connection getConnection() throws SQLException {
        Properties dbProps = RelationalAPI.getInstance().getDBAdapter().getDBProps();
        return DriverManager.getConnection(dbProps.getProperty("url"), dbProps.getProperty("username"), dbProps.getProperty("password"));
    }

    public abstract void dumpQueryInformation() throws SQLException;
}

