/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.mickey.db;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class TableLogger {
    private final int tablePadding = 2;
    private final char seperatorChar = (char)45;
    private final char seperatorTab = (char)124;
    private final char space = (char)32;
    private final int headerSpacing = 20;
    private String[] headers;
    private String[][] content;
    private String name;
    private int[] maxLength;

    public TableLogger(String name, JSONObject table) {
        Objects.requireNonNull(name, "Headers cannot be null");
        Objects.requireNonNull(table, "table cannot be null");
        this.name = name;
        JSONArray columns = table.getJSONArray("columns");
        int noOfColumns = columns.length();
        this.headers = new String[noOfColumns];
        for (int i = 0; i < noOfColumns; ++i) {
            this.headers[i] = columns.get(i).toString();
        }
        JSONArray data = table.getJSONArray("data");
        int noOfRows = data.length();
        this.content = new String[noOfRows][noOfColumns];
        for (int i = 0; i < noOfRows; ++i) {
            JSONArray row = data.getJSONArray(i);
            for (int j = 0; j < noOfColumns; ++j) {
                this.content[i][j] = row.isNull(j) ? "" : row.getString(j).replaceAll("\\r\\n|\\r|\\n", " ");
            }
        }
        this.postProcess();
    }

    public TableLogger(String name, String[] headers, String[][] content) {
        Objects.requireNonNull(name, "Name cannot be null");
        Objects.requireNonNull(headers, "Headers cannot be null");
        Objects.requireNonNull(content, "Content cannot be null");
        this.name = name;
        this.headers = headers;
        this.content = content;
        this.postProcess();
    }

    private void postProcess() {
        int i;
        this.maxLength = new int[this.headers.length];
        for (i = 0; i < this.headers.length; ++i) {
            this.maxLength[i] = this.headers[i].length();
        }
        for (i = 0; i < this.content.length; ++i) {
            String[] temp = this.content[i];
            for (int j = 0; j < temp.length; ++j) {
                if (temp[j].length() <= this.maxLength[j]) continue;
                this.maxLength[j] = temp[j].length();
            }
        }
    }

    public String getTableContent() {
        int i;
        String newLine = System.lineSeparator();
        int totalPadding = 4;
        String padder = StringUtils.repeat((char)' ', (int)2);
        int columnMaxSize = this.maxLength.length * (totalPadding + 1) + this.sum(this.maxLength) - 1;
        StringBuilder sb = new StringBuilder((4 + columnMaxSize) * (this.content.length * 2 + 2 + 3));
        sb.append('|');
        sb.append(StringUtils.repeat((char)'-', (int)columnMaxSize));
        sb.append('|');
        sb.append(newLine);
        String headerRowSeperator = sb.toString();
        sb.setLength(0);
        for (int i2 = 0; i2 < this.maxLength.length; ++i2) {
            sb.append('|');
            sb.append(StringUtils.repeat((char)'-', (int)(this.maxLength[i2] + totalPadding)));
        }
        sb.append('|');
        String rowSeperator = sb.toString();
        sb.setLength(0);
        sb.append(headerRowSeperator);
        sb.append('|');
        sb.append(StringUtils.repeat((char)' ', (int)20));
        sb.append(this.name);
        sb.append(StringUtils.repeat((char)' ', (int)(columnMaxSize - this.name.length() - 20)));
        sb.append('|');
        sb.append(newLine);
        sb.append(rowSeperator);
        sb.append(newLine);
        sb.append('|');
        for (i = 0; i < this.headers.length; ++i) {
            sb.append(padder);
            sb.append(this.headers[i]);
            sb.append(StringUtils.repeat((char)' ', (int)(this.maxLength[i] - this.headers[i].length())));
            sb.append(padder);
            sb.append('|');
        }
        sb.append(newLine);
        sb.append(rowSeperator);
        sb.append(newLine);
        for (i = 0; i < this.content.length; ++i) {
            String[] tempRow = this.content[i];
            sb.append('|');
            for (int j = 0; j < tempRow.length; ++j) {
                sb.append(padder);
                sb.append(tempRow[j]);
                sb.append(StringUtils.repeat((char)' ', (int)(this.maxLength[j] - tempRow[j].length())));
                sb.append(padder);
                sb.append('|');
            }
            sb.append(newLine);
            sb.append(rowSeperator);
            sb.append(newLine);
        }
        return sb.toString();
    }

    private int sum(int[] maxLength2) {
        int sum = 0;
        for (int i : maxLength2) {
            sum += i;
        }
        return sum;
    }
}

