/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.mickey.tools.postgres;

import com.adventnet.db.adapter.postgres.PostgresConfUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.QueryConstructionException;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.mfw.Starter;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.PersistenceUtil;
import com.adventnet.persistence.StandAlone;
import com.adventnet.persistence.internal.AppResources;
import com.zoho.framework.utils.FileUtils;
import com.zoho.mickey.api.TransactionUtil;
import com.zoho.mickey.ha.HAHelper;
import com.zoho.mickey.tools.postgres.PgAlgorithm;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ModifyPostgresAlgorithm
implements StandAlone {
    private static final Logger LOGGER = Logger.getLogger(ModifyPostgresAlgorithm.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStandAlone(String ... args) {
        try {
            if (args == null || args.length == 0) {
                throw new IllegalArgumentException("Arguments not supplied");
            }
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("Arguments not supplied properly");
            }
            HashMap<String, String> credentials = new HashMap<String, String>(2);
            for (int i = 0; i < args.length; i += 2) {
                credentials.put(args[i], args[i + 1]);
            }
            String superUser = (String)credentials.get("-sU");
            String superUserPassword = (String)credentials.get("-sp");
            String algorithm = (String)credentials.get("-a");
            if (StringUtils.isEmpty((CharSequence)superUser) || StringUtils.isEmpty((CharSequence)superUserPassword)) {
                throw new IllegalArgumentException("Super User credential should be supplied");
            }
            credentials.remove("-sU");
            credentials.remove("-sp");
            credentials.remove("-a");
            Starter.loadSystemProperties();
            PersistenceInitializer.initializeRelationalAPI((String)(AppResources.SERVER_HOME + File.separator + "conf"));
            Properties properties = RelationalAPI.getInstance().getDBAdapter().getDBProps();
            String url = properties.getProperty("url");
            try {
                this.startDB(url, "postgresUser");
                try (Connection connection = DriverManager.getConnection(url, "postgres", superUserPassword);){
                    for (String userName : credentials.keySet()) {
                        ModifyPostgresAlgorithm.validatePassword(url, connection, userName, (String)credentials.get(userName));
                    }
                }
                for (String userName : credentials.keySet()) {
                    ModifyPostgresAlgorithm.modifyAlgorithmForUser(superUser, superUserPassword, userName, (String)credentials.get(userName), algorithm);
                }
            }
            finally {
                this.stopDB(url, "postgresUser");
            }
            System.exit(0);
        }
        catch (Throwable e) {
            ConsoleOut.println((String)e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void validateDetails(String superUser, String superUserPassword, String algorithm) throws Exception {
        if (RelationalAPI.getInstance() == null) {
            Starter.loadSystemProperties();
            PersistenceInitializer.initializeRelationalAPI((String)(System.getProperty("server.home") + File.separator + "conf"));
        }
        if (!RelationalAPI.getInstance().getDBAdapter().getDBType().equalsIgnoreCase("postgres")) {
            throw new UnsupportedOperationException("ModifyPostgresAlgorithm is applicable only for PostgreSQL databases");
        }
        if (!RelationalAPI.getInstance().getDBAdapter().isBundledDB()) {
            throw new UnsupportedOperationException("ModifyPostgresAlgorithm is supported for bundled DB only");
        }
        if (!(StringUtils.isEmpty((CharSequence)algorithm) || algorithm.equals("md5") || algorithm.equals("scram-sha-256"))) {
            throw new IllegalArgumentException("Invalid algorithm specified");
        }
    }

    private static boolean isVersionValid(String superUser, String superUserPassword, String algorithm) throws SQLException {
        Properties properties = RelationalAPI.getInstance().getDBAdapter().getDBProps();
        String url = properties.getProperty("url");
        try (Connection connection = DriverManager.getConnection(url, superUser, superUserPassword);){
            DatabaseMetaData dbm = connection.getMetaData();
            Float version = new Float(dbm.getDatabaseMajorVersion() + "." + dbm.getDatabaseMinorVersion());
            if (version.floatValue() < 10.0f && Objects.equals(algorithm, "scram-sha-256")) {
                LOGGER.log(Level.INFO, "Modifying algorithm to SCRAM is not supported as postgres version is less than 10");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public static void modifyAlgorithmForSystemUsers(String superUser, String superUserPassword, String algorithm) throws Throwable {
        TransactionUtil.transactional(() -> {
            String algorithmToUpgrade = algorithm;
            HashMap<String, String> credentials = new HashMap<String, String>();
            ModifyPostgresAlgorithm.validateDetails(superUser, superUserPassword, algorithmToUpgrade);
            if (StringUtils.isEmpty((CharSequence)algorithmToUpgrade)) {
                algorithmToUpgrade = "md5";
            }
            if (!ModifyPostgresAlgorithm.isVersionValid(superUser, superUserPassword, algorithmToUpgrade)) {
                return;
            }
            Objects.requireNonNull(credentials, "user credentials are not supplied");
            Properties properties = RelationalAPI.getInstance().getDBAdapter().getDBProps();
            String databaseURL = properties.getProperty("url");
            try (Connection connection = DriverManager.getConnection(databaseURL, "postgres", superUserPassword);){
                credentials.put(superUser, superUserPassword);
                String defaultUser = properties.getProperty("username");
                String password = PersistenceUtil.getDBPasswordProvider((String)"postgres").getPassword((Object)properties.getProperty("password"));
                credentials.put(defaultUser, password);
                String replUserinDBHA = properties.getProperty("repl.username");
                if (HAHelper.isDataBaseHAEnabled() && StringUtils.isNotEmpty((CharSequence)replUserinDBHA)) {
                    credentials.put(replUserinDBHA, PersistenceUtil.getDBPasswordProvider((String)"postgres").getPassword((Object)properties.getProperty("repl.password")));
                }
                for (String userName : credentials.keySet()) {
                    ModifyPostgresAlgorithm.validatePassword(databaseURL, connection, userName, (String)credentials.get(userName));
                }
                for (String userName : credentials.keySet()) {
                    ModifyPostgresAlgorithm.modifyPassword(databaseURL, connection, superUser, superUserPassword, userName, (String)credentials.get(userName), algorithmToUpgrade);
                }
            }
        }, (int)2, (int)600);
    }

    public static void modifyAlgorithmForUser(String superUser, String superUserPassword, String userName, String password, String algorithm) throws Throwable {
        TransactionUtil.withNewTransaction(() -> {
            String algorithmToUpgrade = algorithm;
            ModifyPostgresAlgorithm.validateDetails(superUser, superUserPassword, algorithmToUpgrade);
            if (StringUtils.isEmpty((CharSequence)algorithmToUpgrade)) {
                algorithmToUpgrade = "md5";
            }
            if (!ModifyPostgresAlgorithm.isVersionValid(superUser, superUserPassword, algorithmToUpgrade)) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)userName) || StringUtils.isEmpty((CharSequence)password)) {
                throw new IllegalArgumentException("credentials cannot be null/empty");
            }
            Properties properties = RelationalAPI.getInstance().getDBAdapter().getDBProps();
            String databaseURL = properties.getProperty("url");
            try (Connection connection = DriverManager.getConnection(databaseURL, "postgres", superUserPassword);){
                ModifyPostgresAlgorithm.validatePassword(databaseURL, connection, userName, password);
                ModifyPostgresAlgorithm.modifyPassword(databaseURL, connection, superUser, superUserPassword, userName, password, algorithmToUpgrade);
            }
        });
    }

    private static void validatePassword(String databaseURL, Connection connection, String userName, String password) throws Exception {
        String isUserExists = "SELECT rolname, rolpassword FROM pg_authid where rolname::text = ?::text";
        try (DataSet ds = RelationalAPI.getInstance().executeQuery(connection, isUserExists, new Object[]{userName});){
            if (!ds.next()) {
                throw new Exception("User :: " + userName + " :: does not exist");
            }
        }
        ModifyPostgresAlgorithm.checkConnection(databaseURL, userName, password);
    }

    private static void modifyPassword(String url, Connection connection, String superUser, String superUserPassword, String userName, String password, String algorithm) throws Exception {
        String algoCheck = "SELECT rolpassword ~ '" + (algorithm.equals("md5") ? "^md5" : "^SCRAM-SHA-256\\$") + "' AS has_upgraded FROM pg_authid where rolname::text = ?::text";
        try (DataSet ds = RelationalAPI.getInstance().executeQuery(connection, algoCheck, new Object[]{userName});){
            if (ds.next() && ds.getAsBoolean(1).booleanValue()) {
                LOGGER.log(Level.INFO, "password algorithm of user {0} is already in {1} hash", new Object[]{userName, algorithm});
                return;
            }
        }
        LOGGER.log(Level.INFO, "Modifying password algorithm of user :: {0}", userName);
        String queryTomodifyPassword = "ALTER ROLE \"" + userName + "\" PASSWORD '" + (algorithm.equals("scram-sha-256") ? PgAlgorithm.getScramPassword(password) : PgAlgorithm.getMD5Password(userName, password)) + "'";
        RelationalAPI.getInstance().execute(connection, queryTomodifyPassword);
        ModifyPostgresAlgorithm.updateAlgorithmInConfigurations(connection, algorithm);
        ModifyPostgresAlgorithm.checkConnection(url, userName, password);
        LOGGER.log(Level.INFO, "password algorithm modified for user :: {0}", userName);
    }

    private static boolean checkConnection(String url, String userName, String password) throws Exception {
        Throwable throwable = null;
        try (Connection conn = DriverManager.getConnection(url, userName, password);){
            Throwable throwable2;
            DataSet ds;
            block25: {
                boolean bl;
                block26: {
                    block27: {
                        ds = RelationalAPI.getInstance().executeQuery("SELECT 1", conn);
                        throwable2 = null;
                        if (!ds.next()) break block25;
                        bl = true;
                        if (ds == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    ds.close();
                }
                return bl;
            }
            try {
                try {
                    try {
                        throw new Exception("Password validation failed for user :: " + userName);
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (ds != null) {
                        if (throwable2 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            ds.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    private void stopDB(String url, String userName) throws Exception {
        RelationalAPI.getInstance().getDBAdapter().stopDB(url, userName, null);
    }

    private void startDB(String url, String userName) throws Exception {
        if (!RelationalAPI.getInstance().getDBAdapter().getDBInitializer().isServerStarted()) {
            RelationalAPI.getInstance().getDBAdapter().startDB(url, userName, null);
        }
    }

    private static void updateAlgorithmInConfigurations(Connection connection, String algorithm) throws SQLException, QueryConstructionException, IOException {
        if (algorithm.equals("scram-sha-256")) {
            String algoUpdated = "SELECT rolpassword ~ '^SCRAM-SHA-256\\$' AS has_upgraded FROM pg_authid WHERE rolcanlogin";
            boolean updated = true;
            try (DataSet ds = RelationalAPI.getInstance().executeQuery(algoUpdated, connection);){
                while (ds.next()) {
                    if (ds.getAsBoolean(1).booleanValue()) continue;
                    updated = false;
                    break;
                }
            }
            if (updated) {
                ModifyPostgresAlgorithm.updateAuthInPGConf(connection, algorithm);
                PostgresConfUtil.changeAuthMode((String)algorithm, (boolean)true);
                ModifyPostgresAlgorithm.updateAuthInDataBaseParams(algorithm);
            }
        } else {
            ModifyPostgresAlgorithm.updateAuthInPGConf(connection, algorithm);
            PostgresConfUtil.changeAuthMode((String)algorithm, (boolean)true);
            ModifyPostgresAlgorithm.updateAuthInDataBaseParams(algorithm);
        }
    }

    private static void updateAuthInPGConf(Connection connection, String algorithm) throws SQLException, QueryConstructionException, IOException {
        String defaultAlgoInDB = null;
        try (DataSet ds = RelationalAPI.getInstance().executeQuery("show password_encryption", connection);){
            if (ds.next()) {
                defaultAlgoInDB = ds.getAsString(1);
            }
        }
        if (Objects.equals(defaultAlgoInDB, algorithm)) {
            return;
        }
        Path extConf = Paths.get(System.getProperty("db.home"), "ext_conf");
        Path latestFile = null;
        try (Stream<Path> dirStream = Files.list(extConf);){
            List fileList = dirStream.sorted().collect(Collectors.toList());
            latestFile = (Path)fileList.get(fileList.size() - 1);
        }
        LOGGER.log(Level.INFO, "Going to update password_encryption param in ext_conf file :: {0} ::  with algorithm :: {1}", new Object[]{latestFile, algorithm});
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader br = new BufferedReader(new FileReader(latestFile.toFile()));){
            String str = br.readLine();
            while (str != null) {
                if (str.contains("password_encryption")) {
                    str = br.readLine();
                    continue;
                }
                buffer.append(str + "\n");
                str = br.readLine();
            }
        }
        buffer.append("password_encryption = " + algorithm + "\n");
        var7_11 = null;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(latestFile.toFile()));){
            bw.write(buffer.toString());
        }
        catch (Throwable throwable) {
            var7_11 = throwable;
            throw throwable;
        }
    }

    private static void updateAuthInDataBaseParams(String algorithm) throws IOException {
        String fileNameWithAbsolutePath = PersistenceInitializer.getDBParamsFilePath();
        Properties props = FileUtils.readPropertyFile((File)new File(fileNameWithAbsolutePath));
        String authMode = props.getProperty("db.default.authmode");
        if (authMode != null && !authMode.equals(algorithm)) {
            PersistenceUtil.removeKeyInDBConf((String)"db.default.authmode");
        } else {
            authMode = "md5";
        }
        if (!authMode.equals(algorithm)) {
            PersistenceUtil.addKeyInDBConf((String)"db.default.authmode", (String)algorithm);
            RelationalAPI.getInstance().getDBAdapter().getDBProps().setProperty("db.default.authmode", algorithm);
        }
    }

    public void postPopulation() {
    }

    public void prePopulation() {
    }

    public void startDB() {
    }

    public void loadModule(String moduleName) {
    }

    public void populateServerStatus() {
    }

    public void stopDB() {
    }

    public void startServer() {
    }
}

