/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.mickey.dt;

import com.adventnet.db.adapter.DBAdapter;
import com.adventnet.db.adapter.ResultSetAdapter;
import com.adventnet.db.adapter.SQLGenerator;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.DataTypeDefinition;
import com.adventnet.db.persistence.metadata.DataTypeManager;
import com.adventnet.db.persistence.metadata.MetaDataException;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.AlterTableQuery;
import com.adventnet.ds.query.AlterTableQueryImpl;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.QueryConstructionException;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.Row;
import com.zoho.mickey.api.DataTypeUtil;
import com.zoho.mickey.dt.DTKeyModifier;
import com.zoho.mickey.exception.KeyModificationException;
import com.zoho.mickey.tools.crypto.ECTagModifierUtil;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class DefaultDTKeyModifier
implements DTKeyModifier {
    static Logger out = Logger.getLogger(DefaultDTKeyModifier.class.getName());
    private static DBAdapter dbAdapter = null;
    private static DBAdapter newDBAdapter = null;
    private static SQLGenerator sqlGen = null;
    private static SQLGenerator newSqlGen = null;

    public void initialize(Properties properties) throws Exception {
        newDBAdapter = PersistenceInitializer.createDBAdapter((Properties)properties);
        newDBAdapter.initialize(properties);
        newSqlGen = newDBAdapter.getSQLGenerator();
        newSqlGen.setKey(properties.getProperty("ECTag"));
        dbAdapter = RelationalAPI.getInstance().getDBAdapter();
        sqlGen = dbAdapter.getSQLGenerator();
    }

    public boolean changeKey(String tableName, String columnName) throws KeyModificationException {
        try {
            ECTagModifierUtil.addStatusRow(tableName, columnName);
            this.addNullableTempColumn(tableName, columnName);
            this.addTempColumnInTableDefinition(tableName, columnName, columnName + "_tempcol");
            ECTagModifierUtil.updateStatus(tableName, columnName, 2);
            this.encryptDataInTempColumn(tableName, columnName);
            ECTagModifierUtil.updateStatus(tableName, columnName, 3);
            this.modifyTempColumn(tableName, columnName);
            ECTagModifierUtil.updateStatus(tableName, columnName, 4);
            DefaultDTKeyModifier.renameColumn(tableName, columnName, columnName + "_tempcol1");
            this.addTempColumnInTableDefinition(tableName, columnName, columnName + "_tempcol1");
            ECTagModifierUtil.updateStatus(tableName, columnName, 5);
            DefaultDTKeyModifier.renameColumn(tableName, columnName + "_tempcol", columnName);
            ECTagModifierUtil.updateStatus(tableName, columnName, 6);
            return true;
        }
        catch (Exception e) {
            throw new KeyModificationException("Exception occurred while reEncryptWithNewKey for the column " + columnName + " in the table " + tableName, (Throwable)e);
        }
    }

    private void addTempColumnInTableDefinition(String tableName, String actualColumnName, String tempColumnName) throws MetaDataException, CloneNotSupportedException {
        TableDefinition tabDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
        ColumnDefinition colDef = tabDef.getColumnDefinitionByName(actualColumnName);
        ColumnDefinition cloned_cd = (ColumnDefinition)colDef.clone();
        cloned_cd.setColumnName(tempColumnName);
        tabDef.addColumnDefinition(cloned_cd);
    }

    private void addNullableTempColumn(String tableName, String encryptedColName) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            out.info("going to add temp column for the column " + encryptedColName + " in the table " + tableName);
            TableDefinition tabDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
            con = RelationalAPI.getInstance().getConnection();
            stmt = con.createStatement();
            AlterTableQueryImpl atq = new AlterTableQueryImpl(tableName);
            ColumnDefinition colDef = tabDef.getColumnDefinitionByName(encryptedColName);
            ColumnDefinition cloned_cd = (ColumnDefinition)colDef.clone();
            if (!cloned_cd.isNullable()) {
                cloned_cd.setNullable(true);
            }
            cloned_cd.setColumnName(encryptedColName + "_tempcol");
            atq.addColumn(cloned_cd);
            String sql = sqlGen.getSQLForAlterTable((AlterTableQuery)atq);
            dbAdapter.executeAndcheck(stmt, sql);
            out.info(encryptedColName + "_tempcol has been added.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("Exception occured while adding temp column for the encrypted column " + encryptedColName + " in the table " + tableName, e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
    }

    private void encryptDataInTempColumn(String tableName, String encryptedColName) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            out.info("going to reencrypt data for the column " + encryptedColName + " in the table " + tableName);
            con = RelationalAPI.getInstance().getConnection();
            stmt = con.createStatement();
            TableDefinition tabDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
            ColumnDefinition colDef = tabDef.getColumnDefinitionByName(encryptedColName);
            Column newCol = new Column(tableName, encryptedColName + "_tempcol");
            newCol.setDefinition(colDef);
            Column oldCol = new Column(tableName, encryptedColName);
            oldCol.setDefinition(colDef);
            String sql = this.getSQLForReEncryptingData(tableName, oldCol, newCol);
            out.fine("sql:: " + sql);
            stmt.executeUpdate(sql);
            out.info("column re-encrypted with new key: " + encryptedColName + "_tempcol");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("Exception occured while recrypting the data in temp column for the encrypted column " + encryptedColName + " in the table " + tableName, e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
    }

    private String getSQLForReEncryptingData(String tableName, Column oldCol, Column newCol) throws QueryConstructionException {
        StringBuilder updateBuffer = new StringBuilder(100);
        updateBuffer.append("UPDATE ");
        updateBuffer.append(sqlGen.getDBSpecificTableName(tableName));
        updateBuffer.append(" SET ");
        updateBuffer.append(sqlGen.getDBSpecificColumnName(newCol.getColumnName()) + " = ");
        String decryptStr = this.getDBSpecificDecryptionString(oldCol, sqlGen.getDBSpecificColumnName(oldCol.getColumnName()), true);
        updateBuffer.append(this.getDBSpecificEncryptionString(newCol, decryptStr));
        return updateBuffer.toString();
    }

    private String getDBSpecificDecryptionString(Column column, String value, boolean useOldKey) {
        String dataType = column.getDataType();
        if (DataTypeUtil.isEDT((String)dataType)) {
            DataTypeDefinition dt = DataTypeManager.getDataTypeDefinition((String)dataType);
            dataType = dt.getBaseType();
        }
        if (useOldKey) {
            return sqlGen.getDecryptSQL(value, dataType);
        }
        return newSqlGen.getDecryptSQL(value, dataType);
    }

    private String getDBSpecificEncryptionString(Column column, String value) {
        return newSqlGen.getDBSpecificEncryptionString(column, value);
    }

    private void modifyTempColumn(String tableName, String encryptedColName) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            out.info("going to alter column " + encryptedColName + "_tempcol");
            con = RelationalAPI.getInstance().getConnection();
            stmt = con.createStatement();
            TableDefinition tabDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
            ColumnDefinition colDef = tabDef.getColumnDefinitionByName(encryptedColName);
            AlterTableQueryImpl atq = new AlterTableQueryImpl(tableName);
            ColumnDefinition cloned_cd = (ColumnDefinition)colDef.clone();
            cloned_cd.setColumnName(encryptedColName + "_tempcol");
            atq.modifyColumn(cloned_cd.getColumnName(), cloned_cd);
            String sql = sqlGen.getSQLForAlterTable((AlterTableQuery)atq);
            dbAdapter.executeAndcheck(stmt, sql);
            out.info(encryptedColName + "_tempcol has been altered.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("Exception occured while modifying temp column for the encrypted column " + encryptedColName + " in the table " + tableName, e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renameColumn(String tableName, String oldColumnName, String newColumnName) throws QueryConstructionException, SQLException, DataAccessException, MetaDataException, CloneNotSupportedException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = RelationalAPI.getInstance().getConnection();
            stmt = con.createStatement();
            out.info("going to rename column : " + oldColumnName + " to : " + newColumnName + " in the table " + tableName);
            AlterTableQueryImpl atq = new AlterTableQueryImpl(tableName);
            atq.renameColumn(oldColumnName, newColumnName);
            String sql = sqlGen.getSQLForAlterTable((AlterTableQuery)atq);
            out.fine("rename sql:: " + sql);
            dbAdapter.executeAndcheck(stmt, sql);
            out.info("renamed column : " + oldColumnName + " to : " + newColumnName + " in the table " + tableName);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
    }

    public boolean sanitize(String tableName, String encryptedColName, Map<String, String> diffMap) throws KeyModificationException {
        Connection con = null;
        Statement stmt = null;
        DataSet ds = null;
        try {
            con = RelationalAPI.getInstance().getConnection();
            stmt = con.createStatement();
            TableDefinition td = MetaDataUtil.getTableDefinitionByName((String)tableName);
            out.info("Going to run sanity for the table:: " + tableName);
            ds = this.getDataForSanityTest(tableName, encryptedColName, con, stmt);
            if (ds.next()) {
                StringBuilder strBuff = new StringBuilder(50);
                strBuff.append("{");
                for (String pkcol : td.getPrimaryKey().getColumnList()) {
                    strBuff.append(pkcol).append("=").append(ds.getValue(pkcol)).append(",");
                }
                strBuff.append("diff_column={").append(encryptedColName).append(",").append(encryptedColName + "_tempcol1").append("}");
                strBuff.append("}");
                diffMap.put(tableName, strBuff.toString());
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new KeyModificationException("Exception occured while running sanity for the column " + encryptedColName + " in the table " + tableName, (Throwable)e);
        }
        finally {
            try {
                if (ds != null) {
                    ds.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static boolean isEquals(Object srcVal, Object dstVal) throws IOException {
        if (srcVal instanceof InputStream && dstVal instanceof InputStream) {
            return IOUtils.contentEquals((InputStream)((InputStream)srcVal), (InputStream)((InputStream)dstVal));
        }
        return srcVal == null ? dstVal == null : srcVal.equals(dstVal);
    }

    private DataSet getDataForSanityTest(String tableName, String encryptedColName, Connection con, Statement stmt) throws SQLException {
        ColumnDefinition colDef = null;
        TableDefinition td = null;
        try {
            td = MetaDataUtil.getTableDefinitionByName((String)tableName);
            colDef = td.getColumnDefinitionByName(encryptedColName);
        }
        catch (MetaDataException e) {
            e.printStackTrace();
        }
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
        Column newColumn = new Column(tableName, encryptedColName);
        newColumn.setDefinition(colDef);
        Column oldColumn = new Column(tableName, encryptedColName + "_tempcol1");
        oldColumn.setDefinition(colDef);
        ResultSetAdapter rs = null;
        ArrayList<String> pkColNames = new ArrayList();
        DataSet ds = null;
        String sql = null;
        try {
            pkColNames = td.getPrimaryKey().getColumnList();
            sql = this.getSanitySQL(tableName, oldColumn, newColumn, pkColNames);
            ArrayList<Column> colList = new ArrayList<Column>();
            Column col = null;
            for (String pkcolName : pkColNames) {
                col = new Column(tableName, pkcolName);
                col.setDefinition(td.getColumnDefinitionByName(pkcolName));
                colList.add(col);
                sq.addSelectColumn(col);
            }
            colList.add(oldColumn);
            colList.add(newColumn);
            sq.addSelectColumn(oldColumn);
            sq.addSelectColumn(newColumn);
            rs = dbAdapter.executeQuery(stmt, sql);
            ds = new DataSet(rs, (Query)sq, colList, stmt);
        }
        catch (Exception e) {
            throw new SQLException("Exception while checking the sanity for the table: " + tableName, e);
        }
        return ds;
    }

    private String getSanitySQL(String tableName, Column oldColumn, Column newColumn, List<String> pkColList) throws QueryConstructionException {
        StringBuilder selectBuffer = new StringBuilder(150);
        selectBuffer.append("SELECT");
        for (int i = 0; i < pkColList.size(); ++i) {
            if (i == 0) {
                selectBuffer.append(" " + sqlGen.getDBSpecificColumnName(pkColList.get(i)));
                continue;
            }
            selectBuffer.append(" , " + sqlGen.getDBSpecificColumnName(pkColList.get(i)));
        }
        selectBuffer.append(" FROM ");
        selectBuffer.append(" " + sqlGen.getDBSpecificTableName(tableName) + " ");
        selectBuffer.append(" WHERE ");
        selectBuffer.append(this.getDBSpecificDecryptionString(oldColumn, sqlGen.getDBSpecificColumnName(oldColumn.getColumnName()), true) + " != " + this.getDBSpecificDecryptionString(newColumn, sqlGen.getDBSpecificColumnName(newColumn.getColumnName()), false));
        out.fine("sanity sql:: " + selectBuffer.toString());
        return selectBuffer.toString();
    }

    private void dropColumn(String tableName, String columnName) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = RelationalAPI.getInstance().getConnection();
            stmt = con.createStatement();
            out.info("going to remove column: " + columnName + " of the table: " + tableName);
            AlterTableQueryImpl atq = new AlterTableQueryImpl(tableName);
            atq.removeColumn(columnName);
            String sql = dbAdapter.getSQLGenerator().getSQLForAlterTable((AlterTableQuery)atq);
            out.fine("drop sql:: " + sql);
            dbAdapter.executeAndcheck(stmt, sql);
            out.info("removed column: " + columnName + " of the table: " + tableName);
        }
        catch (Exception e) {
            throw new SQLException("Exception occurred while dropping up the temp column " + columnName + " in the table " + tableName, e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
    }

    public boolean cleanUp(String tableName, String columnName, boolean isSuccess) throws KeyModificationException {
        try {
            if (isSuccess) {
                this.dropColumn(tableName, columnName + "_tempcol1");
                ECTagModifierUtil.updateStatus(tableName, columnName, 7);
            } else {
                Criteria cri = new Criteria(new Column("ECMStatus", "TABLENAME"), (Object)tableName, 0);
                DataObject dobj = DataAccess.get((String)"ECMStatus", (Criteria)(cri = cri.and(new Criteria(new Column("ECMStatus", "COLUMNNAME"), (Object)columnName, 0))));
                Row row = dobj.getFirstRow("ECMStatus");
                int status = (Integer)row.get("STATUS");
                if (status == 2 || status == 3 || status == 4) {
                    this.dropColumn(tableName, columnName + "_tempcol");
                } else if (status == 5) {
                    DefaultDTKeyModifier.renameColumn(tableName, columnName + "_tempcol1", columnName);
                    this.dropColumn(tableName, columnName + "_tempcol");
                } else if (status == 6) {
                    this.dropColumn(tableName, columnName);
                    DefaultDTKeyModifier.renameColumn(tableName, columnName + "_tempcol1", columnName);
                }
            }
            return true;
        }
        catch (Exception e) {
            throw new KeyModificationException("Exception occurred while cleaning up the temp column " + columnName + " in the table " + tableName, (Throwable)e);
        }
    }
}

