/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.mickey.tools;

import com.adventnet.db.adapter.DBAdapter;
import com.adventnet.db.adapter.mysql.MySqlDBInitializer;
import com.adventnet.db.adapter.postgres.DefaultPostgresDBInitializer;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.ds.query.Column;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.mfw.Starter;
import com.adventnet.persistence.PersistenceException;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.PersistenceUtil;
import com.adventnet.persistence.StandAlone;
import com.zoho.net.handshake.HandShakeUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ChangePassword
implements StandAlone {
    private static final Logger LOGGER = Logger.getLogger(ChangePassword.class.getName());

    public void startDB() throws Exception {
    }

    public void loadModule(String moduleName) throws Exception {
    }

    public void populateServerStatus() throws Exception {
    }

    public void stopDB() throws Exception {
    }

    public void startServer() throws Exception {
    }

    private static void updateCredentialAuditTable(DBAdapter dbAdapter, Connection conn, String oldPassword, String newPassword) throws SQLException {
        Column col = new Column("DBCredentialsAudit", "PASSWORD");
        ColumnDefinition colDef = new ColumnDefinition();
        colDef.setColumnName("PASSWORD");
        colDef.setDataType("SCHAR");
        col.setDefinition(colDef);
        if (dbAdapter.isTablePresentInDB(conn, null, "DBCredentialsAudit")) {
            try (Statement stmt = conn.createStatement();){
                String encryptColSQl = dbAdapter.getSQLGenerator().getDBSpecificEncryptionString(col, "'" + newPassword + "'");
                String updatesql = "UPDATE " + dbAdapter.getSQLGenerator().getDBSpecificTableName("DBCredentialsAudit") + " SET " + dbAdapter.getSQLGenerator().getDBSpecificColumnName("PASSWORD") + " = " + encryptColSQl + " , LAST_MODIFIED_TIME = '" + new Timestamp(System.currentTimeMillis()) + "' WHERE " + dbAdapter.getSQLGenerator().getDBSpecificColumnName("USERNAME") + " = 'postgres'";
                stmt.executeUpdate(updatesql);
                LOGGER.info("Updated the credential entry.");
            }
        }
    }

    public static boolean changePassword(DBAdapter dbAdapter, String userName, String oldPassword, String newPassword) throws Exception {
        if (newPassword == null || newPassword.trim().isEmpty()) {
            throw new IllegalArgumentException("Password cannot be null / empty. Please provide a valid password!!");
        }
        if (oldPassword.equals(newPassword)) {
            LOGGER.severe("Old and new password are same. Hence, it is ignored.");
            return false;
        }
        LOGGER.info("Going to change database password.");
        Properties defaultDbProps = dbAdapter.getDBProps();
        boolean isUpdated = false;
        String dbType = dbAdapter.getDBType();
        if (defaultDbProps.getProperty("username").equals(userName)) {
            String encryptedPassword = PersistenceUtil.getDBPasswordProvider((String)dbType).getEncryptedPassword(newPassword);
            isUpdated = PersistenceUtil.updatePasswordInDBConf((String)encryptedPassword);
        }
        if (!defaultDbProps.getProperty("username").equals(userName) || isUpdated && defaultDbProps.getProperty("username").equals(userName)) {
            Connection conn = null;
            try {
                if (dbType.equals("postgres")) {
                    Class.forName("org.postgresql.Driver");
                } else if (dbType.equals("mysql")) {
                    Class.forName("org.gjt.mm.mysql.Driver");
                }
                String url = dbAdapter.getDBProps().getProperty("url");
                Map urlProps = dbAdapter.splitConnectionURL(url);
                String database = (String)urlProps.get("DBName");
                if (PersistenceInitializer.getConfigurationValue((String)"DBName").equals("postgres")) {
                    url = url.replaceAll(database, "template1");
                } else if (PersistenceInitializer.getConfigurationValue((String)"DBName").equals("mysql")) {
                    url = url.replaceAll(database, "");
                }
                conn = DriverManager.getConnection(url, userName, oldPassword);
                dbAdapter.changePassword(userName, oldPassword, newPassword, conn);
                if (dbType.equals("postgres") && userName.equals("postgres")) {
                    boolean isDBExists = false;
                    try (Statement stmt = conn.createStatement();
                         ResultSet rs = stmt.executeQuery("SELECT datname FROM pg_catalog.pg_database WHERE lower(datname) = lower('" + database + "')");){
                        while (rs.next()) {
                            isDBExists = true;
                        }
                    }
                    LOGGER.info("isDBExists: " + isDBExists);
                    if (isDBExists) {
                        var13_15 = null;
                        try (Connection conn1 = DriverManager.getConnection(dbAdapter.getDBProps().getProperty("url"), userName, newPassword);){
                            ChangePassword.updateCredentialAuditTable(dbAdapter, conn1, oldPassword, newPassword);
                        }
                        catch (Throwable throwable) {
                            var13_15 = throwable;
                            throw throwable;
                        }
                    } else {
                        PersistenceUtil.addKeyInDBConf((String)"superuser_pass", (String)PersistenceUtil.getDBPasswordProvider((String)dbType).getEncryptedPassword(newPassword));
                        LOGGER.info("Updated key in database_params.conf");
                    }
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                if (defaultDbProps.getProperty("username").equals(userName)) {
                    PersistenceUtil.updatePasswordInDBConf((String)oldPassword);
                }
                throw new PersistenceException("Exception while updating the new password in database. " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private void validateInput(Properties p) {
        if (p.getProperty("-P") == null || p.getProperty("-P").isEmpty()) {
            throw new IllegalArgumentException("New Password not supplied");
        }
    }

    private void startDBServer(DBAdapter dbAdapter, Properties dbProps) throws Exception {
        Properties dbAdapterProps = dbAdapter.getDBProps();
        boolean isDBServerRunning = false;
        String userName = null;
        if (dbAdapter.getDBType().equals("postgres")) {
            isDBServerRunning = ((DefaultPostgresDBInitializer)dbAdapter.getDBInitializer()).checkServerStatus(dbAdapterProps.getProperty("Server"), ((Integer)dbAdapterProps.get("Port")).intValue(), dbAdapterProps.getProperty("username"));
            userName = "temp";
        } else if (dbAdapter.getDBType().equals("mysql")) {
            isDBServerRunning = ((MySqlDBInitializer)dbAdapter.getDBInitializer()).getMySQLAdminPingStatus(dbProps.getProperty("username"), ((Integer)dbAdapterProps.get("Port")).intValue(), dbProps.getProperty("password"));
            userName = dbProps.getProperty("username");
        }
        if (isDBServerRunning) {
            LOGGER.severe("Database is running. Please stop the database server and try to change the password again!!");
            throw new Exception("Database is running. Please stop the database server and try to change the password again!!");
        }
        LOGGER.info("DB server is not running. Hence going to start.");
        dbAdapter.startDB(dbProps.getProperty("url"), userName, dbProps.getProperty("password"));
    }

    private void stopDBServer(DBAdapter dbAdapter, Properties dbProps) throws Exception {
        String userName = dbProps.getProperty("username");
        if (dbAdapter.getDBType().equals("postgres")) {
            userName = "temp";
        }
        dbAdapter.stopDB(dbProps.getProperty("url"), userName, dbProps.getProperty("password"));
    }

    public void runStandAlone(String ... args) throws Exception {
        Properties dbProps = null;
        try {
            if (args == null || args.length == 0) {
                throw new IllegalArgumentException("Arguments has not been given to change the database password.");
            }
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("Arguments are not supplied properly");
            }
            Properties props = new Properties();
            for (int i = 0; i < args.length; i += 2) {
                props.setProperty(args[i], args[i + 1]);
            }
            String oldPassword = props.getProperty("-p");
            String newPassword = props.getProperty("-P");
            String userName = props.getProperty("-U");
            this.validateInput(props);
            Starter.loadSystemProperties();
            PersistenceInitializer.loadPersistenceConfigurations();
            oldPassword = PersistenceUtil.getDBPasswordProvider().getPassword((Object)oldPassword);
            newPassword = PersistenceUtil.getDBPasswordProvider().getPassword((Object)newPassword);
            oldPassword = oldPassword == null ? "" : oldPassword;
            dbProps = PersistenceInitializer.getDBProps((String)PersistenceInitializer.getDBParamsFilePath());
            String oldPasswordFromProps = dbProps.getProperty("password");
            oldPasswordFromProps = oldPasswordFromProps == null ? "" : oldPasswordFromProps;
            dbProps.setProperty("password", oldPasswordFromProps);
            String string = userName = userName == null ? dbProps.getProperty("username") : userName;
            if (userName.equals(dbProps.getProperty("username")) && !oldPassword.equals(oldPasswordFromProps)) {
                throw new IllegalArgumentException("Provided old password does not match with current database password.");
            }
            DBAdapter dbAdapter = null;
            try {
                if (HandShakeUtil.isServerListening()) {
                    LOGGER.severe("Database password cannot be changed when server is running. Please shutdown the server and retry!!");
                    throw new Exception("Database password cannot be changed when server is running. Please shutdown the server and retry!!");
                }
                dbProps.putAll((Map<?, ?>)PersistenceInitializer.getConfigurationProps((String)PersistenceInitializer.getConfigurationValue((String)"DBName")));
                dbAdapter = PersistenceInitializer.createDBAdapter((Properties)dbProps);
                dbAdapter.initialize(dbProps);
                this.startDBServer(dbAdapter, dbProps);
                ConsoleOut.println((String)"Going to change the database password.");
                if (ChangePassword.changePassword(dbAdapter, userName, oldPassword, newPassword)) {
                    dbProps.setProperty("password", newPassword);
                    ConsoleOut.println((String)"Password changed successfully.");
                } else {
                    ConsoleOut.println((String)"Password has not been changed.");
                }
                LOGGER.info("Going to stop database server!!");
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    throw e;
                }
                catch (Throwable throwable) {
                    LOGGER.info("Going to stop database server!!");
                    this.stopDBServer(dbAdapter, dbProps);
                    throw throwable;
                }
            }
            this.stopDBServer(dbAdapter, dbProps);
            System.exit(0);
        }
        catch (Exception e) {
            ConsoleOut.println((String)("Exception occurred while changing the password: " + e.getMessage()));
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void postPopulation() throws Exception {
    }

    public void prePopulation() throws Exception {
    }
}

