/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.mickey.tools.crypto;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.persistence.PersistenceInitializer;
import com.zoho.mickey.exception.KeyModificationException;
import com.zoho.mickey.tools.crypto.ECTagModifierUtil;
import com.zoho.mickey.tools.crypto.KeyModifier;
import com.zoho.net.handshake.HandShakeUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;

public class ECTagModifier
implements KeyModifier {
    static Logger out = Logger.getLogger(ECTagModifier.class.getName());

    public void changeKey(String newTag) throws KeyModificationException {
        try {
            if (newTag == null) {
                out.severe(" New ECTag should be given to start the migration!!");
                throw new KeyModificationException(" New ECTag should be given to start the migration!!");
            }
            ConsoleOut.println((String)"Going to re-encrypt the data with the new ECTAG");
            this.checkIfServerRunning();
            PersistenceInitializer.loadPersistenceConfigurations();
            if (PersistenceInitializer.getConfigurationValue((String)"ECTag").equals(newTag)) {
                throw new KeyModificationException("Existing  ectag and provided ectag are same. Please try with new key!!");
            }
            this.initializeMickey();
            ECTagModifierUtil.modifyECTag(newTag);
            ConsoleOut.println((String)"data reencryption with new ECTAG completed successfully.");
        }
        catch (Exception e) {
            throw new KeyModificationException((Throwable)e);
        }
    }

    private boolean isDataBasePopulated() throws SQLException {
        try (Connection con = RelationalAPI.getInstance().getConnection();){
            boolean bl = RelationalAPI.getInstance().getDBAdapter().isTablePresentInDB(con, null, "SeqGenState");
            return bl;
        }
    }

    private void initializeMickey() throws Exception {
        PersistenceInitializer.initializeDB((String)System.getProperty("server.conf"));
        if (!this.isDataBasePopulated()) {
            out.severe("DataBase is not a populated one. Hence 'ectag' value cannot be modified.");
            throw new RuntimeException("DataBase is not a populated one. Hence 'ectag' value cannot be modified.");
        }
        PersistenceInitializer.initializeMickey((boolean)false);
        out.info("Mickey is initialized");
    }

    private void checkIfServerRunning() throws Exception {
        if (HandShakeUtil.isServerListening()) {
            throw new Exception("Server is running. Kindly shutdown and start the key migration!!");
        }
    }
}

