/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.mickey.tools.crypto;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.DataTypeDefinition;
import com.adventnet.db.persistence.metadata.DataTypeManager;
import com.adventnet.db.persistence.metadata.MetaDataException;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.mfw.message.Messenger;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.RowIterator;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.persistence.internal.AppResources;
import com.zoho.conf.tree.ConfTree;
import com.zoho.conf.tree.ConfTreeBuilder;
import com.zoho.mickey.api.DataTypeUtil;
import com.zoho.mickey.dt.DTKeyModifier;
import com.zoho.mickey.dt.DefaultDTKeyModifier;
import com.zoho.mickey.exception.KeyModificationException;
import com.zoho.mickey.tools.crypto.DefaultECTagPrePostHandler;
import com.zoho.mickey.tools.crypto.ECTagModifierStatus;
import com.zoho.mickey.tools.crypto.ECTagPrePostHandler;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ECTagModifierUtil {
    static Logger out = Logger.getLogger(ECTagModifierUtil.class.getName());
    private static ECTagPrePostHandler handler = null;
    private static String dbType = null;
    private static Map<String, String> diffMap = new HashMap<String, String>();
    private static ConfTree configTree = null;
    static String confFilePath = AppResources.SERVER_HOME + File.separator + "conf" + File.separator + "key_modifier.conf";
    private static Map<String, DTKeyModifier> dtVsModifierClass = new HashMap<String, DTKeyModifier>();
    private static String newKey = null;
    private static ECTagModifierStatus statusObj = null;
    private static String topicName = "ECTagModifier";

    public static void modifyECTag(String newTag) throws KeyModificationException {
        try {
            newKey = newTag;
            dbType = PersistenceInitializer.getConfigurationValue((String)"DBName");
            if (!dbType.equalsIgnoreCase("postgres") && !dbType.equalsIgnoreCase("mysql")) {
                throw new KeyModificationException("ECTag migration has been supported only for Postgres and Mysql!!");
            }
            ECTagModifierUtil.initializeConfiguration();
            ECTagModifierUtil.initializePrePostHandler();
            if (ECTagModifierUtil.isHandlerExists()) {
                handler.preHandle();
                out.info("pre handler is called");
            }
            ECTagModifierUtil.startECTagMigration();
            if (ECTagModifierUtil.isHandlerExists()) {
                handler.postHandle(true);
                out.info("post handler is called");
            }
        }
        catch (Exception e) {
            throw new KeyModificationException("Exception while modifying the ECTag " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                PersistenceInitializer.stopDB();
                if (ECTagModifierUtil.isHandlerExists()) {
                    handler.postHandle(false);
                    out.info("post handler is called");
                }
            }
            catch (Exception e) {
                throw new KeyModificationException("Exception while stopping the database " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static boolean isHandlerExists() {
        return handler != null;
    }

    public static void initializeConfiguration() throws Exception {
        File keyModifierConf = new File(System.getProperty("key.modifier.config.file.path", confFilePath));
        if (!keyModifierConf.exists()) {
            out.info("key_modifier.conf file not found...");
        } else {
            configTree = ((ConfTreeBuilder)ConfTreeBuilder.confTree().fromConfFile(keyModifierConf.getCanonicalPath())).build();
            out.info("key_modifier.conf file is initialized");
            out.info("configurations:: " + configTree);
        }
        ECTagModifierUtil.initializeDTModifiers(configTree);
        ECTagModifierUtil.validateDTModifiers(dtVsModifierClass);
    }

    public static String getNewKey() {
        return newKey;
    }

    protected static void validateDTModifiers(Map<String, DTKeyModifier> dtVsModifierClass) throws Exception {
        if (ECTagModifierUtil.getDTKeyModifier("SCHAR") == null || ECTagModifierUtil.getDTKeyModifier("SBLOB") == null) {
            throw new Exception(" DTKeyModifier has not been implemented for basic database encryption datatype (ie) schar, sblob");
        }
    }

    protected static void initializeDTModifiers(ConfTree confTree) throws Exception {
        Properties dbProps = PersistenceInitializer.getConfigurationProps((String)dbType);
        dbProps.setProperty("ECTag", newKey);
        if (confTree == null) {
            DTKeyModifier keyModifier = (DTKeyModifier)Class.forName(DefaultDTKeyModifier.class.getName()).newInstance();
            keyModifier.initialize(dbProps);
            dtVsModifierClass.put("schar", keyModifier);
            dtVsModifierClass.put("sblob", keyModifier);
        } else {
            List<String> dataTypes = Arrays.asList(confTree.get("migrate.dt").split(","));
            String className = null;
            for (String dataType : dataTypes) {
                dataType = dataType.trim();
                className = confTree.get(dbType + "." + dataType + ".dtkeymodifier");
                if (className == null) {
                    className = confTree.get(dataType + ".dtkeymodifier");
                }
                DTKeyModifier modifier = (DTKeyModifier)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
                modifier.initialize(dbProps);
                dtVsModifierClass.put(dataType, modifier);
            }
        }
        out.info("dtVsModifierClass :: " + dtVsModifierClass);
    }

    public static String getConfigurationValue(String configName) {
        return configTree != null ? configTree.get(configName) : null;
    }

    private static void initializePrePostHandler() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String className = ECTagModifierUtil.getConfigurationValue("key.modifier.prepost.handler");
        if (className == null) {
            className = DefaultECTagPrePostHandler.class.getName();
        }
        if (className != null) {
            out.info("key.modifier.prepost.handler ::: " + className);
            handler = (ECTagPrePostHandler)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
    }

    public static DTKeyModifier getDTKeyModifier(String dataType) {
        if (DataTypeUtil.isEDT((String)dataType)) {
            DataTypeDefinition dt = DataTypeManager.getDataTypeDefinition((String)dataType);
            dataType = dt.getBaseType();
        }
        return dtVsModifierClass.get(dataType.toLowerCase(Locale.ENGLISH));
    }

    private static void startECTagMigration() throws Exception {
        TableDefinition auditTable = ECTagModifierUtil.getAuditTableDefinition();
        if (MetaDataUtil.getTableDefinitionByName((String)auditTable.getTableName()) != null) {
            DataAccess.dropTable((String)auditTable.getTableName());
            out.info("Audit table dropped");
        }
        DataAccess.createTable((String)"Persistence", (TableDefinition)auditTable);
        out.info("Audit table created");
        List tableNames = MetaDataUtil.getTableNamesInDefinedOrder();
        statusObj = new ECTagModifierStatus();
        statusObj.initialize(tableNames);
        statusObj.setCurrentStatus(8);
        Messenger.publish((String)topicName, (Object)statusObj);
        try {
            DTKeyModifier modifier = null;
            ArrayList colNames = null;
            ColumnDefinition colDef = null;
            String dataType = null;
            TableDefinition tabDef = null;
            int processedTableCount = 0;
            for (String tableName : tableNames) {
                statusObj.setProcessingTableName(tableName);
                tabDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
                colNames = new ArrayList(tabDef.getColumnNames());
                for (String colName : colNames) {
                    colDef = tabDef.getColumnDefinitionByName(colName);
                    dataType = colDef.getDataType();
                    if (!colDef.isEncryptedColumn() || (modifier = ECTagModifierUtil.getDTKeyModifier(dataType)) == null) continue;
                    statusObj.setProcessingColumnName(colName);
                    statusObj.setCurrentStatus(1);
                    Messenger.publish((String)topicName, (Object)statusObj);
                    modifier.changeKey(tableName, colName);
                    if (ECTagModifierUtil.getConfigurationValue("run.sanity") != null && ECTagModifierUtil.getConfigurationValue("run.sanity").equals("true")) {
                        modifier.sanitize(tableName, colName, diffMap);
                    }
                    statusObj.setCurrentStatus(7);
                    Messenger.publish((String)topicName, (Object)statusObj);
                }
                statusObj.setCompletedTableCount(++processedTableCount);
                Messenger.publish((String)topicName, (Object)statusObj);
            }
            if (!diffMap.isEmpty()) {
                out.severe("Diff identified:: " + diffMap);
                throw new Exception("There is difference in the encrypted data!!. Please check logs for diff map!!");
            }
            ECTagModifierUtil.dropTempColumn();
            statusObj.setCurrentStatus(9);
            Messenger.publish((String)topicName, (Object)statusObj);
        }
        catch (Exception e) {
            out.severe("Error while reencrypting with new ectag:: " + e.getMessage());
            e.printStackTrace();
            try {
                ECTagModifierUtil.revertData();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            throw e;
        }
    }

    private static void dropTempColumn() throws SQLException {
        try {
            DataObject dobj = DataAccess.get((String)"ECMStatus", (Criteria)new Criteria(new Column("ECMStatus", "STATUS"), (Object)6, 0));
            if (!dobj.isEmpty()) {
                RowIterator itr = (RowIterator)dobj.getRows("ECMStatus");
                Row row = null;
                String tableName = null;
                String columnName = null;
                TableDefinition td = null;
                ColumnDefinition cd = null;
                DTKeyModifier modifier = null;
                while (itr.hasNext()) {
                    row = (Row)itr.next();
                    tableName = (String)row.get("TABLENAME");
                    columnName = (String)row.get("COLUMNNAME");
                    td = MetaDataUtil.getTableDefinitionByName((String)tableName);
                    cd = td.getColumnDefinitionByName(columnName);
                    modifier = ECTagModifierUtil.getDTKeyModifier(cd.getDataType());
                    modifier.cleanUp(tableName, columnName, true);
                }
            }
        }
        catch (Exception e) {
            throw new SQLException("Exception while dropping the temp column ", e);
        }
    }

    private static void revertData() throws Exception {
        try {
            DataObject dobj = DataAccess.get((String)"ECMStatus", (Criteria)null);
            if (!dobj.isEmpty()) {
                RowIterator itr = (RowIterator)dobj.getRows("ECMStatus");
                Row row = null;
                String tableName = null;
                String columnName = null;
                TableDefinition td = null;
                ColumnDefinition cd = null;
                DTKeyModifier modifier = null;
                while (itr.hasNext()) {
                    row = (Row)itr.next();
                    tableName = (String)row.get("TABLENAME");
                    columnName = (String)row.get("COLUMNNAME");
                    td = MetaDataUtil.getTableDefinitionByName((String)tableName);
                    cd = td.getColumnDefinitionByName(columnName);
                    modifier = ECTagModifierUtil.getDTKeyModifier(cd.getDataType());
                    modifier.cleanUp(tableName, columnName, false);
                }
            }
        }
        catch (Exception e) {
            throw new SQLException("Exception while dropping the temp column ", e);
        }
    }

    public static void addStatusRow(String tableName, String columnName) throws DataAccessException {
        WritableDataObject dob = new WritableDataObject();
        Row row = new Row("ECMStatus");
        row.set("TABLENAME", (Object)tableName);
        row.set("COLUMNNAME", (Object)columnName);
        row.set("STATUS", (Object)1);
        dob.addRow(row);
        DataAccess.add((DataObject)dob);
        out.info("stating migration for the table:: " + tableName + " col name:: " + columnName);
    }

    public static void updateStatus(String tableName, String columnName, int status) throws DataAccessException {
        UpdateQueryImpl uq = new UpdateQueryImpl("ECMStatus");
        uq.setUpdateColumn("STATUS", (Object)status);
        Criteria cri = new Criteria(new Column("ECMStatus", "TABLENAME"), (Object)tableName, 0);
        cri = cri.and(new Criteria(new Column("ECMStatus", "COLUMNNAME"), (Object)columnName, 0));
        uq.setCriteria(cri);
        DataAccess.update((UpdateQuery)uq);
        out.info("status " + status + " update for the table " + tableName + " of the column : " + columnName);
    }

    private static TableDefinition getAuditTableDefinition() throws MetaDataException {
        TableDefinition td = new TableDefinition();
        PrimaryKeyDefinition pk = new PrimaryKeyDefinition();
        td.setTableName("ECMStatus");
        ColumnDefinition colDef = new ColumnDefinition();
        colDef.setColumnName("TABLENAME");
        colDef.setDataType("CHAR");
        colDef.setMaxLength(255);
        td.addColumnDefinition(colDef);
        ColumnDefinition colDef1 = new ColumnDefinition();
        colDef1.setColumnName("COLUMNNAME");
        colDef1.setDataType("CHAR");
        colDef1.setMaxLength(255);
        td.addColumnDefinition(colDef1);
        pk.setTableName(td.getTableName());
        pk.setName(td.getTableName() + "_PK");
        pk.addColumnName(colDef.getColumnName());
        pk.addColumnName(colDef1.getColumnName());
        td.setPrimaryKey(pk);
        ColumnDefinition c1 = new ColumnDefinition();
        c1.setColumnName("STATUS");
        c1.setDataType("INTEGER");
        c1.setDefaultValue((Object)1);
        td.addColumnDefinition(c1);
        td.setModuleName("Persitence");
        return td;
    }
}

