/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.mickey.tools.postgres;

import com.adventnet.db.adapter.DBAdapter;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.mfw.Starter;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.PersistenceUtil;
import com.adventnet.persistence.StandAlone;
import com.adventnet.persistence.internal.AppResources;
import com.zoho.mickey.tools.CreateDBUser;
import com.zoho.mickey.tools.postgres.PgAlgorithm;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class CreatePostgresDBUser
implements StandAlone,
CreateDBUser {
    private static final Logger LOGGER = Logger.getLogger(CreatePostgresDBUser.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStandAlone(String ... stringArray) {
        try {
            if (stringArray == null || stringArray.length == 0) {
                throw new IllegalArgumentException("Arguments not supplied");
            }
            if (stringArray.length % 2 != 0) {
                throw new IllegalArgumentException("Arguments not supplied properly");
            }
            Properties properties = new Properties();
            for (int i = 0; i < stringArray.length; i += 2) {
                properties.setProperty(stringArray[i], stringArray[i + 1]);
            }
            String string = properties.getProperty("-U");
            String string2 = properties.getProperty("-p");
            String string3 = properties.getProperty("-sU");
            String string4 = properties.getProperty("-sp");
            String string5 = properties.getProperty("-r");
            String string6 = properties.getProperty("-a");
            this.validateUserInput(properties);
            Starter.loadSystemProperties();
            PersistenceInitializer.initializeRelationalAPI((String)(AppResources.SERVER_HOME + File.separator + "conf"));
            if (!RelationalAPI.getInstance().getDBAdapter().getDBType().equalsIgnoreCase("postgres")) {
                throw new UnsupportedOperationException("CreatePostgresDBUser is applicable only for PostgreSQL databases");
            }
            Properties properties2 = RelationalAPI.getInstance().getDBAdapter().getDBProps();
            String string7 = properties2.getProperty("url");
            try {
                this.startDB(string7, string);
                Properties properties3 = new Properties();
                if (string6 != null && !string6.isEmpty()) {
                    properties3.put("algorithm", string6);
                }
                this.createUser(RelationalAPI.getInstance().getDBAdapter(), string7, string3, string4, string, string2, string5, properties3);
                if (string5.equalsIgnoreCase("default") && !RelationalAPI.getInstance().getDBAdapter().getDBProps().containsKey("superuser_pass") && PersistenceUtil.addKeyInDBConf((String)"superuser_pass", (String)PersistenceUtil.getDBPasswordProvider((String)"postgres").getEncryptedPassword(string4))) {
                    LOGGER.log(Level.INFO, "Audit requisites has been logged successfully");
                }
            }
            finally {
                this.stopDB(string7, string);
            }
            System.exit(0);
        }
        catch (Throwable throwable) {
            ConsoleOut.println((String)throwable.getMessage());
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    private void validateUserInput(Properties properties) {
        if (properties.getProperty("-sU") == null || properties.getProperty("-sU").isEmpty()) {
            throw new IllegalArgumentException("Super User name not supplied");
        }
        if (properties.getProperty("-sp") == null || properties.getProperty("-sp").isEmpty()) {
            throw new IllegalArgumentException("Super User password not supplied");
        }
        if (properties.getProperty("-U") == null || properties.getProperty("-U").isEmpty()) {
            throw new IllegalArgumentException("User name not supplied");
        }
        if (properties.getProperty("-p") == null || properties.getProperty("-p").isEmpty()) {
            throw new IllegalArgumentException("Password not supplied");
        }
        if (properties.getProperty("-r") == null || properties.getProperty("-r").isEmpty()) {
            throw new IllegalArgumentException("Role not supplied");
        }
        if (properties.getProperty("-U").equalsIgnoreCase(properties.getProperty("-r"))) {
            throw new IllegalArgumentException("User name should not be same as role name");
        }
        if (properties.getProperty("-U").contains("--") || properties.getProperty("-U").contains(";") || properties.getProperty("-U").contains("\\")) {
            throw new IllegalArgumentException("User name cannot have characters ::( -- , ; , \\)");
        }
        if (!(properties.getProperty("-r").equalsIgnoreCase("default") || properties.getProperty("-r").equalsIgnoreCase("readonly") || properties.getProperty("-r").equalsIgnoreCase("replication"))) {
            throw new IllegalArgumentException("Invalid rolename specified");
        }
        if (!(StringUtils.isEmpty((CharSequence)properties.getProperty("-a")) || properties.getProperty("-a").equals("md5") || properties.getProperty("-a").equals("scram-sha-256"))) {
            throw new IllegalArgumentException("Invalid algorithm specified");
        }
    }

    private void stopDB(String string, String string2) throws Exception {
        RelationalAPI.getInstance().getDBAdapter().stopDB(string, string2, null);
    }

    private void startDB(String string, String string2) throws Exception {
        if (RelationalAPI.getInstance().getDBAdapter().getDBInitializer().isServerStarted()) {
            throw new IllegalStateException("DB Server seems to be running. Please stop the DB Server and retry.");
        }
        RelationalAPI.getInstance().getDBAdapter().startDB(string, string2, null);
    }

    @Override
    public void createUser(DBAdapter dBAdapter, String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        this.createUser(dBAdapter, string, string2, string3, string4, string5, string6, null);
    }

    @Override
    public void createUser(DBAdapter dBAdapter, String string, String string2, String string3, String string4, String string5, String string6, Properties properties) throws Exception {
        Map map = dBAdapter.splitConnectionURL(string);
        String string7 = (String)map.get("DBName");
        if (string6.equalsIgnoreCase("default")) {
            string = string.replaceAll(string7, "template1");
        }
        Class.forName("org.postgresql.Driver");
        String string8 = null;
        try (Connection connection = DriverManager.getConnection(string, string2, string3);){
            block47: {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                Float f = new Float(databaseMetaData.getDatabaseMajorVersion() + "." + databaseMetaData.getDatabaseMinorVersion());
                if (properties == null || StringUtils.isEmpty((CharSequence)((String)properties.get("algorithm")))) {
                    string8 = this.getDefaultDBAlgo(connection, f);
                } else {
                    string8 = (String)properties.get("algorithm");
                    if (string8.equals("md5") && this.getDefaultDBAlgo(connection, f).equals("scram-sha-256")) {
                        throw new Exception("Default algorithm of database is SCRAM-SHA-256 but trying to create user with MD5");
                    }
                }
                if (!string8.equals("md5") && !string8.equals("scram-sha-256")) {
                    throw new IllegalArgumentException("Algorithm is not supported :: " + string8);
                }
                if (f.floatValue() < 10.0f) {
                    if (!string8.equals("md5")) {
                        LOGGER.log(Level.INFO, "Postgres versions less than 10 does not support :: {0} :: algorithm, hence revrting back to {1}", new Object[]{string8, "md5"});
                    }
                    string8 = "md5";
                }
                String string9 = PersistenceUtil.getDBPasswordProvider().getPassword((Object)string5);
                string9 = string8.equals("md5") ? PgAlgorithm.getMD5Password(string4, string9) : PgAlgorithm.getScramPassword(string9);
                LOGGER.log(Level.INFO, "Going to create PostgreSQL User :: {0}", string4);
                try (Statement statement = connection.createStatement();){
                    LOGGER.log(Level.INFO, "Version :: " + f);
                    String string10 = "pg_start_backup";
                    String string11 = "pg_stop_backup(boolean, boolean)";
                    if (f.floatValue() >= 15.0f) {
                        string10 = "pg_backup_start";
                        string11 = "pg_backup_stop";
                    }
                    LOGGER.log(Level.INFO, "backupStopFunction  :: " + string11);
                    LOGGER.log(Level.INFO, "backupStartFunction :: " + string10);
                    if (string6.equalsIgnoreCase("default")) {
                        Float f2 = new Float("10");
                        if (f.floatValue() >= f2.floatValue()) {
                            String string12 = "CREATE USER \"" + string4 + "\" WITH CREATEDB NOCREATEROLE LOGIN REPLICATION ENCRYPTED PASSWORD '" + string9 + "';";
                            statement.execute(string12);
                            statement.execute("GRANT pg_monitor TO \"" + string4 + "\"");
                            statement.execute("GRANT EXECUTE ON FUNCTION " + string10 + " TO \"" + string4 + "\"");
                            statement.execute("GRANT EXECUTE ON FUNCTION " + string11 + " TO \"" + string4 + "\"");
                            statement.execute("GRANT EXECUTE ON FUNCTION pg_switch_wal() TO \"" + string4 + "\"");
                            if (dBAdapter.isTablePresentInDB(connection, null, "DBCredentialsAudit")) {
                                statement.execute("GRANT ALL PRIVILEGES ON DBCredentialsAudit TO \"" + string4 + "\"");
                            }
                            Float f3 = new Float("12");
                            if (f.floatValue() >= f3.floatValue()) {
                                statement.execute("GRANT EXECUTE ON FUNCTION pg_promote TO \"" + string4 + "\"");
                            }
                            if (f.floatValue() < 15.0f) {
                                statement.execute("GRANT EXECUTE ON FUNCTION pg_stop_backup() TO \"" + string4 + "\"");
                            }
                            statement.execute("GRANT ALL ON SCHEMA public TO \"" + string4 + "\"");
                            if (dBAdapter.getDBProps().getProperty("extension.schema") != null) {
                                Float f4 = new Float("14");
                                if (f.floatValue() >= f4.floatValue()) {
                                    statement.execute("GRANT ALL ON SCHEMA \"" + dBAdapter.getDBProps().getProperty("extension.schema") + "\" TO \"" + string4 + "\"");
                                }
                            }
                        } else {
                            String string13 = "CREATE USER \"" + string4 + "\" WITH SUPERUSER CREATEDB NOCREATEROLE LOGIN REPLICATION ENCRYPTED PASSWORD '" + string9 + "';";
                            statement.execute(string13);
                            statement.execute("GRANT ALL ON SCHEMA public TO \"" + string4 + "\"");
                        }
                        break block47;
                    }
                    if (string6.equalsIgnoreCase("replication")) {
                        f = new Float(databaseMetaData.getDatabaseMajorVersion() + "." + databaseMetaData.getDatabaseMinorVersion());
                        Float f5 = new Float("10");
                        if (f.floatValue() >= f5.floatValue()) {
                            String string14 = "CREATE USER \"" + string4 + "\" WITH NOCREATEDB NOCREATEROLE LOGIN REPLICATION ENCRYPTED PASSWORD '" + string9 + "';";
                            statement.execute(string14);
                            statement.execute("GRANT pg_monitor TO \"" + string4 + "\"");
                            statement.execute("GRANT EXECUTE ON FUNCTION " + string10 + " TO \"" + string4 + "\"");
                            statement.execute("GRANT EXECUTE ON FUNCTION " + string11 + " TO \"" + string4 + "\"");
                            statement.execute("GRANT ALL ON SCHEMA public TO \"" + string4 + "\"");
                            if (f.floatValue() < 15.0f) {
                                statement.execute("GRANT EXECUTE ON FUNCTION pg_stop_backup() TO \"" + string4 + "\"");
                            }
                            break block47;
                        }
                        throw new UnsupportedOperationException("Replication Role not supported for versions below 10.0");
                    }
                    if (string6.equalsIgnoreCase("readonly")) {
                        String string15 = dBAdapter.getDBProps().getProperty("username");
                        if (string15 == null || string15.isEmpty()) {
                            throw new IllegalArgumentException("Default User Name cannot be null or empty");
                        }
                        String string16 = "CREATE USER \"" + string4 + "\" WITH ENCRYPTED PASSWORD '" + string9 + "';";
                        statement.execute(string16);
                        statement.execute("REVOKE ALL ON SCHEMA public FROM \"" + string4 + "\", public");
                        statement.execute("GRANT CONNECT ON DATABASE \"" + string7 + "\" TO \"" + string4 + "\", public");
                        statement.execute("GRANT USAGE ON SCHEMA public TO \"" + string4 + "\", public");
                        statement.execute("GRANT SELECT ON ALL TABLES IN SCHEMA public TO \"" + string4 + "\", public");
                        statement.execute("ALTER DEFAULT PRIVILEGES FOR ROLE \"" + string15 + "\" IN SCHEMA public GRANT SELECT ON TABLES TO \"" + string4 + "\", public");
                        break block47;
                    }
                    throw new IllegalArgumentException("Invalid rolename specified");
                }
            }
            LOGGER.log(Level.INFO, "PostgreSQL User {0} created successfully", string4);
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, "PostgreSQL User {0} creation failed", string4);
            throw exception;
        }
    }

    private String getDefaultDBAlgo(Connection connection, Float f) throws Exception {
        if (f.floatValue() < 10.0f) {
            return "md5";
        }
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("show password_encryption");){
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                return string;
            }
        }
        throw new Exception("Unable to get default algorithm of database");
    }

    public void postPopulation() {
    }

    public void prePopulation() {
    }

    public void startDB() {
    }

    public void loadModule(String string) {
    }

    public void populateServerStatus() {
    }

    public void stopDB() {
    }

    public void startServer() {
    }
}

