/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.mickey.tools.postgres;

import com.zoho.framework.utils.FileUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import org.postgresql.shaded.com.ongres.scram.common.ScramFunctions;
import org.postgresql.shaded.com.ongres.scram.common.ScramMechanism;
import org.postgresql.shaded.com.ongres.scram.common.ScramMechanisms;
import org.postgresql.shaded.com.ongres.scram.common.stringprep.StringPreparation;
import org.postgresql.shaded.com.ongres.scram.common.stringprep.StringPreparations;

public final class PgAlgorithm {
    public static final String MD5 = "md5";
    public static final String SCRAM = "scram-sha-256";

    public static String getScramPassword(String plainPassword) {
        ThreadLocal<SecureRandom> RANDOM = ThreadLocal.withInitial(SecureRandom::new);
        int iterations = 4096;
        byte[] bytes = new byte[16];
        RANDOM.get().nextBytes(bytes);
        byte[] saltBytes = bytes;
        byte[] saltedPassword = ScramFunctions.saltedPassword((ScramMechanism)ScramMechanisms.SCRAM_SHA_256, (StringPreparation)StringPreparations.NO_PREPARATION, (String)plainPassword, (byte[])saltBytes, (int)iterations);
        byte[] client_key = ScramFunctions.clientKey((ScramMechanism)ScramMechanisms.SCRAM_SHA_256, (byte[])saltedPassword);
        byte[] storedKey = ScramFunctions.storedKey((ScramMechanism)ScramMechanisms.SCRAM_SHA_256, (byte[])client_key);
        byte[] server_key = ScramFunctions.serverKey((ScramMechanism)ScramMechanisms.SCRAM_SHA_256, (byte[])saltedPassword);
        String hashedPassword = "SCRAM-SHA-256$" + iterations + ":" + Base64.getEncoder().encodeToString(saltBytes) + "$" + Base64.getEncoder().encodeToString(storedKey) + ":" + Base64.getEncoder().encodeToString(server_key);
        return hashedPassword;
    }

    public static String getMD5Password(String userName, String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(password.getBytes("UTF-8"));
        md.update(userName.getBytes("UTF-8"));
        String md5 = MD5 + FileUtils.bytesToHex((byte[])md.digest()).toLowerCase();
        return md5;
    }
}

