/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.mickey.tools.postgres;

import com.adventnet.db.adapter.DBAdapter;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.mfw.Starter;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.StandAlone;
import com.adventnet.persistence.internal.AppResources;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;

public class SetupPostgresDB
implements StandAlone {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStandAlone(String ... args) {
        try {
            if (args == null || args.length == 0) {
                throw new IllegalArgumentException("Arguments not supplied");
            }
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("Arguments not supplied properly");
            }
            Properties p = new Properties();
            for (int i = 0; i < args.length; i += 2) {
                p.setProperty(args[i], args[i + 1]);
            }
            String userName = "temp";
            String superUser = p.getProperty("-sU");
            String superUserPassword = p.getProperty("-sp");
            this.validateUserInput(p);
            Starter.loadSystemProperties();
            PersistenceInitializer.initializeRelationalAPI((String)(AppResources.SERVER_HOME + File.separator + "conf"));
            if (!RelationalAPI.getInstance().getDBAdapter().getDBType().equalsIgnoreCase("postgres")) {
                throw new UnsupportedOperationException("SetupPostgresDB is applicable only for PostgreSQL databases");
            }
            Properties properties = RelationalAPI.getInstance().getDBAdapter().getDBProps();
            String url = properties.getProperty("url");
            try {
                this.startDB(url, userName);
                Properties dbProperties = RelationalAPI.getInstance().getDBAdapter().getDBProps();
                dbProperties.setProperty("username", superUser);
                dbProperties.setProperty("password", superUserPassword);
                RelationalAPI.getInstance().getDBAdapter().initialize(dbProperties);
                this.createExtensions(RelationalAPI.getInstance().getDBAdapter(), url, superUser, superUserPassword);
            }
            finally {
                this.stopDB(url, userName);
            }
            System.exit(0);
        }
        catch (Throwable e) {
            ConsoleOut.println((String)e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void validateUserInput(Properties p) {
        if (p.getProperty("-sU") == null || p.getProperty("-sU").isEmpty()) {
            throw new IllegalArgumentException("Super User name not supplied");
        }
        if (p.getProperty("-sp") == null || p.getProperty("-sU").isEmpty()) {
            throw new IllegalArgumentException("Super User password not supplied");
        }
    }

    private void stopDB(String url, String userName) throws Exception {
        RelationalAPI.getInstance().getDBAdapter().stopDB(url, userName, null);
    }

    private void startDB(String url, String userName) throws Exception {
        if (RelationalAPI.getInstance().getDBAdapter().getDBInitializer().isServerStarted()) {
            throw new IllegalStateException("Database server is already running. Try after stopping the database");
        }
        RelationalAPI.getInstance().getDBAdapter().startDB(url, userName, null);
    }

    public void createExtensions(DBAdapter dbAdapter, String url, String superUser, String superUserPassword) throws Exception {
        url = url.replaceAll(dbAdapter.getDBProps().getProperty("DBName"), "template1");
        Class.forName("org.postgresql.Driver");
        try (Connection connection = DriverManager.getConnection(url, superUser, superUserPassword);){
            dbAdapter.prepareDatabase(connection);
        }
    }

    public void startDB() {
    }

    public void loadModule(String moduleName) {
    }

    public void populateServerStatus() {
    }

    public void stopDB() {
    }

    public void startServer() {
    }

    public void postPopulation() {
    }

    public void prePopulation() {
    }
}

