/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.sym.adsm.common.server.commandline.CmdUtil;
import com.adventnet.sym.adsm.common.server.commandline.EHCacheRecordNumber;
import com.adventnet.sym.adsm.common.server.commandline.IOHandler;
import com.adventnet.sym.adsm.common.server.commandline.util.SupportTroubleshooting;
import com.adventnet.sym.adsm.common.server.hacksaw.PathTraversal;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ArchiveDataProcessor {
    private static Logger logger = Logger.getLogger("Troubleshooting");
    protected static String TABLE_BACKUP_META_TABLE = "AUDBackupMetaTable";
    private static IOHandler ioHandler = CmdUtil.ioHandler();
    private static int blockId = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteDuplicateDEArchiveData(String[] cmdStr) {
        try {
            if (!ArchiveDataProcessor.isValidCmd(cmdStr, true).booleanValue()) {
                ioHandler.print("\n\nThe Command is incorrect!!\nRefer Sample Command: admin delete-duplicate-archive-data bt 2022-01-21 2024-02-24\n");
                return;
            }
            String[] deRepo = new String[]{"AdapSysMonAuditLog", "AdapDNSAuditLog", "AdapADReplicationAuditLog", "AdapPowershellAuditLog"};
            int[] srcIndex = new int[]{7, 6, 4, 5};
            int[] recNoIndex = new int[]{3, 28, 3, 13};
            int[] timeIndex = new int[]{2, 3, 2, 18};
            Long startTime = SupportTroubleshooting.convertDateToTimeStamp(cmdStr[3]);
            Long endTime = SupportTroubleshooting.convertDateToTimeStamp(cmdStr[4]);
            String userInput = null;
            Boolean isDEDown = ArchiveDataProcessor.isDEServiceStopped();
            userInput = isDEDown == false ? ioHandler.readLine("'ManageEngine ADAudit Plus - DataEngine XNode' Service Should be in stopped before this process. Can we stop the 'ManageEngine ADAudit Plus - DataEngine XNode' Service? [y/n] \n") : ioHandler.readLine("'ManageEngine ADAudit Plus - DataEngine XNode' Service is Stopped already. Kindly Confirm not to start DE service untill the process is Completed? [y/n] \n");
            if (!userInput.equalsIgnoreCase("y") && !userInput.equalsIgnoreCase("yes")) {
                ioHandler.print("\n\n'ManageEngine ADAudit Plus - DataEngine XNode' Service Should be in stopped State until this operation is completed! Exiting!!!\n");
                return;
            }
            if (!isDEDown.booleanValue()) {
                ioHandler.print("\n\nGoing to stop 'ManageEngine ADAudit Plus - DataEngine XNode' Service!!!\n");
                if (!ArchiveDataProcessor.stopService("ManageEngine ADAudit Plus - DataEngine XNode").booleanValue()) {
                    ioHandler.print("\n\nFailed to Stop 'ManageEngine ADAudit Plus - DataEngine XNode' Service. Exiting!!!\n");
                    return;
                }
                ioHandler.print("\n\n'ManageEngine ADAudit Plus - DataEngine XNode' Service Stopped Successfully!!!\n");
            }
            ioHandler.print("\nGoing to delete Duplicate Data for \"AdapSysMonAuditLog\", \"AdapDNSAuditLog\", \"AdapADReplicationAuditLog\", \"AdapPowershellAuditLog\" repositories...\n");
            userInput = ioHandler.readLine("Going to delete Duplicate Data between " + cmdStr[3] + " and " + cmdStr[4] + ". Do you want to continue (y/n)? ");
            ioHandler.print("\n");
            userInput = userInput.trim();
            if (!userInput.equalsIgnoreCase("y") && !userInput.equalsIgnoreCase("yes")) {
                ioHandler.print("\n\nDuplicate Data Delete Command Execution Stopped!!!\n");
                return;
            }
            ioHandler.print("\n\nProceeding with Duplicate Data Deletion. It may take time, Do not close the console!!!\n");
            if (!endTime.equals(0L) && !startTime.equals(0L)) {
                ArchiveDataProcessor.deleteDuplicateDEArchiveData(deRepo, srcIndex, recNoIndex, timeIndex, startTime, endTime);
                ioHandler.print("Duplicate Data Deletion Completed Successfully!!!\n");
                ioHandler.print("\n\nThe Old Archive files with duplicate data are moved to 'oldFiles' Folder in each Current Archive directory of Each DE Repo Folder. Try to load and unload new archive files and then Delete these folders!!!\n");
                return;
            }
            ioHandler.print("\n\nThe Data format is incorrect!!\nRefer Sample Command: admin delete-duplicate-archive-data bt 2022-01-21 2024-02-24\n");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteDuplicateDEArchiveData(String[] deRepo, int[] srcIndex, int[] recNoIndex, int[] timeIndex, Long startTime, Long endTime) {
        try {
            for (int i = 0; i < deRepo.length; ++i) {
                String dePath = CommonUtil.getProductHome() + File.separator + "apps" + File.separator + "dataengine-xnode" + File.separator + "db" + File.separator + "store";
                String metaFilePath = Paths.get(dePath + File.separator + deRepo[i] + "_archive.meta", new String[0]).normalize().toString();
                logger.info("Meta File Path: " + metaFilePath);
                blockId = 0;
                ArrayList<String> fileList = ArchiveDataProcessor.getArchiveFileForTimePeriod(metaFilePath, startTime, endTime, deRepo[i]);
                logger.info("fileList: " + fileList);
                ioHandler.print("Going to process " + deRepo[i] + " repository. Number of Archive files in " + deRepo[i] + " repository for given time is " + fileList.size() + ".\n");
                if (!fileList.isEmpty()) {
                    ArchiveDataProcessor.removeDuplicatedata(fileList, deRepo[i], srcIndex[i], recNoIndex[i], timeIndex[i]);
                    ArchiveDataProcessor.moveMetaFile(deRepo[i], true);
                }
                ioHandler.print("Duplicate Data Deleted for " + deRepo[i] + " repository. \n");
            }
            new File(CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + "duplicateDeletion").renameTo(new File(CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + "duplicateDeletion_" + System.currentTimeMillis()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getArchiveFileForTimePeriod(String metaFile, Long startTime, Long endTime, String deRepo) {
        ArrayList<String> filesList = new ArrayList<String>();
        ArrayList<String[]> archiveFiles = new ArrayList<String[]>();
        BufferedReader br = null;
        try {
            int k;
            String st;
            File file = new File(metaFile);
            br = new BufferedReader(new FileReader(file));
            String deArchiveLocation = ArchiveDataProcessor.getCurrentDEArchiveDir() + "audit-log" + File.separator + deRepo + File.separator + "frozen" + File.separator;
            logger.info("deArchiveLocation: " + deArchiveLocation);
            if (!PathTraversal.pathTraversalChecker((String)deArchiveLocation)) {
                logger.info("Invalid Path while taking files list :: deArchiveLocation: " + deArchiveLocation);
                ArrayList<String> arrayList = filesList;
                return arrayList;
            }
            String dirName = CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + "duplicateDeletion";
            File dir = new File(dirName);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            ArchiveDataProcessor.copyFile(metaFile, Paths.get(dirName, new String[0]).normalize().toString() + File.separator + deRepo + "_archive_old.meta");
            ArrayList<String> metaRows = new ArrayList<String>();
            while ((st = br.readLine()) != null) {
                String[] metaRow = st.split("\t");
                if (metaRow.length <= 1 || !StringUtils.isNumeric((CharSequence)metaRow[4])) {
                    logger.info("Not numeric:: " + st);
                    continue;
                }
                Long createTime = Long.parseLong(metaRow[1].substring(deRepo.length() + 1, metaRow[1].length())) / 1000L;
                if ((metaRow[5].equalsIgnoreCase("FROZEN") || metaRow[5].equalsIgnoreCase("DEFROST")) && createTime >= startTime && createTime <= endTime && (metaRow[2].equals("10") || metaRow[2].equals("11"))) {
                    archiveFiles.add(metaRow);
                    continue;
                }
                metaRows.add(Integer.valueOf(++blockId).toString() + st.substring(st.indexOf("\t")));
            }
            ArchiveDataProcessor.addMetaDataEntry(metaRows.toArray(new String[metaRows.size()]), deRepo, true);
            String[][] metaList = new String[archiveFiles.size()][];
            for (k = 0; k < archiveFiles.size(); ++k) {
                metaList[k] = (String[])archiveFiles.get(k);
            }
            Arrays.sort(metaList, new Comparator<String[]>(){

                @Override
                public int compare(String[] entry1, String[] entry2) {
                    String time1 = entry1[7];
                    String time2 = entry2[7];
                    return time1.compareTo(time2);
                }
            });
            for (k = 0; k < archiveFiles.size(); ++k) {
                String[] t = metaList[k];
                String temp = "";
                for (int j = 0; j < t.length; ++j) {
                    temp = temp + "\t" + t[j];
                }
                logger.info("Meta rows " + temp);
                filesList.add(t[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return filesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDuplicatedata(ArrayList<String> fileList, String deRepoName, int srcIndex, int recNoIndex, int timeIndex) {
        FileOutputStream zipOutStream = null;
        OutputStreamWriter zipWriter = null;
        CSVWriter csvWriter = null;
        try {
            String newarchiveFileName = deRepoName + "_" + System.currentTimeMillis();
            String dirName = CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + "duplicateDeletion";
            String deArchiveLocation = ArchiveDataProcessor.getCurrentDEArchiveDir() + "audit-log" + File.separator + deRepoName + File.separator + "frozen" + File.separator;
            if (!PathTraversal.pathTraversalChecker((String)deArchiveLocation)) {
                logger.info("Invalid Path while Removing Duplicate Archive Data : deArchiveLocation : " + deArchiveLocation);
                return;
            }
            String moveDir = deArchiveLocation + "oldFiles";
            File dir = new File(dirName);
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (!(dir = new File(dirName = dirName + File.separator + deRepoName)).exists()) {
                dir.mkdir();
            }
            if (!(dir = new File(moveDir)).exists()) {
                dir.mkdirs();
            }
            String newArchiveFile = dirName + File.separator + newarchiveFileName + "_S2.gz";
            char splitter = '\t';
            Long startTime = Long.MAX_VALUE;
            Long endTime = Long.MIN_VALUE;
            Long totalFileLines = 0L;
            Integer i = 1;
            zipOutStream = new FileOutputStream(newArchiveFile, true);
            zipWriter = new OutputStreamWriter((OutputStream)new GZIPOutputStream(zipOutStream), "UTF-8");
            csvWriter = new CSVWriter((Writer)zipWriter, splitter, '\"', '\\');
            logger.info("TotalHeap :: " + Runtime.getRuntime().maxMemory() / 0x100000L + " Heap size : " + Runtime.getRuntime().totalMemory() / 0x100000L);
            EHCacheRecordNumber.initCache();
            ArrayList<String> deArchiveDirs = ArchiveDataProcessor.getDEArchivePaths(deArchiveLocation.substring(0, deArchiveLocation.length() - 1));
            for (String archiveDir : deArchiveDirs) {
                File[] listOfArchiveFiles;
                String archiveRepoPath = archiveDir + File.separator + "audit-log" + File.separator + deRepoName + File.separator + "frozen" + File.separator;
                File archiveDirFile = new File(archiveRepoPath);
                logger.info("Going to check archive files in : " + archiveDir);
                if (!archiveDirFile.exists()) continue;
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().endsWith(".gz");
                    }
                };
                for (File arcFile : listOfArchiveFiles = archiveDirFile.listFiles(filter)) {
                    String key;
                    String string = key = arcFile.getName().toLowerCase().contains("_s2.gz") ? arcFile.getName().substring(0, arcFile.getName().toLowerCase().indexOf("_s2.gz")) : arcFile.getName().substring(0, arcFile.getName().indexOf(".gz"));
                    if (!fileList.contains(key)) continue;
                    String archiveFile = arcFile.getAbsolutePath();
                    long totalLines = 0L;
                    long validLines = 0L;
                    Long time = System.currentTimeMillis();
                    FileInputStream fileInStream = null;
                    InputStreamReader streamReader = null;
                    CSVReader csvReader = null;
                    boolean moveOldFile = false;
                    try {
                        String[] line;
                        logger.info("Going to read Archive File : " + archiveFile);
                        logger.info("TotalHeap :: " + Runtime.getRuntime().maxMemory() / 0x100000L + " Heap size : " + Runtime.getRuntime().totalMemory() / 0x100000L);
                        fileInStream = new FileInputStream(archiveFile);
                        streamReader = new InputStreamReader((InputStream)new GZIPInputStream(fileInStream), "UTF-8");
                        csvReader = new CSVReader((Reader)new BufferedReader(streamReader), splitter);
                        Long time1 = System.nanoTime();
                        while ((line = csvReader.readNext()) != null) {
                            Number number;
                            ++totalLines;
                            String recNumKey = line[srcIndex] + "_" + line[recNoIndex] + "_" + line[timeIndex];
                            if (EHCacheRecordNumber.containsKey(recNumKey).booleanValue()) continue;
                            if (totalFileLines >= 3000000L) {
                                logger.info("Reached 30 lk data. So writing in new file");
                                Integer n = i;
                                number = i = Integer.valueOf(i + 1);
                                ArchiveDataProcessor.setDataWriter(zipOutStream, zipWriter, csvWriter);
                                File newFile = new File(newArchiveFile);
                                Long filesize = newFile.length();
                                String metaData = Integer.valueOf(++blockId).toString() + "\t" + newarchiveFileName + "\t10\t" + deRepoName + "\t" + newarchiveFileName.substring(newarchiveFileName.indexOf("_") + 1) + "\tFROZEN\t-\t" + startTime.toString() + "\t" + endTime.toString() + "\t" + totalFileLines.toString() + "\t\"\"\ttrue\t\t" + filesize.toString();
                                ArchiveDataProcessor.addMetaDataEntry(new String[]{metaData}, deRepoName, true);
                                totalFileLines = 0L;
                                startTime = Long.MAX_VALUE;
                                endTime = Long.MIN_VALUE;
                                newarchiveFileName = deRepoName + "_" + System.currentTimeMillis();
                                newArchiveFile = dirName + File.separator + newarchiveFileName + "_S2.gz";
                                zipOutStream = new FileOutputStream(newArchiveFile, true);
                                zipWriter = new OutputStreamWriter((OutputStream)new GZIPOutputStream(zipOutStream), "UTF-8");
                                csvWriter = new CSVWriter((Writer)zipWriter, splitter, '\"', '\\');
                            }
                            EHCacheRecordNumber.putValue(recNumKey);
                            csvWriter.writeNext(line, false);
                            Long eventTime = Long.parseLong(line[timeIndex]);
                            if (eventTime < startTime) {
                                startTime = eventTime;
                            } else if (eventTime > endTime) {
                                endTime = eventTime;
                            }
                            ++validLines;
                            number = totalFileLines;
                            Long l = totalFileLines = Long.valueOf(totalFileLines + 1L);
                        }
                        logger.info("totalLines in file: " + totalLines);
                        logger.info("validLines in file: " + validLines);
                        moveOldFile = true;
                        fileList.remove(key);
                    }
                    catch (Exception ie) {
                        ie.printStackTrace();
                    }
                    finally {
                        if (csvReader != null) {
                            csvReader.close();
                        }
                        if (streamReader != null) {
                            streamReader.close();
                        }
                        if (fileInStream != null) {
                            fileInStream.close();
                        }
                    }
                    if (moveOldFile) {
                        ArchiveDataProcessor.moveOldArchiveFile(archiveFile, moveDir + archiveFile.substring(archiveFile.lastIndexOf(92), archiveFile.length()), moveDir);
                        ArchiveDataProcessor.deleteLoadedIndex(deRepoName, key);
                        ArchiveDataProcessor.deleteColdFile(archiveRepoPath + key + "_S1.7z");
                    }
                    logger.info("time taken to add in set check : " + (System.currentTimeMillis() - time));
                }
            }
            ArchiveDataProcessor.setDataWriter(zipOutStream, zipWriter, csvWriter);
            if (totalFileLines > 0L) {
                File newFile = new File(newArchiveFile);
                Long filesize = newFile.length();
                String metaData = Integer.valueOf(++blockId).toString() + "\t" + newarchiveFileName + "\t10\t" + deRepoName + "\t" + newarchiveFileName.substring(newarchiveFileName.indexOf("_") + 1) + "\tFROZEN\t-\t" + startTime.toString() + "\t" + endTime.toString() + "\t" + totalFileLines.toString() + "\t\"\"\ttrue\t\t" + filesize.toString();
                ArchiveDataProcessor.addMetaDataEntry(new String[]{metaData}, deRepoName, true);
            }
            if (!fileList.isEmpty()) {
                ArchiveDataProcessor.addUnProcessedFilesEntries(fileList, deRepoName, true);
            }
            logger.info("Completed Deleting duplicate Data for repo " + deRepoName + " New files written Count: " + i);
            logger.info("Going to move all new Archive files from archive_temp to Archive directory");
            ArchiveDataProcessor.moveArchiveFiles(dirName, deArchiveLocation);
            logger.info("Moved new archive files Successfully!!!");
            new File(moveDir).renameTo(new File(moveDir + "_" + System.currentTimeMillis()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            EHCacheRecordNumber.destroyCache();
            if (csvWriter != null) {
                try {
                    csvWriter.close();
                }
                catch (Exception exception) {}
            }
            if (zipWriter != null) {
                try {
                    zipWriter.close();
                }
                catch (Exception exception) {}
            }
            if (zipOutStream != null) {
                try {
                    zipOutStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void setDataWriter(FileOutputStream zipOutStream, OutputStreamWriter zipWriter, CSVWriter csvWriter) {
        if (csvWriter != null) {
            try {
                csvWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (zipWriter != null) {
            try {
                zipWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (zipOutStream != null) {
            try {
                zipOutStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMetaDataEntry(String[] metaRows, String deRepo, Boolean isDuplicateDelete) {
        OutputStreamWriter writer = null;
        String newMetaFile = CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + deRepo + "_archive.meta";
        try {
            newMetaFile = isDuplicateDelete != false ? CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + "duplicateDeletion" + File.separator + deRepo + "_archive.meta" : CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + "exclude" + File.separator + deRepo + "_archive.meta";
            File metaFile = new File(newMetaFile);
            if (metaFile.exists()) {
                writer = new FileWriter(newMetaFile, true);
            } else {
                logger.info("File Not exist : " + newMetaFile);
                String metaHeading = "block_id\tblock_name\tversion\tdatarepository_name\tcreation_time\tstate\tstatus\trange_from\trange_to\tdoc_count\tzip_password\tis_merged\tsize\traw_size";
                writer = new FileWriter(newMetaFile);
                writer.write(metaHeading);
                writer.write("\n");
            }
            if (metaRows != null) {
                for (String metaRow : metaRows) {
                    writer.write(metaRow);
                    writer.write("\n");
                    writer.flush();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean moveOldArchiveFile(String oldFile, String movePath, String moveDir) {
        boolean moveSuccess = true;
        try {
            File dir = new File(moveDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            logger.info("Going to move File " + oldFile + " to " + movePath);
            Path moved = Files.move(Paths.get(oldFile, new String[0]), Paths.get(movePath, new String[0]), new CopyOption[0]);
            if (moved != null) {
                logger.info("File moved Successfully :: " + oldFile + " to " + movePath);
            } else {
                logger.info("File move Failed  :: " + oldFile + " to " + movePath);
                moveSuccess = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            moveSuccess = false;
        }
        return moveSuccess;
    }

    public static void moveArchiveFiles(String srcDir, String destDir) {
        try {
            File srcDirectory = new File(srcDir);
            File[] files = srcDirectory.listFiles();
            if (files != null) {
                for (File file : files) {
                    try {
                        String fileName = file.getAbsolutePath();
                        String destPath = destDir + file.getName();
                        Path moved = Files.move(Paths.get(fileName, new String[0]), Paths.get(destPath, new String[0]), new CopyOption[0]);
                        if (moved != null) {
                            logger.info("moveArchiveFiles :: File moved Successfully :: " + fileName + " to " + destPath);
                            continue;
                        }
                        logger.info("moveArchiveFiles :: File move Failed  :: " + fileName + " to " + destPath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void excludeRewriteDEArchiveFiles(String[] cmdStr) {
        try {
            if (!ArchiveDataProcessor.isValidCmd(cmdStr, false).booleanValue()) {
                ioHandler.print("\n\nThe Command is incorrect!!\nRefer Sample Command: admin exclude-archive-data -Repo AdapDNSAuditLog -Exclude CALLER_USER_NAME equals SYSTEM\n");
                return;
            }
            String repoName = cmdStr[3];
            String excludeColumn = cmdStr[5];
            String operator = cmdStr[6];
            String excludeValue = "";
            for (int i = 7; i < cmdStr.length; ++i) {
                excludeValue = excludeValue.isEmpty() ? cmdStr[i] : excludeValue + " " + cmdStr[i];
            }
            logger.info(repoName + " " + excludeColumn + " " + operator + " " + excludeValue);
            int excludeColumnIndex = ArchiveDataProcessor.getExcludeColumnIndex(repoName, excludeColumn.toUpperCase());
            logger.info("excludeColumnIndex: " + excludeColumnIndex);
            ArchiveDataProcessor.checkValidOperator(operator);
            String userInput = null;
            Boolean isDEDown = ArchiveDataProcessor.isDEServiceStopped();
            userInput = isDEDown == false ? ioHandler.readLine("'ManageEngine ADAudit Plus - DataEngine XNode' Service Should be in stopped before this process. Can we stop the 'ManageEngine ADAudit Plus - DataEngine XNode' Service? [y/n] \n") : ioHandler.readLine("'ManageEngine ADAudit Plus - DataEngine XNode' Service is Stopped already. Kindly Confirm not to start DE service untill the process is Completed? [y/n] \n");
            if (!userInput.equalsIgnoreCase("y") && !userInput.equalsIgnoreCase("yes")) {
                ioHandler.print("\n\n'ManageEngine ADAudit Plus - DataEngine XNode' Service Should be in stopped State until this operation is completed! Exiting!!!\n");
                return;
            }
            if (!isDEDown.booleanValue()) {
                ioHandler.print("\n\nGoing to stop 'ManageEngine ADAudit Plus - DataEngine XNode' Service!!!\n");
                if (!ArchiveDataProcessor.stopService("ManageEngine ADAudit Plus - DataEngine XNode").booleanValue()) {
                    ioHandler.print("\n\nFailed to Stop 'ManageEngine ADAudit Plus - DataEngine XNode' Service. Exiting!!!\n");
                    return;
                }
                ioHandler.print("\n\n'ManageEngine ADAudit Plus - DataEngine XNode' Service Stopped Successfully!!!\n");
            }
            userInput = ioHandler.readLine("\nGoing to Exclude data from " + repoName + " Repository with " + excludeColumn + " value " + operator + " " + excludeValue + ".\n Do you want to continue (y/n)? ");
            ioHandler.print("\n");
            userInput = userInput.trim();
            if (!userInput.equalsIgnoreCase("y") && !userInput.equalsIgnoreCase("yes")) {
                ioHandler.print("Exclude process Exit!!!\n");
                return;
            }
            ioHandler.print("Going to proceed with Excluding data. It may take time. Do not close the console.\n");
            ArrayList<String> unExcludedFilesList = new ArrayList<String>();
            ArrayList<String> filesList = new ArrayList<String>();
            filesList = ArchiveDataProcessor.getArchiveFilesList(repoName, filesList, unExcludedFilesList);
            logger.info("filesList: " + filesList);
            ioHandler.print("Going to Start Data Exclusion for " + filesList.size() + " files.\n");
            ioHandler.print("...\n");
            if (filesList.size() > 0) {
                blockId = 0;
                int timeIndex = ArchiveDataProcessor.getExcludeColumnIndex(repoName, "TIME_GENERATED");
                logger.info("timeIndex: " + timeIndex);
                ArchiveDataProcessor.excludeRewriteArchiveFiles(repoName, filesList, operator, excludeValue, excludeColumnIndex, timeIndex, unExcludedFilesList);
                logger.info("unExcludedFilesList  " + unExcludedFilesList);
                if (!unExcludedFilesList.isEmpty()) {
                    ArchiveDataProcessor.addUnProcessedFilesEntries(unExcludedFilesList, repoName, false);
                } else {
                    ArchiveDataProcessor.addMetaDataEntry(null, repoName, false);
                }
                ArchiveDataProcessor.moveMetaFile(repoName, false);
                new File(CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + "exclude").renameTo(new File(CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + "exclude_" + System.currentTimeMillis()));
            }
            ioHandler.print("Exclude process Completed!!!\n");
            ioHandler.print("\n\nThe Old Archive files processed are moved to 'unFilteredFiles_############' Folder in each Current Archive directory of Each DE Repo Folder. Try to load and unload new archive files and then Delete these folders!!!\n");
            return;
        }
        catch (Exception e) {
            ioHandler.print(logger, e.getMessage() + "\n");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getArchiveFilesList(String deRepo, ArrayList<String> oldFilesList, ArrayList<String> unExcludedFilesList) {
        ArrayList<String> filesList = new ArrayList<String>();
        BufferedReader br = null;
        try {
            String st;
            String dePath = CommonUtil.getProductHome() + File.separator + "apps" + File.separator + "dataengine-xnode" + File.separator + "db" + File.separator + "store";
            String metaFile = Paths.get(dePath, new String[0]).normalize().toString() + File.separator + deRepo + "_archive.meta";
            File file = new File(metaFile);
            br = new BufferedReader(new FileReader(file));
            String dirName = Paths.get(CommonUtil.getProductHome(), new String[0]).normalize().toString() + File.separator + "archive_temp" + File.separator + "exclude";
            File dir = new File(dirName);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            ArchiveDataProcessor.copyFile(metaFile, dirName + File.separator + deRepo + "_archive_old.meta");
            while ((st = br.readLine()) != null) {
                String[] metaRow = st.split("\t");
                if (metaRow.length <= 1 || !StringUtils.isNumeric((CharSequence)metaRow[4])) {
                    logger.info("Not numeric:: " + st);
                    continue;
                }
                if ((metaRow[5].equalsIgnoreCase("FROZEN") || metaRow[5].equalsIgnoreCase("DEFROST")) && (metaRow[2].equals("10") || metaRow[2].equals("11")) && !oldFilesList.contains(metaRow[1])) {
                    filesList.add(metaRow[1]);
                    continue;
                }
                if (oldFilesList.contains(metaRow[1]) || unExcludedFilesList.contains(metaRow[1])) continue;
                unExcludedFilesList.add(metaRow[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
        return filesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String infileName, String outfileName) {
        boolean res = true;
        FileInputStream instream = null;
        FileOutputStream outstream = null;
        logger.log(Level.INFO, "Going to Create Copy for File :  " + infileName);
        try {
            int length;
            boolean isValidPath;
            boolean bl = isValidPath = PathTraversal.pathTraversalChecker((String)infileName) && PathTraversal.pathTraversalChecker((String)outfileName);
            if (!isValidPath) {
                logger.log(Level.INFO, "The Path is invalid FileName : infileName :: " + infileName + " outfileName :: " + outfileName);
                boolean bl2 = false;
                return bl2;
            }
            File infile = new File(infileName);
            File outfile = new File(outfileName);
            instream = new FileInputStream(infile);
            outstream = new FileOutputStream(outfile);
            byte[] buffer = new byte[1024];
            while ((length = instream.read(buffer)) > 0) {
                outstream.write(buffer, 0, length);
            }
            instream.close();
            outstream.close();
            logger.log(Level.INFO, "Copied File : " + outfileName);
        }
        catch (IOException ioe) {
            res = false;
            ioe.printStackTrace();
        }
        finally {
            try {
                if (instream != null) {
                    instream.close();
                }
                if (outstream != null) {
                    outstream.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void excludeRewriteArchiveFiles(String deRepoName, ArrayList<String> filesList, String operator, String excludeValue, int excludeColumnIndex, int timeIndex, ArrayList<String> unExcludedFilesList) {
        int processedFilesCount = 0;
        int totalFilesCount = filesList.size();
        try {
            String deArchiveLocation = ArchiveDataProcessor.getCurrentDEArchiveDir() + "audit-log" + File.separator + deRepoName + File.separator + "frozen" + File.separator;
            if (!PathTraversal.pathTraversalChecker((String)deArchiveLocation)) {
                logger.info("Invalid Path while Exluding Archive Data : deArchiveLocation : " + deArchiveLocation);
                return;
            }
            String moveDir = deArchiveLocation + "unFilteredFiles";
            File dir = new File(moveDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String tempDirName = CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + "exclude";
            dir = new File(tempDirName = tempDirName + File.separator + deRepoName);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            char splitter = '\t';
            logger.info("TotalHeap :: " + Runtime.getRuntime().maxMemory() / 0x100000L + " Heap size : " + Runtime.getRuntime().totalMemory() / 0x100000L);
            ArrayList<String> deArchiveDirs = ArchiveDataProcessor.getDEArchivePaths(deArchiveLocation.substring(0, deArchiveLocation.length() - 1));
            for (String archiveDir : deArchiveDirs) {
                File[] listOfArchiveFiles;
                String archiveRepoPath = archiveDir + File.separator + "audit-log" + File.separator + deRepoName + File.separator + "frozen" + File.separator;
                File archiveDirFile = new File(archiveRepoPath);
                logger.info("Going to check archive files in : " + archiveDir);
                if (!archiveDirFile.exists()) continue;
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().endsWith(".gz");
                    }
                };
                for (File arcFile : listOfArchiveFiles = archiveDirFile.listFiles(filter)) {
                    String archiveFile;
                    String string = archiveFile = arcFile.getName().toLowerCase().contains("_s2.gz") ? arcFile.getName().substring(0, arcFile.getName().toLowerCase().indexOf("_s2.gz")) : arcFile.getName().substring(0, arcFile.getName().indexOf(".gz"));
                    if (!filesList.contains(archiveFile)) continue;
                    filesList.remove(archiveFile);
                    long totalLines = 0L;
                    long validLines = 0L;
                    FileInputStream fileInStream = null;
                    InputStreamReader streamReader = null;
                    CSVReader csvReader = null;
                    FileOutputStream zipOutStream = null;
                    OutputStreamWriter zipWriter = null;
                    CSVWriter csvWriter = null;
                    String archiveFilePath = arcFile.getAbsolutePath();
                    boolean isFirstEvent = true;
                    String newArchiveFile = tempDirName + File.separator + archiveFile + "_S2.gz";
                    Long startTime = Long.MAX_VALUE;
                    Long endTime = Long.MIN_VALUE;
                    boolean moveSuccess = true;
                    try {
                        moveSuccess = ArchiveDataProcessor.copyFile(archiveFilePath, moveDir + File.separator + arcFile.getName());
                        if (moveSuccess) {
                            String[] line;
                            archiveFilePath = moveDir + File.separator + arcFile.getName();
                            logger.info("Going to read Archive File : " + archiveFilePath);
                            logger.info("TotalHeap :: " + Runtime.getRuntime().maxMemory() / 0x100000L + " Heap size : " + Runtime.getRuntime().totalMemory() / 0x100000L);
                            fileInStream = new FileInputStream(archiveFilePath);
                            streamReader = new InputStreamReader((InputStream)new GZIPInputStream(fileInStream), "UTF-8");
                            csvReader = new CSVReader((Reader)new BufferedReader(streamReader), splitter);
                            while ((line = csvReader.readNext()) != null) {
                                Long eventTime;
                                ++totalLines;
                                if (ArchiveDataProcessor.excludeCheck(line[excludeColumnIndex].toLowerCase(), operator.toLowerCase(), excludeValue.toLowerCase())) continue;
                                if (isFirstEvent) {
                                    zipOutStream = new FileOutputStream(newArchiveFile, true);
                                    zipWriter = new OutputStreamWriter((OutputStream)new GZIPOutputStream(zipOutStream), "UTF-8");
                                    csvWriter = new CSVWriter((Writer)zipWriter, splitter, '\"', '\\');
                                    isFirstEvent = false;
                                }
                                if ((eventTime = Long.valueOf(Long.parseLong(line[timeIndex]))) < startTime) {
                                    startTime = eventTime;
                                } else if (eventTime > endTime) {
                                    endTime = eventTime;
                                }
                                csvWriter.writeNext(line, false);
                                ++validLines;
                            }
                            logger.info("totalLines in file: " + totalLines);
                            logger.info("validLines in file: " + validLines);
                            ++processedFilesCount;
                        }
                    }
                    catch (Exception ie) {
                        ie.printStackTrace();
                    }
                    finally {
                        if (csvReader != null) {
                            csvReader.close();
                        }
                        if (streamReader != null) {
                            streamReader.close();
                        }
                        if (fileInStream != null) {
                            fileInStream.close();
                        }
                        if (csvWriter != null) {
                            try {
                                csvWriter.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (zipWriter != null) {
                            try {
                                zipWriter.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (zipOutStream != null) {
                            try {
                                zipOutStream.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (isFirstEvent && moveSuccess) {
                        logger.info("All lines are Excluded!!! " + archiveFilePath);
                    } else if (moveSuccess) {
                        File newFile = new File(newArchiveFile);
                        Long filesize = newFile.length();
                        String metaData = Integer.valueOf(++blockId).toString() + "\t" + archiveFile + "\t10\t" + deRepoName + "\t" + archiveFile.substring(archiveFile.indexOf("_") + 1) + "\tFROZEN\t-\t" + startTime.toString() + "\t" + endTime.toString() + "\t" + Long.valueOf(validLines).toString() + "\t\"\"\ttrue\t\t" + filesize.toString();
                        ArchiveDataProcessor.addMetaDataEntry(new String[]{metaData}, deRepoName, false);
                    }
                    if (moveSuccess) {
                        ArchiveDataProcessor.deleteLoadedIndex(deRepoName, archiveFile);
                        ArchiveDataProcessor.deleteColdFile(archiveRepoPath + archiveFile + "_S1.7z");
                        boolean isDeleted = ArchiveDataProcessor.deleteFile(arcFile.getAbsolutePath());
                        if (!isDeleted || isFirstEvent) continue;
                        ArchiveDataProcessor.moveOldArchiveFile(newArchiveFile, deArchiveLocation + archiveFile + "_S2.gz", deArchiveLocation);
                        continue;
                    }
                    unExcludedFilesList.add(archiveFile);
                }
            }
            unExcludedFilesList.addAll(filesList);
            new File(moveDir).renameTo(new File(moveDir + "_" + System.currentTimeMillis()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ioHandler.print("Data Exclusion completed Successfully for " + processedFilesCount + " files!!!\n");
        if (totalFilesCount != processedFilesCount) {
            ioHandler.print("\n***Issue Occurred while processing Archive files. Kindly Contact ADAuditplus Support.***\n");
        }
        logger.info("Completed Filtering Data for repo " + deRepoName + " New files written Count: " + blockId);
    }

    public static boolean excludeCheck(String columnValue, String operator, String filterValue) {
        boolean isSatisfied = false;
        if (operator.equalsIgnoreCase("equals")) {
            if (columnValue.equalsIgnoreCase(filterValue)) {
                isSatisfied = true;
            }
        } else if (operator.equalsIgnoreCase("startswith")) {
            if (columnValue.startsWith(filterValue)) {
                isSatisfied = true;
            }
        } else if (operator.equalsIgnoreCase("endswith")) {
            if (columnValue.endsWith(filterValue)) {
                isSatisfied = true;
            }
        } else if (operator.equalsIgnoreCase("contains") && columnValue.contains(filterValue)) {
            isSatisfied = true;
        }
        return isSatisfied;
    }

    public static int getExcludeColumnIndex(String deRepoName, String filterColumn) throws Exception {
        String dePath = CommonUtil.getProductHome() + File.separator + "apps" + File.separator + "dataengine-xnode" + File.separator + "conf" + File.separator + "datarepository" + File.separator + "schema" + File.separator + deRepoName + "_V1.json";
        FileInputStream is = new FileInputStream(dePath);
        JSONTokener tokener = new JSONTokener((InputStream)is);
        JSONObject object = new JSONObject(tokener);
        JSONArray columns = (JSONArray)object.getJSONObject("mappings").get("field_list");
        for (int i = 0; i < columns.length(); ++i) {
            JSONObject obj = (JSONObject)columns.get(i);
            if (!obj.has(filterColumn)) continue;
            return i;
        }
        throw new Exception("Invalid Column name/ RepoName : " + filterColumn + " Repo Name : " + deRepoName);
    }

    public static void checkValidOperator(String operator) throws Exception {
        if (!(operator.equalsIgnoreCase("equals") || operator.equalsIgnoreCase("startswith") || operator.equalsIgnoreCase("endswith") || operator.equalsIgnoreCase("contains"))) {
            throw new Exception("Invalid operator : " + operator);
        }
    }

    private static boolean deleteFile(String fileName) {
        boolean isDeleted = true;
        try {
            File file = new File(fileName);
            if (file.delete()) {
                logger.info("Deleted file successfully !!! fileName : " + fileName);
            } else {
                isDeleted = false;
                logger.info("Unable to Delete file : " + fileName);
            }
            file = null;
        }
        catch (Exception ex) {
            isDeleted = false;
            ex.printStackTrace();
        }
        return isDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUnProcessedFilesEntries(ArrayList<String> filesList, String deRepo, Boolean isDuplicate) {
        BufferedReader br = null;
        try {
            String st;
            logger.info("Going to Add unExcluded files entries in temp meta file : " + filesList.size() + " deRepo " + deRepo);
            String dePath = CommonUtil.getProductHome() + File.separator + "apps" + File.separator + "dataengine-xnode" + File.separator + "db" + File.separator + "store";
            String metaFile = dePath + File.separator + deRepo + "_archive.meta";
            File file = new File(metaFile);
            br = new BufferedReader(new FileReader(file));
            int index = 0;
            String[] metaRows = new String[filesList.size()];
            while ((st = br.readLine()) != null) {
                String[] metaRow = st.split("\t");
                if (metaRow.length <= 1 || !StringUtils.isNumeric((CharSequence)metaRow[4]) || !filesList.contains(metaRow[1])) continue;
                metaRows[index++] = Integer.valueOf(++blockId).toString() + st.substring(st.indexOf("\t"));
            }
            ArchiveDataProcessor.addMetaDataEntry(metaRows, deRepo, isDuplicate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getCurrentDEArchiveDir() {
        String deArchiveDir = "";
        try {
            INIConfiguration config = new INIConfiguration();
            FileHandler confFileHandler = new FileHandler((FileBased)config);
            File confFile = new File(CommonUtil.getProductHome() + File.separator + "apps" + File.separator + "dataengine-xnode" + File.separator + "conf" + File.separator + "datarepository" + File.separator + "archive-locations.conf");
            confFileHandler.load(confFile);
            confFileHandler.setFile(confFile);
            for (String arcLocation : config.getSections()) {
                SubnodeConfiguration subnodeConf = config.getSection(arcLocation);
                if (!subnodeConf.getString("state").equalsIgnoreCase("current")) continue;
                deArchiveDir = subnodeConf.getString("path");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        deArchiveDir = Paths.get(deArchiveDir, new String[0]).normalize().toString() + File.separator;
        logger.info("getCurrentDEArchiveDir deArchiveDir : " + deArchiveDir);
        return deArchiveDir;
    }

    public static ArrayList<String> getDEArchivePaths(String currentArchivePath) {
        ArrayList<String> archivePaths = new ArrayList<String>();
        try {
            INIConfiguration config = new INIConfiguration();
            FileHandler confFileHandler = new FileHandler((FileBased)config);
            File confFile = new File(CommonUtil.getProductHome() + File.separator + "apps" + File.separator + "dataengine-xnode" + File.separator + "conf" + File.separator + "datarepository" + File.separator + "archive-locations.conf");
            confFileHandler.load(confFile);
            confFileHandler.setFile(confFile);
            for (String arcLocation : config.getSections()) {
                String path = config.getSection(arcLocation).getString("path");
                if (PathTraversal.pathTraversalChecker((String)path)) {
                    archivePaths.add(path);
                    continue;
                }
                logger.info("Invalid Path in DE archive-location file : " + path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return archivePaths;
    }

    public static void moveMetaFile(String deRepo, Boolean isDuplicateDelete) {
        try {
            String dePath = CommonUtil.getProductHome() + File.separator + "apps" + File.separator + "dataengine-xnode" + File.separator + "db" + File.separator + "store";
            String metaFile = Paths.get(dePath, new String[0]).normalize().toString() + File.separator + deRepo + "_archive.meta";
            String newMetaFile = CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + "duplicateDeletion" + File.separator + deRepo + "_archive.meta";
            if (!isDuplicateDelete.booleanValue()) {
                newMetaFile = CommonUtil.getProductHome() + File.separator + "archive_temp" + File.separator + "exclude" + File.separator + deRepo + "_archive.meta";
            }
            ArchiveDataProcessor.copyFile(Paths.get(newMetaFile, new String[0]).normalize().toString(), metaFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Boolean isDEServiceStopped() {
        Boolean isDEDown = false;
        String deState = ArchiveDataProcessor.getServiceState("ManageEngine ADAudit Plus - DataEngine XNode").toLowerCase();
        if (deState.contains("stopped")) {
            isDEDown = true;
        }
        return isDEDown;
    }

    private static String getServiceState(String serviceName) {
        try {
            String line;
            ProcessBuilder builder = new ProcessBuilder("sc", "query", serviceName);
            Process process = builder.start();
            InputStream inputStream = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (!line.contains("STATE") || (parts = line.split(":")).length < 2) continue;
                return parts[1].trim();
            }
            return "Unknown";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error";
        }
    }

    private static Boolean stopService(String serviceName) {
        Boolean isDEDown = false;
        try {
            ProcessBuilder builder = new ProcessBuilder("sc", "stop", serviceName);
            Process process = builder.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                logger.info("Service stopped successfully.");
                isDEDown = true;
            } else {
                logger.info("Failed to stop service. Exit code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return isDEDown;
    }

    private static Boolean isValidCmd(String[] cmdStr, boolean isDuplicate) {
        Boolean isValid = false;
        if (isDuplicate) {
            if (cmdStr.length == 5 && cmdStr[2].equalsIgnoreCase("bt")) {
                isValid = true;
            }
        } else if (cmdStr[2].equalsIgnoreCase("-Repo") && cmdStr[4].equalsIgnoreCase("-Exclude")) {
            isValid = true;
        }
        return isValid;
    }

    private static void deleteLoadedIndex(String repoName, String blockName) {
        try {
            String dePath = CommonUtil.getProductHome() + File.separator + "apps" + File.separator + "dataengine-xnode" + File.separator + "data" + File.separator + "archive" + File.separator + "audit-log" + File.separator + repoName + File.separator + "defrost";
            String loadedDir = Paths.get(dePath, new String[0]).normalize().toString() + File.separator + blockName;
            File dir = new File(loadedDir);
            if (dir.exists()) {
                logger.info("Going to Delete Loaded Index : " + loadedDir);
                FileUtils.deleteDirectory((File)dir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteColdFile(String coldFilePath) {
        try {
            File coldFile = new File(coldFilePath);
            if (coldFile.exists()) {
                if (coldFile.delete()) {
                    logger.info("Deleted Cold file successfully !!! fileName : " + coldFilePath);
                } else {
                    logger.info("Unable to Delete Cold file : " + coldFilePath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

