/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.sym.adsm.auditing.server.eventcollection.CustomThreadFactory;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchFileIndexHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchFileIndexState;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryManager;
import com.adventnet.sym.adsm.common.server.commandline.Command;
import com.adventnet.sym.adsm.common.server.commandline.LeafCommand;
import com.adventnet.sym.adsm.common.server.commandline.StemCommand;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class ArchiveSearchCmd
extends StemCommand {
    public static final String DATE_PATTERN_STR = "^[0-9]{2}-[0-9]{2}-[0-9]{4}$";
    public static final Pattern DATE_PATTERN = Pattern.compile("^[0-9]{2}-[0-9]{2}-[0-9]{4}$");
    public final Command help = new LeafCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ArchiveSearchCmd.this.processHelp();
        }
    };
    public final Command index = new LeafCommand(this.getCmdId() + "1", "index", "Index archive files"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ArchiveSearchCmd.this.processIndex(cmdStr, processIndex);
        }
    };
    public final Command index_info = new LeafCommand(this.getCmdId() + "2", "index-info", "View the index status of the archive files"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ArchiveSearchCmd.this.processIndexInfo(cmdStr, processIndex);
        }
    };

    public ArchiveSearchCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, Command> childCmdList = new LinkedHashMap<String, Command>();
        childCmdList.put(this.help.getCmdId(), this.help);
        childCmdList.put(this.index.getCmdId(), this.index);
        childCmdList.put(this.index_info.getCmdId(), this.index_info);
        this.setChildCmdList(childCmdList);
    }

    private void processIndex(String[] cmdStr, int processIndex) throws Exception {
        JSONArray indexCategoryFileList = new JSONArray();
        JSONObject indexFileListObj = new JSONObject();
        JSONObject indexCategoryFileListObj = new JSONObject();
        int catId = 0;
        int fileLimit = -1;
        Long startDate = null;
        Long endDate = null;
        if (this.validateIndexCmd(cmdStr, processIndex)) {
            JSONObject jTopArchFileObj;
            JSONArray jTopArchFileList;
            if (!cmdStr[processIndex + 1].equals("*")) {
                catId = Integer.parseInt(cmdStr[processIndex + 1]);
            }
            if (processIndex + 2 == cmdStr.length - 1) {
                if (!cmdStr[processIndex + 2].equals("*")) {
                    fileLimit = Integer.parseInt(cmdStr[processIndex + 2]);
                }
            } else {
                String fromDate = cmdStr[processIndex + 2].trim();
                String toDate = cmdStr[processIndex + 3].trim();
                startDate = new SimpleDateFormat("dd-MM-yyyy").parse(fromDate).getTime() / 1000L;
                endDate = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss:SSS").parse(toDate + " 23:59:59:999").getTime() / 1000L;
            }
            if ((jTopArchFileList = (jTopArchFileObj = ArchFileIndexHandler.fetchArchFileList((Integer)catId, startDate, endDate, (String)"START_TIME", (String)"DESC", (Integer)1, (Integer)fileLimit, (Integer)ArchFileIndexState.UN_INDEXED.ordinal())).getJSONArray("archIndexFileList")).length() != 0 && this.getConfirmation(jTopArchFileList.length())) {
                int listLen = jTopArchFileList.length();
                ExecutorService executorService = Executors.newFixedThreadPool(4, (ThreadFactory)new CustomThreadFactory("ArchiveSearchCmd"));
                ExecutorCompletionService<String> taskCompletionService = new ExecutorCompletionService<String>(executorService);
                ArrayList<Future<String>> futureList = new ArrayList<Future<String>>();
                int i = 0;
                while (i < listLen) {
                    indexCategoryFileList = new JSONArray();
                    indexCategoryFileListObj = new JSONObject();
                    indexFileListObj = new JSONObject();
                    indexCategoryFileList.put((Object)jTopArchFileList.getJSONArray(i).get(2).toString());
                    indexCategoryFileListObj.put(jTopArchFileList.getJSONArray(i).getInt(0) + "", (Object)indexCategoryFileList);
                    indexFileListObj.put("categoryFileList", (Object)indexCategoryFileListObj);
                    indexFileListObj.put("actionType", (Object)"index");
                    final JSONObject jObj = indexFileListObj;
                    final int index = i++;
                    Future<String> future = taskCompletionService.submit(new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            ArchiveSearchCmd.this.ioHandle().print("\n " + (index + 1) + " Indexing file " + jTopArchFileList.getJSONArray(index).get(2).toString() + "...");
                            ArchFileIndexHandler.indexArchFiles((JSONObject)jObj, (AdventNetResourceBundle)ResourceBundleMgr.getInstance().getBundle(), (boolean)false);
                            return jTopArchFileList.getJSONArray(index).get(2).toString();
                        }
                    });
                    futureList.add(future);
                }
                int indexedCount = 1;
                for (int i2 = 0; i2 < futureList.size(); ++i2) {
                    Future result = taskCompletionService.take();
                    this.ioHandle().print("\n\n Indexed " + (String)result.get() + "! Summary : [" + indexedCount + "/" + listLen + "]\n");
                    ++indexedCount;
                }
                this.ioHandle().print("\n\n");
            }
        }
    }

    private boolean validateIndexCmd(String[] cmdStr, int processIndex) throws IOException {
        boolean isValid = true;
        int len = cmdStr.length;
        try {
            if (processIndex + 2 == len - 1) {
                int catId = 0;
                int fileLimit = -1;
                if (!cmdStr[processIndex + 1].equals("*")) {
                    catId = Integer.parseInt(cmdStr[processIndex + 1]);
                }
                if (!cmdStr[processIndex + 2].equals("*")) {
                    fileLimit = Integer.parseInt(cmdStr[processIndex + 2]);
                }
            } else if (processIndex + 3 == len - 1) {
                String fromDate = cmdStr[processIndex + 2].trim();
                String toDate = cmdStr[processIndex + 3].trim();
                if (!DATE_PATTERN.matcher(fromDate).matches() || !DATE_PATTERN.matcher(toDate).matches()) {
                    this.printIndexCmdHelp();
                    isValid = false;
                }
            } else {
                this.printIndexCmdHelp();
                isValid = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printIndexCmdHelp();
            isValid = false;
        }
        return isValid;
    }

    private void printIndexCmdHelp() throws IOException {
        ArchLogCategoryManager catManager = ArchLogCategoryManager.getInstance();
        ArrayList categoryIdList = catManager.getArchCategoryIdList();
        this.ioHandle().print("\n Wrong Usage!\n");
        this.ioHandle().print("\n Syntax:\n");
        this.ioHandle().print("\n     INDEX <Category No | *> <File Limit | *>\n\n\t\t\tOr\n\n");
        this.ioHandle().print("\n     INDEX <Category No | *> dd-MM-yyyy dd-MM-yyyy\n\n");
        this.ioHandle().print(String.format("\n\t%-25s%-10s", "Category", "Category No"));
        this.ioHandle().print("\n\t---------------------------------------");
        for (Integer categoryId : categoryIdList) {
            String catName = catManager.getArchCategoryName(categoryId.intValue());
            this.ioHandle().print(String.format("\n\t%-25s%-10s", catName, "" + categoryId));
        }
        this.ioHandle().print("\n\n     Eg: INDEX 10 1000   - Will Index first 1000 files in File Audit category\n\n\n");
    }

    private boolean getConfirmation(int fileCount) throws IOException {
        String userInput = this.ioHandle().readLine("\n There are " + fileCount + " files in the selected time frame. Do you want to index them all(y/n)? ");
        this.ioHandle().print("\n");
        userInput = userInput.trim();
        if (userInput.equalsIgnoreCase("y") || userInput.equalsIgnoreCase("yes")) {
            return true;
        }
        if (userInput.equalsIgnoreCase("n") || userInput.equalsIgnoreCase("no")) {
            return false;
        }
        return false;
    }

    private void processIndexInfo(String[] cmdStr, int processIndex) {
        try {
            ArchLogCategoryManager catManager = ArchLogCategoryManager.getInstance();
            ArrayList categoryIdList = catManager.getArchCategoryIdList();
            this.ioHandle().print("\nArchive File Index Info :- ");
            this.ioHandle().print("\n------------------------------------------------------------------------------------------");
            this.ioHandle().print(String.format("\n%-30s%-30s%-30s", " Category Name", "Indexed/Indexing Files", "Un-Indexed/Un-Indexing Files"));
            this.ioHandle().print("\n------------------------------------------------------------------------------------------");
            for (Integer categoryId : categoryIdList) {
                String catName = catManager.getArchCategoryName(categoryId.intValue());
                int indexedCount = ArchFileIndexHandler.fetchArchFileCount((int)categoryId, (Integer[])new Integer[]{ArchFileIndexState.INDEXED.ordinal(), ArchFileIndexState.INDEXING.ordinal(), ArchFileIndexState.INDEXING_SCH.ordinal()});
                int unindexedCount = ArchFileIndexHandler.fetchArchFileCount((int)categoryId, (Integer[])new Integer[]{ArchFileIndexState.UN_INDEXED.ordinal(), ArchFileIndexState.UN_INDEXING.ordinal(), ArchFileIndexState.UN_INDEXING_SCH.ordinal()});
                this.ioHandle().print(String.format("\n%-30s%-30d%-30d", " " + catName, indexedCount, unindexedCount));
            }
            this.ioHandle().print("\n------------------------------------------------------------------------------------------\n\n\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

