/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.authentication.PAMException;
import com.adventnet.authentication.util.AuthDBUtil;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.StandAlonePersistence;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.commandline.IOHandler;
import com.adventnet.sym.adsm.common.server.commandline.JLineIOHandler;
import com.adventnet.sym.adsm.common.server.commandline.Role;
import com.adventnet.sym.adsm.common.server.commandline.RoleManager;
import com.adventnet.sym.adsm.common.server.commandline.RootCmd;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.NullCompleter;
import jline.console.completer.StringsCompleter;
import org.json.JSONArray;
import org.json.JSONObject;

public class CmdUtil
extends StandAlonePersistence {
    private static final Logger LOGGER = Logger.getLogger(CmdUtil.class.getName());
    private String shellPrompt = "adap # ";
    private String loginName = null;
    private String password = null;
    private String domainName = null;
    private static Role userRole;
    private static IOHandler ioHandle;
    public static final RootCmd ROOT;

    public CmdUtil() throws Exception {
        ioHandle = new JLineIOHandler();
        userRole = RoleManager.getRole("adap");
    }

    public void printBanner() throws IOException {
        ioHandle.print("****************************************************************************************\n");
        ioHandle.print("*                                                                                      *\n");
        ioHandle.print("*                                Welcome to ADAuditPlus                                *\n");
        ioHandle.print("*                                                                                      *\n");
        ioHandle.print("****************************************************************************************\n\n");
    }

    public boolean authenticate() throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        boolean result = false;
        String serviceName = null;
        try {
            DataObject accountDO = null;
            this.loginName = ioHandle.readLine("Username : ");
            this.password = ioHandle.readLine("Password : ", Character.valueOf('*'));
            this.loginName = this.loginName.toLowerCase();
            this.domainName = "ADAuditPlus Authentication";
            serviceName = "System";
            if (this.loginName.equals("adap") && this.password.equals("adap")) {
                this.handleSuccessfullLogin();
                return true;
            }
            try {
                accountDO = AuthDBUtil.getAccountDO((String)this.loginName, (String)serviceName, (String)this.domainName);
                CmdUtil.isValidAccount(accountDO);
                Row pwdRow = accountDO.getFirstRow("AaaPassword");
                String pwdFrmDB = (String)pwdRow.get("PASSWORD");
                String salt = (String)pwdRow.get("SALT");
                String algorithm = (String)pwdRow.get("ALGORITHM");
                String encPwd = AuthUtil.getEncryptedPassword((String)this.password, (String)salt, (String)algorithm);
                result = pwdFrmDB.equals(encPwd);
                Row loginRow = accountDO.getFirstRow("AaaLogin");
                if (!result) {
                    throw new LoginException("adap.ADAPADAuthenticator.Invalid_loginNamepassword");
                }
                this.handleSuccessfullLogin();
            }
            catch (DataAccessException dae) {
                throw new PAMException(rb.getString("adap.ADAPADAuthenticator.DataAccessException_occured_while_fetching_account"), (Exception)((Object)dae));
            }
            catch (LoginException e) {
                e.printStackTrace();
                throw new LoginException(rb.getString(e.getMessage()));
            }
        }
        catch (LoginException loginException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isValidAccount(DataObject accountDO) throws LoginException {
        try {
            if (accountDO == null) {
                throw new PAMException("adap.ADAPADAuthenticator.Account_DO_fetched_is_null");
            }
            if (!accountDO.containsTable("AaaAccount")) {
                throw new LoginException("adap.ADAPADAuthenticator.No_such_account_configured_for");
            }
            if (!accountDO.containsTable("AaaPassword")) {
                throw new LoginException("adap.ADAPADAuthenticator.No_password_configured_for_this");
            }
            if (!accountDO.containsTable("AaaUserStatus")) {
                throw new LoginException("adap.ADAPADAuthenticator.no_such_user_is_configured");
            }
            Row userStatusRow = accountDO.getRow("AaaUserStatus");
            String userStatus = (String)userStatusRow.get("STATUS");
            if ("DISABLED".equalsIgnoreCase(userStatus)) {
                throw new LoginException("adap.ADAPADAuthenticator.user_is_disabled_in_exchange_reporter_plus");
            }
            Row passwordRow = accountDO.getFirstRow("AaaPassword");
            String algorithm = (String)passwordRow.get("ALGORITHM");
            if (algorithm == null || !algorithm.equals("bcrypt") && !algorithm.equals("MD5")) {
                throw new PAMException("adap.ADAPADAuthenticator.Unknown_algorithm_only_MD5_is");
            }
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
        return true;
    }

    public void handleSuccessfullLogin() throws Exception {
        ioHandle.print("\n\nWelcome " + this.loginName + "!\n\n\n");
        this.shellPrompt = this.loginName + "@adap # ";
        ioHandle.setPrompt(this.shellPrompt);
        userRole = RoleManager.getEquivalentRole(this.loginName);
        JSONArray jCmdList = ROOT.getCommandTree();
        LinkedList<Completer> argumentCompleterList = new LinkedList<Completer>();
        CmdUtil.buildCommandSuggestionTree(jCmdList, new LinkedList<String>(), argumentCompleterList);
        ioHandle.addCompleter(new AggregateCompleter(argumentCompleterList));
    }

    public void handleLogout() {
        ioHandle.print("\n\n Bye " + this.loginName + "!\n\n");
        ioHandle.flush();
        userRole = RoleManager.getRole("adap");
        ioHandle.clearCompleters();
    }

    private static void buildCommandSuggestionTree(JSONArray jCmdList, LinkedList<String> parentCmdList, LinkedList<Completer> argumentCompleterList) throws Exception {
        LinkedList<Object> currentCompleterList = new LinkedList<Object>();
        for (String parentCmd : parentCmdList) {
            currentCompleterList.add(new StringsCompleter(new String[]{parentCmd}));
        }
        LinkedList<String> currentLeafNodeList = new LinkedList<String>();
        int index = 0;
        for (index = 0; index < jCmdList.length(); ++index) {
            JSONObject node = jCmdList.getJSONObject(index);
            String cmdName = node.optString("nodeName");
            JSONArray childCmdList = node.optJSONArray("nodeChildList");
            if (childCmdList == null || childCmdList.length() == 0) {
                currentLeafNodeList.add(cmdName);
                continue;
            }
            parentCmdList.add(cmdName);
            CmdUtil.buildCommandSuggestionTree(childCmdList, parentCmdList, argumentCompleterList);
            parentCmdList.pollLast();
        }
        StringsCompleter currentLeafNodeCompleter = new StringsCompleter(currentLeafNodeList);
        currentCompleterList.add(currentLeafNodeCompleter);
        currentCompleterList.add(new NullCompleter());
        argumentCompleterList.add((Completer)new ArgumentCompleter(currentCompleterList));
    }

    public boolean listenConsole() {
        boolean run = true;
        String inputCmd = "";
        boolean listen = true;
        while (listen) {
            try {
                inputCmd = ioHandle.readLine().trim();
                if (inputCmd.equalsIgnoreCase("exit")) {
                    TDHandler.addToDB();
                    ioHandle.print("\n\n Bye!\n\n");
                    ioHandle.flush();
                    listen = false;
                    run = false;
                    continue;
                }
                if (inputCmd.equalsIgnoreCase("account logout")) {
                    this.handleLogout();
                    listen = false;
                    run = true;
                    continue;
                }
                if (inputCmd.endsWith("?")) {
                    ROOT.showSuggestions(inputCmd.toString().trim().toLowerCase().split("\\s+"), 0);
                    continue;
                }
                if (inputCmd.equalsIgnoreCase("cls")) {
                    ioHandle.clearScreen();
                    continue;
                }
                if (inputCmd.isEmpty()) continue;
                LOGGER.info("PROCESSING command '" + inputCmd + "'");
                final String finalInputCmd = inputCmd;
                HashMap auditingDetailsMap = new HashMap(){
                    {
                        this.put("CREDENTIAL", null);
                        this.put("ACTION_ID", 2);
                        this.put("ACTION_CATEGORY", "CmdUtil");
                        this.put("MESSAGE", finalInputCmd);
                        this.put("ACCESS_TYPE", 8);
                        this.put("EVENT_TYPE", 8);
                        this.put("SEVERITY", "adap.ADAPUserAuditSeverities.audit_name.data_updated");
                        this.put("ADDITIONAL_INFO", "CmdUtil-PROCESSING command");
                    }
                };
                TDHandler.addAuditEntries((HashMap)auditingDetailsMap);
                ROOT.process(inputCmd.trim().toLowerCase().split("\\s+"), 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.severe("\n# ERROR \n\n" + e.getMessage() + "\n");
                try {
                    ioHandle.print("\n# ERROR \n\n" + e.getMessage() + "\n");
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
        }
        return run;
    }

    public static Role currentUserRole() {
        return userRole;
    }

    public static IOHandler ioHandler() {
        return ioHandle;
    }

    public void postPopulation() {
        try {
            boolean run = true;
            while (run) {
                this.printBanner();
                while (!this.authenticate()) {
                    ioHandle.print("\nAuthentication failed! Retry\n\n\n");
                }
                run = this.listenConsole();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ioHandle.print("\n# ERROR \n\n" + e.getMessage() + "\n\nExiting!!");
            }
            catch (Exception ie) {
                ie.printStackTrace();
            }
        }
    }

    static {
        ROOT = new RootCmd();
    }
}

