/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.sym.adsm.common.server.commandline.AddServerCmd;
import com.adventnet.sym.adsm.common.server.commandline.Command;
import com.adventnet.sym.adsm.common.server.commandline.FeatureCmd;
import com.adventnet.sym.adsm.common.server.commandline.LeafCommand;
import com.adventnet.sym.adsm.common.server.commandline.StemCommand;
import com.adventnet.sym.adsm.common.server.commandline.util.FeatureUpdateUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;

public class ConfigCmd
extends StemCommand {
    public final Command help = new LeafCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ConfigCmd.this.processHelp();
        }
    };
    public final AddServerCmd server = new AddServerCmd(this.getCmdId() + "1", "server", "Configuring Bulk Servers (FS,MS,WS)");
    public final FeatureCmd feature = new FeatureCmd(this.getCmdId() + "2", "server", "Feature Status check and change)");
    public final Command change_dashboard_schedule = new LeafCommand(this.getCmdId() + "3", "change-dashboard-schedule", "Change the dashboard schedule time to periodically"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ConfigCmd.this.checkInputAndProcess(cmdStr, processIndex);
        }
    };
    public final Command change_pdf_font_encoding = new LeafCommand(this.getCmdId() + "4", "change-pdf-font", "Change the dashboard schedule time to periodically"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ConfigCmd.this.checkInputAndProcess(cmdStr, processIndex);
        }
    };
    public final Command haquery = new LeafCommand(this.getCmdId() + "5", "haquery", "Executes HA setup Query"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureUpdateUtil.haConfiguration(cmdStr, processIndex);
        }
    };

    public ConfigCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, Command> childCmdList = new LinkedHashMap<String, Command>();
        childCmdList.put(this.help.getCmdId(), this.help);
        childCmdList.put(this.server.getCmdId(), this.server);
        childCmdList.put(this.feature.getCmdId(), this.feature);
        childCmdList.put(this.change_dashboard_schedule.getCmdId(), this.change_dashboard_schedule);
        childCmdList.put(this.change_pdf_font_encoding.getCmdId(), this.change_pdf_font_encoding);
        childCmdList.put(this.haquery.getCmdId(), this.haquery);
        this.setChildCmdList(childCmdList);
    }

    private boolean checkInputAndProcess(String[] cmdStr, int processIndex) throws IOException {
        boolean isValid = true;
        int len = cmdStr.length;
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String subCommand = cmdStr[1];
        try {
            if (subCommand.equalsIgnoreCase("change-dashboard-schedule")) {
                int timePeriod = 6;
                if (len == 3) {
                    timePeriod = Integer.parseInt(cmdStr[2]);
                }
                FeatureUpdateUtil.changeDashboardSchedule(timePeriod);
            } else if (subCommand.equalsIgnoreCase("change-pdf-font")) {
                String country = "-";
                if (len == 3) {
                    country = cmdStr[2];
                }
                FeatureUpdateUtil.updatePDFExportPrams(country);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isValid = false;
        }
        return isValid;
    }
}

