/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline;

import com.adventnet.sym.adsm.auditing.server.compliance.DataCruncher;
import com.adventnet.sym.adsm.common.server.commandline.Command;
import com.adventnet.sym.adsm.common.server.commandline.LeafCommand;
import com.adventnet.sym.adsm.common.server.commandline.StemCommand;
import com.adventnet.sym.adsm.common.server.commandline.UserWorkHoursCmd;
import com.adventnet.sym.adsm.common.server.commandline.util.DBTableTroubleshooting;
import com.adventnet.sym.adsm.common.server.commandline.util.DataBaseTroubleshooting;
import com.adventnet.sym.adsm.common.server.commandline.util.FeatureCheckUtil;
import com.adventnet.sym.adsm.common.server.commandline.util.FeatureUpdateUtil;
import com.adventnet.sym.adsm.common.server.commandline.util.SupportTroubleshooting;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;

public class TroubleshootCmd
extends StemCommand {
    public final Command help = new LeafCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            TroubleshootCmd.this.processHelp();
        }
    };
    public final Command getting_basic_info = new LeafCommand(this.getCmdId() + "1", "get-basic-info", "Getting Basic information about installation"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            SupportTroubleshooting.getInstalledMachineDetails();
            SupportTroubleshooting.printSystemProperties();
            DataBaseTroubleshooting.gettingDBConfigSettngs();
            SupportTroubleshooting.allBasicConfiguration();
            DBTableTroubleshooting.getTableColumnDetails();
            FeatureCheckUtil.getObjectCountPerDomain();
            FeatureCheckUtil.getSizeOfSIEMLogFoler();
        }
    };
    public final Command no_data_available = new LeafCommand(this.getCmdId() + "2", "no-data-available", "Getting Basic information about installation"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureCheckUtil.duplicateFolderCheck();
            FeatureCheckUtil.processedFilesCheck();
            FeatureCheckUtil.rawFilesCheck(true);
            FeatureCheckUtil.checkRPDisabled();
            FeatureCheckUtil.isBCPAvailable();
            FeatureCheckUtil.isBCPWorkingFine();
        }
    };
    public final Command disk_space_check = new LeafCommand(this.getCmdId() + "3", "disk-space-check", "Getting Basic information about installation"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DataBaseTroubleshooting.getDBSize();
            FeatureCheckUtil.duplicateFolderCheck();
            FeatureCheckUtil.processedFilesCheck();
            FeatureCheckUtil.rawFilesCheck(false);
        }
    };
    public final Command raw_folder_analysis = new LeafCommand(this.getCmdId() + "4", "raw-folder", "Getting Basic information about installation"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureCheckUtil.duplicateFolderCheck();
            FeatureCheckUtil.rawFilesCheck(true);
        }
    };
    public final Command processed_folder_analysis = new LeafCommand(this.getCmdId() + "5", "processed-folder-analysis", "Getting Basic information about installation"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureCheckUtil.duplicateFolderCheck();
            FeatureCheckUtil.processedFilesCheck();
            DBTableTroubleshooting.checkDataTableSchema();
        }
    };
    public final Command feature_status = new LeafCommand(this.getCmdId() + "6", "feature-status-check", "Getting Basic information about installation"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            SupportTroubleshooting.getFeatureStatus();
        }
    };
    public final Command scheduler_status = new LeafCommand(this.getCmdId() + "7", "scheduler-status", "Getting Basic information about installation"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureCheckUtil.getSchedulersAndItsStatus();
        }
    };
    public final Command meta_table_count = new LeafCommand(this.getCmdId() + "8", "meta-table-count", "Getting Basic information about installation"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            TroubleshootCmd.this.checkInputAndProcess(cmdStr, processIndex);
        }
    };
    public final Command table_schema = new LeafCommand(this.getCmdId() + "9", "table-schema", "Getting Basic information about installation"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DBTableTroubleshooting.checkDataTableSchema();
        }
    };
    public final Command update_archive_row = new LeafCommand(this.getCmdId() + "9", "update-archive-row", "Updating Min & Max Time of Archived Tables from its corresponding files"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DataBaseTroubleshooting.fromAndToTimeUpdateFromArchiveFiles();
        }
    };
    public final Command duplicate_report_profile = new LeafCommand(this.getCmdId() + "10", "duplicate-report-profiles", "To disable duplicate report profiles, execute directly\n To delete the duplicate report profiles, add delete in the end"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureUpdateUtil.deleteDuplicateReportProfiles(cmdStr, processIndex);
        }
    };
    public final Command add_missed_report_columns = new LeafCommand(this.getCmdId() + "11", "add-missed-report-columns", "To add the deleted/missed column details for the canned reports to AUDColumnConfiguration"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureUpdateUtil.addMissedColumns();
        }
    };
    public final Command create_default_profiles = new LeafCommand(this.getCmdId() + "12", "create_default_profiles", "Recreates default report and alert profiles which are missing"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureUpdateUtil.createDefaultProfiles(cmdStr, processIndex);
        }
    };
    public final Command create_analytics_profiles = new LeafCommand(this.getCmdId() + "13", "create_analytics_profiles", "Recreates analytics report and alert profile if any of the entries are missing"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureUpdateUtil.createAnalyticsProfile(cmdStr, processIndex);
        }
    };
    public final UserWorkHoursCmd userworkhours = new UserWorkHoursCmd(this.getCmdId() + "14", "userworkhours", "To recrunch or delete uncorrelated data");
    public final Command fix_processed_err = new LeafCommand(this.getCmdId() + "15", "fix_processed_err", "Fix processed_err Folder"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            SupportTroubleshooting.fixProcessedErr();
        }
    };
    public final Command add_missed_audgroup_entries = new LeafCommand(this.getCmdId() + "16", "add-missed-group-entries", "To add the deleted/missed action group details to AUDGroup"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureUpdateUtil.addMissedAUDGroupEntries();
        }
    };
    public final Command delete_duplicate_rows = new LeafCommand(this.getCmdId() + "17", "delete_duplicate_rows", "Delete duplicate rows from given tables."){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            TroubleshootCmd.this.checkInputAndProcess(cmdStr, processIndex);
        }
    };
    public final Command create_missed_crunch_table = new LeafCommand(this.getCmdId() + "18", "create_missed_crunch_table", " Recreates CrunchTemplateInstances if any of the entries are missing"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DataCruncher.createCrunchTemplateInstances((boolean)true);
        }
    };
    public final Command reset_report_default_column = new LeafCommand(this.getCmdId() + "17", "reset-report-def-col", "Delete duplicate rows from given tables."){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            TroubleshootCmd.this.checkInputAndProcess(cmdStr, processIndex);
        }
    };
    public final Command enable_uvw_batch_update = new LeafCommand(this.getCmdId() + "18", "enable-uvw-batch-update", " Recreates CrunchTemplateInstances if any of the entries are missing"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            FeatureUpdateUtil.enableUWHBatchUpdate();
        }
    };

    public TroubleshootCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, Command> childCmdList = new LinkedHashMap<String, Command>();
        childCmdList.put(this.help.getCmdId(), this.help);
        childCmdList.put(this.getting_basic_info.getCmdId(), this.getting_basic_info);
        childCmdList.put(this.no_data_available.getCmdId(), this.no_data_available);
        childCmdList.put(this.disk_space_check.getCmdId(), this.disk_space_check);
        childCmdList.put(this.raw_folder_analysis.getCmdId(), this.raw_folder_analysis);
        childCmdList.put(this.processed_folder_analysis.getCmdId(), this.processed_folder_analysis);
        childCmdList.put(this.feature_status.getCmdId(), this.feature_status);
        childCmdList.put(this.scheduler_status.getCmdId(), this.scheduler_status);
        childCmdList.put(this.meta_table_count.getCmdId(), this.meta_table_count);
        childCmdList.put(this.table_schema.getCmdId(), this.table_schema);
        childCmdList.put(this.update_archive_row.getCmdId(), this.update_archive_row);
        childCmdList.put(this.duplicate_report_profile.getCmdId(), this.duplicate_report_profile);
        childCmdList.put(this.add_missed_report_columns.getCmdId(), this.add_missed_report_columns);
        childCmdList.put(this.add_missed_audgroup_entries.getCmdId(), this.add_missed_audgroup_entries);
        childCmdList.put(this.create_default_profiles.getCmdId(), this.create_default_profiles);
        childCmdList.put(this.create_analytics_profiles.getCmdId(), this.create_analytics_profiles);
        childCmdList.put(this.userworkhours.getCmdId(), this.userworkhours);
        childCmdList.put(this.fix_processed_err.getCmdId(), this.fix_processed_err);
        childCmdList.put(this.delete_duplicate_rows.getCmdId(), this.delete_duplicate_rows);
        childCmdList.put(this.create_missed_crunch_table.getCmdId(), this.create_missed_crunch_table);
        childCmdList.put(this.reset_report_default_column.getCmdId(), this.reset_report_default_column);
        childCmdList.put(this.enable_uvw_batch_update.getCmdId(), this.enable_uvw_batch_update);
        this.setChildCmdList(childCmdList);
    }

    private boolean checkInputAndProcess(String[] cmdStr, int processIndex) throws IOException {
        boolean isValid = true;
        int len = cmdStr.length;
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String subCommand = cmdStr[1];
        try {
            if (subCommand.equalsIgnoreCase("meta-table-count")) {
                String tableName = "AUDLogonInfo";
                Long endTime = System.currentTimeMillis();
                Long startTime = endTime - 2592000L;
                if (len == 5) {
                    tableName = cmdStr[2];
                    startTime = sdf.parse(cmdStr[3]).getTime();
                    endTime = sdf.parse(cmdStr[4]).getTime();
                } else if (len == 3) {
                    tableName = cmdStr[2];
                }
                SupportTroubleshooting.getTableCount(tableName, startTime, endTime);
            } else if (subCommand.equalsIgnoreCase("delete_duplicate_rows")) {
                String baseTableName = cmdStr[2];
                SupportTroubleshooting.deleteDuplicateRows(baseTableName, "TIME_GENERATED,RECORD_NUMBER", "UNIQUE_ID");
            } else if (subCommand.equalsIgnoreCase("reset-report-def-col")) {
                Long reportId = Long.parseLong(cmdStr[2]);
                FeatureUpdateUtil.resetDefaultVisibleColumns(reportId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isValid = false;
        }
        return isValid;
    }
}

