/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline.util;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.UniqueValueGeneration;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.mfw.logging.LoggerUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.backupdata.RestoreUtil;
import com.adventnet.sym.adsm.common.server.commandline.CmdUtil;
import com.adventnet.sym.adsm.common.server.commandline.IOHandler;
import com.adventnet.sym.adsm.common.server.commandline.util.SupportTroubleshooting;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.zoho.db.scanner.util.ExecutorPool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class DataBaseTroubleshooting {
    private static Logger _logger = Logger.getLogger("Troubleshooting");
    protected static String DB_NAME = CommonUtil.getDBServerName();
    private static IOHandler ioHandler = CmdUtil.ioHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void corruptionCheck() {
        try {
            String query = "select tablename from pg_tables where schemaname='public'";
            String columnName = "tablename";
            ArrayList tableList = QueryUtil.getRowsForCustomQuery((String)query, (String)columnName);
            int threadPoolCount = Runtime.getRuntime().availableProcessors();
            ExecutorPool executorPool = new ExecutorPool(threadPoolCount *= 2);
            StringBuilder sb = new StringBuilder();
            try {
                int i = 0;
                for (String table : tableList) {
                    executorPool.submitTaskForWorker((Callable)new SupportTroubleshooting.CheckTableHealth(table, _logger, tableList.size(), ++i, sb));
                }
                executorPool.waitForTaskCompletion();
            }
            catch (Exception e) {
                executorPool.waitForWorkerPoolShutdown();
            }
            finally {
                String res = sb.toString();
                res = res == null || res.equals("") ? "Everything is OK for initial Check\n" : "The Following Table(s) has/have problem in the preliminary test." + res + "\n";
                ioHandler.print(_logger, res);
                executorPool.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void deleteArchiveData(String[] cmdStr, int processIndex) {
        try {
            int cmdLen = cmdStr.length;
            _logger.info("Going to delete Archive data... cmdLen :: " + cmdLen);
            if (cmdLen == 4 || cmdLen == 5) {
                DataObject dObj;
                String operator = cmdStr[2];
                Criteria crit = SupportTroubleshooting.getdeleteArchiveDataCriteria(operator, cmdStr);
                if (crit != null && !(dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(SupportTroubleshooting.tABLE_BACKUP_META_TABLE, crit)).isEmpty()) {
                    _logger.info("dObj size:: " + dObj.size(SupportTroubleshooting.tABLE_BACKUP_META_TABLE));
                    ArrayList<String> deletedFiles = new ArrayList<String>();
                    Iterator iter = dObj.getRows(SupportTroubleshooting.tABLE_BACKUP_META_TABLE);
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        String dirName = (String)row.get("BASE_DB_BACKUP_DIRECTORY");
                        String fileName = (String)row.get("FILE_NAME");
                        File file = new File(dirName + fileName);
                        if (file.delete()) {
                            deletedFiles.add(fileName);
                            _logger.info("Deleted File Successfully :: " + dirName + fileName);
                            continue;
                        }
                        _logger.severe("Error :: Unable to delete file :: " + dirName + fileName);
                    }
                    if (!deletedFiles.isEmpty()) {
                        Criteria deleteCrit = new Criteria(Column.getColumn((String)SupportTroubleshooting.tABLE_BACKUP_META_TABLE, (String)"FILE_NAME"), (Object)deletedFiles.toArray(new String[deletedFiles.size()]), 8);
                        _logger.info("Going to Delete Entries from Table - No of files Deleted :: " + deletedFiles.size() + " deleteCrit :: " + deleteCrit);
                        DataAccess.delete((Criteria)deleteCrit);
                    }
                }
            } else {
                _logger.info("Incorrect cmd to Delete Archive Files!!!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fromAndToTimeUpdateFromArchiveFiles() {
        try {
            DataObject dObj = DataAccess.get((String)"AUDArchiveConfig", (Criteria)null);
            Row row = dObj.getRow("AUDArchiveConfig");
            String folderName = (String)row.get("BASE_ARCHIVE_DIRECTORY") + File.separator + "tableBackup";
            DataBaseTroubleshooting.fromAndToTimeUpdateFromArchiveFiles(folderName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromAndToTimeUpdateFromArchiveFiles(String folderName) {
        block28: {
            _logger.info(SupportTroubleshooting.getBanner("Updating FROM & TO value of Archived Tables from Archived Files"));
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = null;
            try {
                ioHandler.print(_logger, "Folder Name " + folderName);
                File folder = new File(folderName);
                if (!folder.isDirectory()) break block28;
                int count = folder.list().length;
                ioHandler.print(_logger, "TOTAL FILES COUNT is " + count);
                if (count > 0) {
                    DataObject newdO = CommonUtil.getPersistenceLite().constructDataObject();
                    DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDBackupMetaTable", (Criteria)null);
                    File[] listOfFiles = folder.listFiles();
                    for (int i = 0; i < listOfFiles.length; ++i) {
                        if (listOfFiles[i].isFile()) {
                            String fileName = listOfFiles[i].getName();
                            if (fileName.indexOf(".zip") != -1) {
                                Criteria crit = new Criteria(Column.getColumn((String)"AUDBackupMetaTable", (String)"FILE_NAME"), (Object)fileName, 0);
                                boolean isUpdate = true;
                                Row row = dObj.getRow("AUDBackupMetaTable", crit);
                                if (row == null) {
                                    row = new Row("AUDBackupMetaTable");
                                    isUpdate = false;
                                }
                                row.set("LOOKUP_TABLENAME", (Object)fileName.split(".zip")[0]);
                                row.set("FILE_NAME", (Object)fileName);
                                row.set("IS_REGENERATE_DATA", (Object)false);
                                row.set("TABLE_NAME", (Object)fileName.split("_")[0]);
                                row.set("BASE_DB_BACKUP_DIRECTORY", (Object)folderName);
                                _logger.info("TABLE NAME :: " + row.get("LOOKUP_TABLENAME"));
                                ioHandler.print(_logger, "FILE_NAME  :: " + fileName);
                                _logger.info("BASE_DB_BACKUP_DIRECTORY :: " + folderName);
                                File file = null;
                                try {
                                    boolean last;
                                    RestoreUtil.unZip((String)fileName, (String)folderName, null);
                                    String csvName = folderName + File.separator + fileName.replaceAll("zip", "csv");
                                    file = new File(csvName);
                                    reader = new BufferedReader(new FileReader(file));
                                    Object firstLine = null;
                                    Object lastLine = null;
                                    String line = reader.readLine();
                                    long minTime = 0L;
                                    long maxTime = 0L;
                                    int indexVal = SupportTroubleshooting.getIndexVal(fileName.split("_")[0]);
                                    boolean first = true;
                                    boolean bl = last = line == null;
                                    while (!last) {
                                        String next = reader.readLine();
                                        last = next == null;
                                        String[] splitVal = line.split("\t");
                                        if (first) {
                                            row.set("START_INDEX", (Object)splitVal[0]);
                                            minTime = Long.parseLong(splitVal[indexVal]);
                                            maxTime = Long.parseLong(splitVal[indexVal]);
                                        } else {
                                            long val = Long.parseLong(splitVal[indexVal]);
                                            if (val > maxTime) {
                                                maxTime = val;
                                            } else if (val < minTime) {
                                                minTime = val;
                                            }
                                            if (last) {
                                                row.set("END_INDEX", (Object)splitVal[0]);
                                            }
                                        }
                                        first = false;
                                        line = next;
                                    }
                                    row.set("START_TIME", (Object)minTime);
                                    row.set("END_TIME", (Object)maxTime);
                                    _logger.info("Updated Row is " + row);
                                    if (isUpdate) {
                                        newdO.updateRow(row);
                                    } else {
                                        newdO.addRow(row);
                                    }
                                    reader.close();
                                    _logger.info("CSV File Delete Status :: " + file.delete());
                                    continue;
                                }
                                catch (Exception ex) {
                                    _logger.info("Exception while getting value from file :: " + fileName + "\n Error is " + ex.getMessage());
                                    continue;
                                }
                                finally {
                                    try {
                                        if (reader != null) {
                                            reader.close();
                                        }
                                        file.delete();
                                    }
                                    catch (Exception ex1) {
                                        ex1.printStackTrace();
                                    }
                                }
                            }
                            _logger.info("We only processed zip file. File Name is " + fileName);
                            continue;
                        }
                        _logger.info("It is not a File . " + listOfFiles[i].getName());
                    }
                    DataAccess.add((DataObject)newdO);
                    break block28;
                }
                ioHandler.print(_logger, "The Given Directory has no files");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void getDBSize() {
        ioHandler.print(_logger, "Getting the database size\n");
        StringBuilder sb = new StringBuilder();
        try {
            String query = "SELECT current_database() as DB_NAME, pg_size_pretty( pg_database_size(current_database()) ) as DB_SIZE;";
            if (DB_NAME.equals("mssql")) {
                query = "SELECT DB_NAME(),SUM(SizeMB) as DB_SIZE FROM (SELECT DB_NAME(database_id) AS DatabaseName,Name AS Logical_Name,Physical_Name,(size * 8) / 1024 SizeMB FROM sys.master_files WHERE DB_NAME(database_id) = db_name()) AS TEMP";
            } else if (DB_NAME.equals("mysql")) {
                query = "SELECT table_schema AS 'Database', SUM(data_length + index_length) / 1024 / 1024 AS 'Size (MB)' FROM information_schema.TABLES where table_schema = 'adap' GROUP BY table_schema";
            }
            sb = SupportTroubleshooting.printQueryOutput(query);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ioHandler.print(_logger, sb.toString());
    }

    public static void gettingDBConfigSettngs() {
        _logger.info(SupportTroubleshooting.getBanner("Get Configured Database defualt Settings."));
        StringBuilder sb = new StringBuilder();
        try {
            String query = "select name, setting, unit, category from pg_settings";
            if (DB_NAME.equals("mssql")) {
                query = " select a.*,physical_name, db_name(b.database_id),serverproperty('edition') as 'Edition',serverproperty('productversion') as 'Version',(size*8) 'Size',max_size, growth  from sys.databases a join sys.master_files b on a.database_id=b.database_id where db_name(a.database_id)= db_name()";
            }
            sb = SupportTroubleshooting.printQueryOutput(query);
            _logger.info(sb.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void getTop10SpaceOccupiedTables() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nGoing to get Top 10 space occupied tables in the database");
        String query = "select schemaname as table_schema, relname as table_name, pg_size_pretty(pg_total_relation_size(relid)) as total_size, pg_size_pretty(pg_relation_size(relid)) as data_size, pg_size_pretty(pg_total_relation_size(relid) - pg_relation_size(relid)) as external_size from pg_catalog.pg_statio_user_tables order by pg_total_relation_size(relid) desc, pg_relation_size(relid) desc limit 10;";
        try {
            if (DB_NAME.equals("mssql")) {
                query = "select top 10 name=object_schema_name(object_id) + '.' + object_name(object_id), rows=sum(case when index_id < 2 then row_count else 0 end), reserved_kb=8*sum(reserved_page_count), data_kb=8*sum( case when index_id<2 then in_row_data_page_count + lob_used_page_count + row_overflow_used_page_count else lob_used_page_count + row_overflow_used_page_count end ) , index_kb=8*(sum(used_page_count) - sum( case when index_id<2 then in_row_data_page_count + lob_used_page_count + row_overflow_used_page_count else lob_used_page_count + row_overflow_used_page_count end ) ) , unused_kb=8*sum(reserved_page_count-used_page_count) from sys.dm_db_partition_stats where object_id > 1024 group by object_id order by rows desc";
            }
            sb = SupportTroubleshooting.printQueryOutput(query);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            sb.append("\nError while getting Top 10 Space occupied tables in the Database. \n\tError : ").append(ex.getMessage()).append("\n");
        }
        ioHandler.print(_logger, sb.toString());
    }

    public static void createTable(String[] cmdStr, int processIndex) throws Exception {
        String tableName = null;
        String primaryKeyColumnName = null;
        String primaryKeyName = null;
        String seqGenName = null;
        int colSize = 0;
        String[] colNames = new String[]{};
        String[] colDesc = new String[]{};
        String[] dataTypeStrArr = new String[]{};
        Boolean[] isNullArr = new Boolean[]{};
        Integer[] maxSizeArr = new Integer[]{};
        try {
            String fileHome = System.getProperty("server.home");
            Properties prop = new Properties();
            File file = new File(fileHome + File.separator + "createTable.properties");
            if (file.exists()) {
                prop.load(new FileInputStream(file));
                tableName = prop.getProperty("TABLE_NAME");
                String columnNames = prop.getProperty("COLUMN_NAME");
                String columnDescriptions = prop.getProperty("COLUMN_DESCRIPTION");
                String maxSize = prop.getProperty("MAX_SIZE");
                String displayName = prop.getProperty("DISPLAY_NAME");
                String isNullable = prop.getProperty("IS_NULLABLE");
                String dataType = prop.getProperty("DATA_TYPE");
                primaryKeyName = prop.getProperty("PRIMARY_KEY_NAME");
                primaryKeyColumnName = prop.getProperty("PRIMARY_KEY_COLUMN_NAME");
                seqGenName = prop.getProperty("SEQGEN_NAME");
                colNames = columnNames.split(",");
                colSize = colNames.length;
                colDesc = columnDescriptions.split(",");
                String[] maxSizeStrArr = maxSize.split(",");
                maxSizeArr = new Integer[colSize];
                String[] dispNames = displayName.split(",");
                String[] isNullStrArr = isNullable.split(",");
                isNullArr = new Boolean[colSize];
                dataTypeStrArr = dataType.split(",");
                for (int i = 0; i < colSize; ++i) {
                    maxSizeArr[i] = Integer.valueOf(maxSizeStrArr[i]);
                    isNullArr[i] = Boolean.valueOf(isNullStrArr[i]);
                    if (dataTypeStrArr[i].equalsIgnoreCase("NCHAR")) {
                        dataTypeStrArr[i] = "NCHAR";
                        continue;
                    }
                    if (dataTypeStrArr[i].equalsIgnoreCase("BIGINT")) {
                        dataTypeStrArr[i] = "BIGINT";
                        continue;
                    }
                    if (!dataTypeStrArr[i].equalsIgnoreCase("INTEGER")) continue;
                    dataTypeStrArr[i] = "INTEGER";
                }
            }
        }
        catch (Exception ex) {
            _logger.info("Exception while reading the file");
            ex.printStackTrace();
        }
        _logger.info("Column Size = " + colSize);
        try {
            TableDefinition tableDef = new TableDefinition();
            tableDef = new TableDefinition();
            tableDef.setTableName(tableName);
            ColumnDefinition coldef = null;
            for (int i = 0; i < colSize; ++i) {
                coldef = new ColumnDefinition();
                coldef.setColumnName(colNames[i]);
                if (colNames[i] == null) {
                    _logger.info("Column Name for " + i + "th column is Null");
                }
                coldef.setDescription(colDesc[i]);
                if (colDesc[i] == null) {
                    _logger.info("Column Desc for " + i + "th column is Null");
                }
                coldef.setDataType(dataTypeStrArr[i]);
                if (dataTypeStrArr[i] == null) {
                    _logger.info("Column data type for " + i + "th column is Null");
                }
                if (maxSizeArr[i] > 0) {
                    coldef.setMaxLength(maxSizeArr[i].intValue());
                }
                if (isNullArr[i] != null) {
                    coldef.setNullable(isNullArr[i].booleanValue());
                }
                if (i == 0) {
                    coldef.setUnique(false);
                    UniqueValueGeneration generator = new UniqueValueGeneration();
                    generator.setGeneratorName(seqGenName);
                    if (seqGenName == null) {
                        _logger.info("SeqGen Name for " + i + "th column is Null");
                    }
                    coldef.setUniqueValueGeneration(generator);
                }
                tableDef.addColumnDefinition(coldef);
                _logger.info("Column Values Set for " + i + "th column");
            }
            _logger.info("Starting pk set");
            PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
            pkDef.setName(primaryKeyName);
            if (primaryKeyName == null) {
                _logger.info("primary key is Null");
            }
            pkDef.addColumnName(primaryKeyColumnName);
            if (primaryKeyColumnName == null) {
                _logger.info("primary key col name is Null");
            }
            pkDef.setTableName(tableName);
            tableDef.setPrimaryKey(pkDef);
            try {
                QueryUtil.executeSingleQuery((String)"DROP Table", (String)("DROP TABLE " + tableName));
                _logger.info("Successfully deleted table - " + tableName);
            }
            catch (Exception ex) {
                _logger.info("Exception in deleting table - " + tableName);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).createTable("adap", tableDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            _logger.info("Exception message :  " + message);
            throw new Exception(e);
        }
    }

    public static void removeDuplicatePK(String givenName) {
        try {
            String tableName = DataBaseTroubleshooting.getExactTableName(givenName);
            if (tableName != null) {
                _logger.info("TableName to delete the duplicate Entries " + tableName);
                TableDefinition tableDefinition = MetaDataUtil.getTableDefinitionByName((String)tableName);
                PrimaryKeyDefinition pkDefn = tableDefinition.getPrimaryKey();
                _logger.info("Primary key name of the table " + pkDefn.getName());
                String query = DataBaseTroubleshooting.getRemoveDuplicateQuery(tableName, pkDefn.getName());
                _logger.info("Query to delete the duplicates " + query);
                QueryUtil.executeUpdate((String)query);
                _logger.info("Delete duplicated Rows successfully in the table " + tableName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            _logger.info("Exception Message : " + ex.getMessage());
        }
    }

    public static String getRemoveDuplicateQuery(String tableName, String pkColumnName) {
        return "DELETE FROM " + tableName + " a using " + tableName + " b WHERE a." + pkColumnName + "=b." + pkColumnName + " and a.ctid > b.ctid";
    }

    private static String getExactTableName(String name) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"TableDetails", (String)"TABLE_NAME"), (Object)name, 0, false);
            DataObject dObj = CommonUtil.getPersistenceLite().get("TableDetails", crit);
            if (dObj.size("TableDetails") > 0) {
                Row row = dObj.getRow("TableDetails");
                return (String)row.get("TABLE_NAME");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    static {
        try {
            String logFileName = "SupportTroubleshooting";
            LoggerUtil.initLog((String)logFileName, (long)0L, (boolean)false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

