/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.mfw.logging.LoggerUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.commandline.CmdUtil;
import com.adventnet.sym.adsm.common.server.commandline.IOHandler;
import com.adventnet.sym.adsm.common.server.commandline.util.SupportTroubleshooting;
import com.adventnet.sym.adsm.common.server.paramtablecache.TableFactory;
import com.adventnet.sym.adsm.common.server.paramtablecache.TableNames;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.AgeFileFilter;

public class FeatureCheckUtil {
    private static Logger _logger = Logger.getLogger("Troubleshooting");
    protected static String DB_NAME = CommonUtil.getDBServerName();
    private static IOHandler ioHandler = CmdUtil.ioHandler();
    public static String bcp_ERR_PATTERN = "SQLState = (.*?), NativeError = (.*[0-9])";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIfSyslogTCPPortListeningEvents() {
        ServerSocket serverSocket = null;
        Socket clientSocket = null;
        try {
            String syslogPort = TableFactory.getCache((TableNames)TableNames.FILECONFIGPARAM).get("TCPSyslogPort");
            serverSocket = new ServerSocket(Integer.parseInt(syslogPort));
            ioHandler.print(_logger, "Started listening to TCP Port {0} " + syslogPort + "\n");
            ioHandler.flush();
            int i = 1;
            while (i <= 100) {
                if (serverSocket.isClosed()) continue;
                clientSocket = serverSocket.accept();
                ioHandler.print(_logger, clientSocket.getInetAddress().getHostAddress() + "\t");
                BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                String inputLine = in.readLine();
                ioHandler.print(_logger, inputLine + "\n");
                ioHandler.flush();
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
                if (clientSocket != null) {
                    clientSocket.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIfSyslogUDPPortListeningEvents() {
        DatagramSocket sock = null;
        DatagramPacket incoming = null;
        try {
            String syslogPort = TableFactory.getCache((TableNames)TableNames.FILECONFIGPARAM).get("UDPSyslogPort");
            sock = new DatagramSocket(Integer.parseInt(syslogPort));
            ioHandler.print(_logger, "Started listening to UDP Port {0} " + syslogPort + "\n");
            ioHandler.flush();
            byte[] buffer = new byte[65536];
            incoming = new DatagramPacket(buffer, buffer.length);
            for (int i = 1; i <= 100; ++i) {
                if (!sock.isClosed()) {
                    sock.receive(incoming);
                    ioHandler.print(_logger, incoming.getAddress().getHostAddress() + "\t");
                    byte[] data = incoming.getData();
                    String s = new String(data, 0, incoming.getLength());
                    ioHandler.print(_logger, s + "\n");
                }
                ioHandler.flush();
            }
            FeatureCheckUtil.closeSocket(sock);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            FeatureCheckUtil.closeSocket(sock);
        }
    }

    private static void closeSocket(DatagramSocket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void checkRPDisabled() {
        StringBuilder sb = new StringBuilder();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)0, 1);
            DataObject dObj = CommonUtil.getPersistenceLite().get("AUDMonitor", crit);
            ArrayList domainList = DomainHandler.getConfiguredList((Long)1L);
            sb.append("\nCheck enabeld Defualt Report Profile.");
            sb.append(String.format("\n%40s%30s%30s", "Domain Name", "Total Count", "Enabled Count"));
            for (int i = 0; i < domainList.size(); ++i) {
                Properties prop = (Properties)domainList.get(i);
                String domainName = prop.getProperty("DOMAIN_NAME");
                Iterator iter = dObj.getRows("AUDMonitor", new Criteria(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                int totalCount = 0;
                int totalEnabledCount = 0;
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    Boolean isEnabled = (Boolean)row.get("IS_ENABLED");
                    if (isEnabled.booleanValue()) {
                        ++totalEnabledCount;
                    }
                    ++totalCount;
                }
                sb.append(String.format("\n%40s%30d%30d", domainName, totalCount, totalEnabledCount));
            }
            ioHandler.print(_logger, sb.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void checkUnwantedFilesAvailable() {
        StringBuilder sb = new StringBuilder();
        String libFolderHome = System.getProperty("server.home") + File.separator + "lib";
        File libFolder = new File(libFolderHome);
        boolean isDupJarAvailable = false;
        sb.append("Check duplicate / unwanted jars available in lib folder\n");
        for (File file : libFolder.listFiles()) {
            String fileName = file.getName();
            if (fileName.contains("AdventnetADAPServer") && !fileName.equals("AdventnetADAPServer.jar") || fileName.contains("AdventNetADAPClient") && !fileName.equals("AdventNetADAPClient.jar") || fileName.contains("AdvPersistence") && !fileName.equals("AdvPersistence.jar")) {
                isDupJarAvailable = true;
                sb.append(fileName).append("\n");
            }
            if (!fileName.contains("postgresql_jdbc4.jar") || !fileName.contains("jtds-1.2.4.jar")) continue;
            isDupJarAvailable = true;
            sb.append(fileName).append("\n");
        }
        if (!isDupJarAvailable) {
            sb.append("\t Everything is fine \t\n");
        }
        ioHandler.print(_logger, sb.toString());
    }

    public static void duplicateFolderCheck() {
        String eventData = System.getProperty("server.home") + File.separator + "eventdata";
        StringBuilder sb = new StringBuilder();
        try {
            File directory = new File(eventData);
            File[] listFiles = directory.listFiles();
            for (int i = 0; i < listFiles.length; ++i) {
                File file = listFiles[i];
                String folderName = file.getName();
                if (folderName.equals("raw") || folderName.equals("processed") || folderName.equals("migration")) continue;
                sb.append("\t*\t").append(folderName).append("\n");
            }
            String res = sb.toString();
            res = res != null && !res.equals("") ? "The following renamed folders are available inside eventdata directory except raw and processed folder. \n" + res : "No renamed folders under eventdata directory\n";
            ioHandler.print(_logger, res);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ioHandler.print(_logger, "Exception while checking duplicate Folder under eventdata :: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getObjectCountPerDomain() {
        _logger.info(SupportTroubleshooting.getBanner("Getting Object Counts per Domain"));
        String query = "select domain_name ,object_name, count(*) as count from ((select 'Contact' as object_name,domain_name from ADSMContactGeneralDetails) union all (select 'Site' as object_name,domain_name from ADSMSiteDetails) union all (select 'OrganizationalUnit' as object_name,domain_name from ADSMOUDetails) union all (select 'Group' as object_name,domain_name from ADSMGroupGeneralDetails) union all (select 'Computer' as object_name,domain_name from ADSMComputerGeneralDetails) union all (select 'Container' as object_name,domain_name from ADSMContainerDetails) union all (select 'User' as object_name,domain_name from ADSMUserGeneralDetails) union all (select 'Printer' as object_name,domain_name from ADSMPrinterGeneralDetails) union all (select 'GPO' as object_name,domain_name from ADSMGPODetails)) as a group by domain_name,object_name order by domain_name, object_name asc";
        Connection conn = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            conn = RelationalAPI.getInstance().getConnection();
            statement = conn.createStatement();
            resultSet = QueryUtil.executeQuery((String)"Getting Object Details based on Domain", (Statement)statement, (String)query);
            StringBuilder sb = new StringBuilder();
            sb.append("\nGetting object details based on domain \n");
            while (resultSet.next()) {
                sb.append(String.format("%40s %40s %d\n", resultSet.getString("domain_name"), resultSet.getString("object_name"), resultSet.getInt("count")));
            }
            ioHandler.print(_logger, sb.toString());
            QueryUtil.close((ResultSet)resultSet, (Statement)statement, (Connection)conn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            QueryUtil.close(resultSet, (Statement)statement, (Connection)conn);
        }
    }

    public static void getSchedulersAndItsStatus() {
        ioHandler.print(_logger, SupportTroubleshooting.getBanner("To get ADAudit Plus installed Machine Details"));
        StringBuilder sb = new StringBuilder();
        try {
            String query = "select  replace(schedule_name,'adap.Schedule.schedule_name.','') as schedule_name,schedule_start_time, schedule_finish_time,scheduled_time from schedule_audit where audit_id in (select max(audit_id) from schedule_audit where task_name not in('archive-task1','FWBackupTask','EventUpdate','ReportScheduler','MSEventUpdate','METrackTask') group by task_name) order by schedule_name;";
            sb = SupportTroubleshooting.printQueryOutput(query);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            sb.append("Error while getting Schedulers Details . Error is " + ex.getMessage());
        }
        ioHandler.print(_logger, sb.toString());
    }

    public static void isBCPAvailable() {
        if (DB_NAME.equals("mssql")) {
            String home = System.getProperty("server.home") + File.separator + "bin";
            File bcpexe = new File(home + File.separator + "bcp.exe");
            File bcprll = new File(home + File.separator + "bcp.rll");
            if (!bcpexe.exists() && !bcprll.exists()) {
                ioHandler.print(_logger, "\nbcp.exe & bcp.rll are not available in " + home + "\n");
            } else {
                ioHandler.print(_logger, "\nbcp.exe & bcp.rll are available in " + home + "\n");
            }
        } else {
            ioHandler.print(_logger, "\nBackend Database is " + DB_NAME + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void isBCPWorkingFine() {
        String bcpError = "BCP OK";
        BufferedReader in = null;
        try {
            if (DB_NAME.equals("mssql")) {
                Process p = Runtime.getRuntime().exec("cmd /c bcp.exe -?");
                in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String bcpOut = in.readLine();
                if (bcpOut == null) {
                    bcpError = "\nPlease install proper SQL Native Client (or) Microsoft ODBC Driver for SQL Server\n";
                    ioHandler.print(_logger, bcpError);
                } else {
                    ioHandler.print(_logger, "\n BCP Working fine\n");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    public static void processedFilesCheck() {
        String home = System.getProperty("server.home") + File.separator + "eventdata" + File.separator + "processed";
        File directory = new File(home);
        ioHandler.print(_logger, "\nAll Files count under processed Folder " + directory.listFiles().length);
        FeatureCheckUtil.displayFiles(directory, (FileFilter)new AgeFileFilter(SupportTroubleshooting.getCutOffDate(), false));
        if (DB_NAME.equals("mssql")) {
            FeatureCheckUtil.checkBCPErrors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkBCPErrors() {
        FileInputStream fstream = null;
        try {
            String logsHome = System.getProperty("server.home") + File.separator + "logs";
            Pattern pattern = Pattern.compile(bcp_ERR_PATTERN);
            File f = new File(logsHome);
            File[] listOfTmpFiles = f.listFiles();
            HashMap<String, Integer> fullMap = new HashMap<String, Integer>();
            for (File listOfTmpFile : listOfTmpFiles) {
                String strLine;
                String tmpFile;
                if (listOfTmpFile.isDirectory() || !(tmpFile = listOfTmpFile.getCanonicalPath()).contains("ReportLog_")) continue;
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                fstream = new FileInputStream(tmpFile);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fstream, "UTF-8"));
                while ((strLine = br.readLine()) != null) {
                    Matcher matcher = pattern.matcher(strLine);
                    while (matcher.find()) {
                        String str1 = matcher.group(1);
                        String str2 = matcher.group(2);
                        str1 = str1.replace("[", "").replace("]", "");
                        str2 = str2.replace("[", "").replace("]", "");
                        if (map.get(str1 + "_" + str2) == null) {
                            map.put(str1 + "_" + str2, 1);
                        } else {
                            map.put(str1 + "_" + str2, (Integer)map.get(str1 + "_" + str2) + 1);
                        }
                        if (fullMap.get(str1 + "_" + str2) == null) {
                            fullMap.put(str1 + "_" + str2, 1);
                            continue;
                        }
                        fullMap.put(str1 + "_" + str2, (Integer)fullMap.get(str1 + "_" + str2) + 1);
                    }
                }
                if (map.size() > 0) {
                    ioHandler.print(_logger, listOfTmpFile.getName() + "\t\t" + map);
                }
                br.close();
            }
            Set strValue = fullMap.keySet();
            int i = 0;
            for (String key : strValue) {
                ioHandler.print(_logger, String.format("%40s : %s\n", key, fullMap.get(key)));
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                fstream.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void displayFiles(File directory, FileFilter fileFilter) {
        File[] files;
        int totalFileCount = 0;
        HashMap<String, Integer> categoryCount = new HashMap<String, Integer>();
        for (File file : files = directory.listFiles(fileFilter)) {
            String fileName = file.getName();
            String[] tableName = fileName.split("_");
            int count = categoryCount.get(tableName[0]) != null ? (Integer)categoryCount.get(tableName[0]) : 0;
            categoryCount.put(tableName[0], count + 1);
            ++totalFileCount;
        }
        ioHandler.print(_logger, "\nFiles count under processed Folder after Yesterday 12a.m. is " + totalFileCount);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n\n%48s\n%48s\n", "Table Based Processed File(s)", "-----------------"));
        categoryCount = SupportTroubleshooting.sortByValue(categoryCount);
        Set<String> key = categoryCount.keySet();
        Iterator<String> iterator = key.iterator();
        while (iterator.hasNext()) {
            String obj;
            String tableName = obj = iterator.next();
            sb.append(String.format("%40s : %s\n", tableName, categoryCount.get(tableName)));
        }
        sb.append("\n\n");
        ioHandler.print(_logger, sb.toString());
    }

    public static void rawFilesCheck(boolean isAnalyzeNeeded) {
        String home = System.getProperty("server.home") + File.separator + "eventdata" + File.separator + "raw";
        File directory = new File(home);
        ioHandler.print(_logger, "\nAll Files count under raw Folder " + directory.listFiles().length);
        if (isAnalyzeNeeded) {
            SupportTroubleshooting.eventsBasedCount(directory, (FileFilter)new AgeFileFilter(SupportTroubleshooting.getCutOffDate(), false));
        }
    }

    public static void getSizeOfSIEMLogFoler() {
        _logger.info(SupportTroubleshooting.getBanner("Getting SIEM related folders size and files count"));
        ioHandler.print("Getting SIEM related folder(s) size and files count");
        try {
            String prodHome = System.getProperty("server.home") + File.separator;
            String folderName = "splunk_temp";
            SupportTroubleshooting.getSizeOfFolder(prodHome, folderName);
            folderName = "syslog_temp";
            SupportTroubleshooting.getSizeOfFolder(prodHome, folderName);
        }
        catch (Exception ex) {
            ioHandler.print(_logger, "Error while getting SIEM related folder(s) size and files count.");
        }
    }

    static {
        try {
            String logFileName = "SupportTroubleshooting";
            LoggerUtil.initLog((String)logFileName, (long)0L, (boolean)false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

