/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.commandline.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventManager;
import com.adventnet.sym.adsm.auditing.server.compliance.DataCruncher;
import com.adventnet.sym.adsm.auditing.server.fileaudit.synology.SynologyHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.userworkhours.UWHCrunchBookmarkHandler;
import com.adventnet.sym.adsm.auditing.server.userworkhours.UWHCrunchProcess;
import com.adventnet.sym.adsm.auditing.server.userworkhours.UWHCrunchQueryHandler;
import com.adventnet.sym.adsm.auditing.server.userworkhours.UWHCrunchUtil;
import com.adventnet.sym.adsm.auditing.server.userworkhours.UWHShiftHoursHandler;
import com.adventnet.sym.adsm.auditing.server.userworkhours.UWHUncorrelatedDataHandler;
import com.adventnet.sym.adsm.auditing.server.userworkhours.parser.DefaultLogonParser;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.commandline.CmdUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class UWHCmdUtil {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static int shiftStartTime = 0;
    public static int shiftEndTime = 9;
    private long ppmAppliedTime = 0L;
    public static long lastCorrelatedPairTime = -1L;
    private static UWHCmdUtil uwhCmdUtil = null;
    private UWHCrunchQueryHandler uwhCrunchQueryHandler = null;
    private UWHShiftHoursHandler uwhShiftHoursHandler = null;
    private UWHCrunchBookmarkHandler uwhCrunchBookmarkHandler = null;
    private UWHCrunchProcess uwhCrunchProcess = null;
    private UWHUncorrelatedDataHandler uwhUncorrelatedDataHandler = null;

    public UWHCmdUtil() {
        try {
            this.uwhCrunchQueryHandler = new UWHCrunchQueryHandler();
            this.uwhShiftHoursHandler = new UWHShiftHoursHandler();
            this.uwhCrunchBookmarkHandler = new UWHCrunchBookmarkHandler();
            this.uwhCrunchProcess = new UWHCrunchProcess();
            this.uwhUncorrelatedDataHandler = new UWHUncorrelatedDataHandler();
            shiftStartTime = Integer.parseInt(UWHCrunchUtil.getUserWorkHourParams((String)"ShiftStartTime"));
            shiftEndTime = Integer.parseInt(UWHCrunchUtil.getUserWorkHourParams((String)"ShiftEndTime"));
            this.ppmAppliedTime = Long.parseLong(UWHCrunchUtil.getUserWorkHourParams((String)"PPMAppliedTime"));
            Boolean bl = UWHCrunchUtil.getInstance().isEvtxEnabled();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UWHCmdUtil getInstance() {
        if (uwhCmdUtil != null) return uwhCmdUtil;
        Class<UWHCmdUtil> clazz = UWHCmdUtil.class;
        synchronized (UWHCmdUtil.class) {
            uwhCmdUtil = new UWHCmdUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return uwhCmdUtil;
        }
    }

    public void deleteUncorrelatedRows(String[] cmdStr, int processIndex) {
        int len = cmdStr.length;
        String startDate = "";
        String endDate = "";
        try {
            if (len > 4 && this.validateDate(cmdStr[3]).booleanValue() && this.validateDate(cmdStr[4]).booleanValue()) {
                long endTimeUnixTime;
                startDate = cmdStr[3] + "T00:00:00+00:00";
                endDate = cmdStr[4] + "T00:00:00+00:00";
                long startTimeUnixTime = SynologyHandler.getUnixTime((String)startDate) - (long)TimeUtil.getTimeZoneOffset();
                if (startTimeUnixTime > (endTimeUnixTime = SynologyHandler.getUnixTime((String)endDate) - (long)TimeUtil.getTimeZoneOffset())) {
                    Long tempVal = startTimeUnixTime;
                    startTimeUnixTime = endTimeUnixTime;
                    endTimeUnixTime = tempVal;
                }
                Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)startTimeUnixTime, 6);
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"END_TIME"), (Object)startTimeUnixTime, 4));
                crit = crit.or(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)0, 0));
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"), (Object)"AUDUserActiveTimeInfo", 0));
                DataObject dObj = DataAccess.get((String)"AUDMetaTable", (Criteria)crit);
                Iterator iter = dObj.getRows("AUDMetaTable");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    String underScoreTableName = (String)row.get("LOOKUP_TABLENAME");
                    StringBuilder deleteQuery = new StringBuilder();
                    deleteQuery = deleteQuery.append("DELETE FROM ");
                    deleteQuery = deleteQuery.append(underScoreTableName);
                    deleteQuery = deleteQuery.append(" WHERE TIME_GENERATED >= ");
                    deleteQuery = deleteQuery.append(startTimeUnixTime);
                    deleteQuery = deleteQuery.append(" AND TIME_GENERATED <= ");
                    deleteQuery = deleteQuery.append(endTimeUnixTime);
                    deleteQuery = deleteQuery.append(" AND TOTALHOURS = 0");
                    QueryUtil.executeSingleQuery((String)"", (String)deleteQuery.toString());
                }
            } else {
                CmdUtil.ioHandler().print("\n# Wrong Input! Kindly check the parameters for the command\n\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void selectiveRecrunching(String[] cmdStr, int processIndex) {
        int len = cmdStr.length;
        String startDate = "";
        String endDate = "";
        String tableName = "AUDLogonLogoffInfo";
        try {
            if (len > 3 && this.validateDate(cmdStr[3]).booleanValue()) {
                startDate = cmdStr[3] + "T00:00:00+00:00";
                long startTimeUnixTime = SynologyHandler.getUnixTime((String)startDate) - (long)TimeUtil.getTimeZoneOffset();
                this.deleteOldCrunchedData(startTimeUnixTime);
                this.selectiveCrunchLogonData(startTimeUnixTime, tableName);
            } else {
                CmdUtil.ioHandler().print("\n# Wrong Input! Kindly check the parameters for the command\n\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Boolean validateDate(String date) {
        String regex = "\\d{4}-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])";
        if (date.matches(regex)) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectiveCrunchLogonData(long startTimeUnixTime, String tableName) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            String query = this.getGroupByQuery(startTimeUnixTime, tableName);
            resultSet = QueryUtil.executeQuery((String)"LogonCrunch", (Statement)statement, (String)query);
            LinkedList<HashMap<String, String>> dataQueue = new LinkedList<HashMap<String, String>>();
            while (resultSet.next()) {
                String userName = resultSet.getObject(1) != null ? resultSet.getObject(1).toString() : "";
                String computerName = resultSet.getObject(2) != null ? resultSet.getObject(2).toString() : "";
                String domainName = resultSet.getObject(3) != null ? resultSet.getObject(3).toString() : "";
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("USER_NAME", userName);
                map.put("COMPUTER_NAME", computerName);
                map.put("DOMAIN_NAME", domainName);
                dataQueue.add(map);
            }
            this.executeCrunchAction(startTimeUnixTime, tableName, dataQueue);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCrunchAction(long startTimeUnixTime, String tableName, Queue<HashMap<String, String>> dataQueue) {
        try {
            for (int j = dataQueue.size(); j > 0; --j) {
                HashMap<String, String> map = dataQueue.remove();
                String userName = map.get("USER_NAME");
                String computerName = map.get("COMPUTER_NAME");
                String domainName = map.get("DOMAIN_NAME");
                String crunchQuery = this.getCrunchQuery(userName, computerName, domainName, startTimeUnixTime, tableName);
                Connection connection = null;
                ResultSet resultSet = null;
                PreparedStatement pstatement = null;
                try {
                    RelationalAPI relAPI = RelationalAPI.getInstance();
                    connection = relAPI.getConnection();
                    pstatement = connection.prepareStatement(crunchQuery);
                    long queryTime = System.currentTimeMillis();
                    resultSet = pstatement.executeQuery();
                    queryTime = System.currentTimeMillis() - queryTime;
                    HashMap userLastUncorrelatedRowMap = this.uwhUncorrelatedDataHandler.getUserLastUncorrelatedEventsForUtil(userName, computerName, domainName, Boolean.valueOf(true), this.uwhCrunchProcess, startTimeUnixTime);
                    if (userLastUncorrelatedRowMap.isEmpty() && this.isOldUncorrelationMethodNeeded().booleanValue() && (userLastUncorrelatedRowMap = UWHCrunchUtil.getInstance().getUserLastUncorrelatedEvents(userName, computerName, domainName, Boolean.valueOf(true), this.uwhCrunchProcess)).isEmpty() && !UWHCrunchUtil.checkIfCorelatedPairExists((String)userName, (String)computerName, (String)domainName).booleanValue()) {
                        userLastUncorrelatedRowMap = UWHCrunchUtil.getInstance().getUserLastUncorrelatedEvents(userName, computerName, domainName, Boolean.valueOf(false), this.uwhCrunchProcess);
                    }
                    DefaultLogonParser parser = null;
                    int i = 0;
                    boolean insertedcount = false;
                    while (resultSet.next()) {
                        Integer eventNumber = (Integer)resultSet.getObject("EVENT_NUMBER");
                        String logonId = resultSet.getObject("LOGON_ID").toString();
                        HashMap<String, Object> crunchMap = new HashMap<String, Object>();
                        crunchMap.put("EVENT_NUMBER", eventNumber);
                        crunchMap.put("LOGON_ID", logonId);
                        crunchMap.put("TIME_GENERATED", new Long(resultSet.getObject("TIME_GENERATED").toString()));
                        lastCorrelatedPairTime = this.uwhShiftHoursHandler.setLastCorrelatedPairTime(Long.valueOf(lastCorrelatedPairTime), new Long(resultSet.getObject("TIME_GENERATED").toString()), userName, computerName, domainName, this.uwhCrunchProcess);
                        crunchMap.put("USER_OU_GUID", resultSet.getObject("USER_OU_GUID"));
                        crunchMap.put("USER_DISTINGUISH_NAME", resultSet.getObject("USER_DISTINGUISH_NAME"));
                        parser = UWHCrunchUtil.getInstance().getParser(eventNumber);
                        ArrayList list = parser.getRows(userName, computerName, domainName, logonId, crunchMap, userLastUncorrelatedRowMap, lastCorrelatedPairTime, this.uwhCrunchProcess);
                        if (null != list && !list.isEmpty()) {
                            HashMap<String, Object> procesedEventTable = null;
                            this.addRows(list, domainName, procesedEventTable);
                        }
                        ++i;
                        lastCorrelatedPairTime = this.uwhCrunchProcess.getLastCorrelatedPairTime();
                    }
                    if (parser != null) {
                        parser.addUserCurrentUncorrelatedEvent(userName, computerName, domainName, this.uwhCrunchProcess);
                    }
                    this.uwhCrunchBookmarkHandler.updateStatusInBookmarkforUtil(userName, computerName, domainName, lastCorrelatedPairTime);
                    this.uwhUncorrelatedDataHandler.deletedRecentCorrelatedRows(userName, computerName, domainName, lastCorrelatedPairTime);
                    lastCorrelatedPairTime = -1L;
                }
                catch (Exception ex) {
                    try {
                        ex.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        DataCruncher.closeConnection((Connection)connection, pstatement, resultSet);
                        throw throwable;
                    }
                    DataCruncher.closeConnection((Connection)connection, (PreparedStatement)pstatement, resultSet);
                    continue;
                }
                DataCruncher.closeConnection((Connection)connection, (PreparedStatement)pstatement, (ResultSet)resultSet);
                continue;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getGroupByQuery(long startTimeUnixTime, String tableName) {
        String query = "";
        String timeCriteria = "TIME_GENERATED > " + startTimeUnixTime;
        try {
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:15091");
            DataObject dataObject = AUDCustomViewAPI.getInstance().getCustomViewDO(cvId);
            if (dataObject.size("AUDUnionQuery") > 0) {
                Row sqlRow = dataObject.getRow("AUDSQLQuery");
                query = (String)sqlRow.get("SQL_STRING");
                Row unionRow = dataObject.getRow("AUDUnionQuery");
                String unionQuery = (String)unionRow.get("UNION_QUERY");
                String repQuery = null;
                Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)startTimeUnixTime, 6);
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"END_TIME"), (Object)startTimeUnixTime, 4));
                crit = crit.or(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)0, 0));
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"), (Object)tableName, 0));
                DataObject dObj = DataAccess.get((String)"AUDMetaTable", (Criteria)crit);
                Iterator iter = dObj.getRows("AUDMetaTable");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    String lookupTableName = (String)row.get("LOOKUP_TABLENAME");
                    if (repQuery == null) {
                        repQuery = "( " + unionQuery.replace("${TABLE:AUDLogonLogoffInfo}", lookupTableName) + " )";
                        continue;
                    }
                    repQuery = repQuery + " union all (" + unionQuery.replace("${TABLE:AUDLogonLogoffInfo}", lookupTableName) + " )";
                }
                String columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString((Long)cvId);
                query = query.replace("${UNION_QUERY}", repQuery);
                query = query.replace("${SCRITERIA}", "1=1");
                query = query.replace("${COLUMNS}", columnString);
                query = query.replace("UNIQUE_ID BETWEEN ${MIN} AND ${MAX}", timeCriteria);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return query;
    }

    public String getCrunchQuery(String userName, String computerName, String domainName, long startTimeUnixTime, String tableName) {
        String query = "";
        String timeCriteria = "TIME_GENERATED > " + startTimeUnixTime;
        try {
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:15090");
            DataObject dataObject = AUDCustomViewAPI.getInstance().getCustomViewDO(cvId);
            if (dataObject.size("AUDUnionQuery") > 0) {
                Row sqlRow = dataObject.getRow("AUDSQLQuery");
                query = (String)sqlRow.get("SQL_STRING");
                Row unionRow = dataObject.getRow("AUDUnionQuery");
                String unionQuery = (String)unionRow.get("UNION_QUERY");
                unionQuery = this.replaceQuery(userName, computerName, domainName, cvId, unionQuery, startTimeUnixTime);
                String repQuery = null;
                Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)startTimeUnixTime, 6);
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"END_TIME"), (Object)startTimeUnixTime, 4));
                crit = crit.or(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)0, 0));
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"), (Object)tableName, 0));
                DataObject dObj = DataAccess.get((String)"AUDMetaTable", (Criteria)crit);
                Iterator iter = dObj.getRows("AUDMetaTable");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    String lookupTableName = (String)row.get("LOOKUP_TABLENAME");
                    if (repQuery == null) {
                        repQuery = "( " + unionQuery.replace("${TABLE:AUDLogonLogoffInfo}", lookupTableName) + " )";
                        continue;
                    }
                    repQuery = repQuery + " union all (" + unionQuery.replace("${TABLE:AUDLogonLogoffInfo}", lookupTableName) + " )";
                }
                String columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString((Long)cvId);
                query = query.replace("${COLUMNS}", columnString);
                query = query.replace("${UNION_QUERY}", repQuery);
                query = query.replace("UNIQUE_ID BETWEEN ${FROM} AND ${TO}", timeCriteria);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return query;
    }

    public String replaceQuery(String userName, String computerName, String domainName, Long cvId, String query, long startTimeUnixTime) {
        String retQuery = query;
        try {
            String domainDNSName = domainName;
            String domainFlatName = domainName;
            DataObject dataObject = DomainHandler.getDomainDetailsDO((String)domainName);
            if (dataObject != null && !dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADSMDomainConfiguration");
                domainDNSName = (String)row.get("DOMAIN_DNS_NAME");
                domainFlatName = (String)row.get("DOMAIN_FLAT_NAME");
            }
            if (userName.contains("'")) {
                userName = userName.replace("'", "''");
            }
            String columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString((Long)cvId);
            StringBuilder sourceName = new StringBuilder();
            sourceName = sourceName.append("'");
            sourceName = sourceName.append(computerName);
            sourceName = sourceName.append("'");
            retQuery = retQuery.replace("${domainDNSName}", domainDNSName);
            retQuery = retQuery.replace("${domainFlatName}", domainFlatName);
            retQuery = retQuery.replace("${objectName}", sourceName.toString());
            retQuery = retQuery.replace("${USERNAME}", userName);
            retQuery = retQuery.replace("${SCRITERIA}", "1=1");
            retQuery = retQuery.replace("${COLUMNS}", columnString);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retQuery;
    }

    public void addRows(ArrayList<Row> list, String domainName, HashMap<String, Object> procesedEventTable) {
        try {
            EventManager.getInstance().addEventRows(list, domainName, procesedEventTable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Boolean isOldUncorrelationMethodNeeded() {
        try {
            Long ppmTimeDifference = System.currentTimeMillis() / 1000L - this.ppmAppliedTime;
            if (ppmTimeDifference <= 1296000L) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void deleteOldCrunchedData(long startTimeUnixTime) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)startTimeUnixTime, 6);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"END_TIME"), (Object)startTimeUnixTime, 4));
            crit = crit.or(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)0, 0));
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"), (Object)"AUDUserActiveTimeInfo", 0));
            DataObject dObj = DataAccess.get((String)"AUDMetaTable", (Criteria)crit);
            Iterator iter = dObj.getRows("AUDMetaTable");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String underScoreTableName = (String)row.get("LOOKUP_TABLENAME");
                StringBuilder deleteQuery = new StringBuilder();
                deleteQuery = deleteQuery.append("DELETE FROM ");
                deleteQuery = deleteQuery.append(underScoreTableName);
                deleteQuery = deleteQuery.append(" WHERE TIME_GENERATED >= ");
                deleteQuery = deleteQuery.append(startTimeUnixTime);
                QueryUtil.executeSingleQuery((String)"", (String)deleteQuery.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

