-- complain if script is sourced in psql, rather than via CREATE EXTENSION
\echo Use "CREATE EXTENSION pgadmin" to load this file. \quit

CREATE FUNCTION change_password(pwd TEXT) RETURNS BOOLEAN AS $$
DECLARE uname TEXT DEFAULT SESSION_USER;
BEGIN
       IF (pwd IS NULL) OR (pwd = '') THEN
              RETURN false;
       END IF;
       EXECUTE 'ALTER USER ' || quote_ident(uname) || ' WITH ENCRYPTED PASSWORD ' || quote_literal(pwd);
       RETURN true;
END
$$ LANGUAGE plpgsql SECURITY DEFINER;
